 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kdarwin.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kdarwin_get_args
| 
|       Purpose: Gets command line args for kdarwin
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdarwin
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kdarwin_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kdarwin is out of sync with arguments specified in kdarwin's *.pane file; please rerun ghostwriter on kdarwin.";


	/*
	 * allocate the kdarwin structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "lname",
			  &(clui_info->lname_string),
			  &(clui_info->lname_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "cat",
			  &(clui_info->cat_string),
			  &(clui_info->cat_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "subcat",
			  &(clui_info->subcat_string),
			  &(clui_info->subcat_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "description",
			  &(clui_info->description_string),
			  &(clui_info->description_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "icon",
			  &(clui_info->icon_string),
			  &(clui_info->icon_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "prog",
			  &(clui_info->prog_file),
			  &(clui_info->prog_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "pane",
			  &(clui_info->pane_file),
			  &(clui_info->pane_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "conf",
			  &(clui_info->conf_file),
			  &(clui_info->conf_flag))))
	{
	    kerror(NULL, "kdarwin_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



