 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for mgdiag
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lmgdiag
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lmgdiag - generate a diagonal matrix
* 
*       Purpose: Generate a diagonal matrix (possible non-square) of
*                a specified data type and with either a constant
*                diagonal value (vec_obj == NULL) or non-constant values
*                (vec_obj != NULL). Matrix size is specified by r and c.
*                A non-NULL vec_obj overrides any values for cr and ci.
*
*         Input: vec_obj - (kobject) vector of diagonal values
*                r - number of rows in diagonal matrix
*                c - number of columns in diagonal matrix
*                cr - real part of constant diagonal value
*                ci - imaginary part of constant diagonal value
*                type - data type for matrix (FLOAT,DOUBLE,COMPLEX,DCOMPLEX)
*
*        Output: out_obj - output matrix object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Scott Wilson
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int 
lmgdiag(
kobject vec_obj,
int r,
int c,
double cr,
double ci,
int type,
kobject out_obj)
/* -library_def_end */

/* -library_code */
  {
    char *lib = "kmatrix", *rtn = "lmgdiag";
    kdcomplex *AZ=NULL;
    int count;
    int i,j;
    int wc,hc,dc,tc,ec;
    int d,t,e;
    klist *objlist=NULL;

    /* Make sure we have a valid output object */
    if (out_obj == KOBJECT_INVALID)
      {
        kerror(lib, rtn, "Bogus output object");
        return(FALSE);
      }

    /* See if we're going to use a diagonal vector or constant values
       and branch to the appropriate code. */
    if (vec_obj == KOBJECT_INVALID) /* Constant diagonal elements */
      {

        /* Get a single complex double and load it with the const value */
        KCALL(!((AZ=(kdcomplex *)kmalloc(1*sizeof(kdcomplex)))== NULL));
        objlist = klist_add(objlist,AZ,"KMALLOC");
        AZ[0].r = cr;
        AZ[0].i = ci;

        /* Create the value segment if it's not already there */
        if (!kpds_query_value(out_obj)) kpds_create_value(out_obj);

        /* Set the size and type of the output object */
        KCALL(kpds_set_attributes(out_obj,KPDS_VALUE_SIZE,c,r,1,1,1,
                                           KPDS_VALUE_DATA_TYPE,type,NULL));
        kpds_initialize_value(out_obj,0.0,0.0);
        KCALL((out_obj = kpds_reference_object(out_obj)));
        objlist = klist_add(objlist,out_obj,"KOBJECT");

        /* Set presentation data type to double complex */
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_DATA_TYPE,KDCOMPLEX));

        /* Change region size to 1x1 */
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_REGION_SIZE,1,1,1,1,1));

        /* Plop the constant value into each diagonal element */
        count = r;
        if (c < count) count = c;
        for (i=0; i<count; i++)
          {
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,i,i,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)AZ));
          }
      }
    else /* Vector of diagonal elements case */
      {
        /* Reference the input object first thing off */
        KCALL((vec_obj = kpds_reference_object(vec_obj)));
        objlist = klist_add(objlist,vec_obj,"KOBJECT");

        /* Set up the data type for reading and get the size */
        KCALL(kpds_set_attribute(vec_obj,KPDS_VALUE_DATA_TYPE,KDCOMPLEX));
        KCALL(kpds_get_attribute(vec_obj,KPDS_VALUE_SIZE,&wc,&hc,&dc,&tc,&ec));

        /* Create the value segment if it's not already there */
        if (!kpds_query_value(out_obj)) kpds_create_value(out_obj);

        /* Set the size, type, and region size for output */
        KCALL(kpds_set_attributes(out_obj, KPDS_VALUE_SIZE,c,r,dc,tc,ec,
                                           KPDS_VALUE_DATA_TYPE,type,NULL));
        KCALL((out_obj = kpds_reference_object(out_obj)));
        objlist = klist_add(objlist,out_obj,"KOBJECT");
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_REGION_SIZE,1,1,1,1,1));

        /* Set presentation data type to double complex */
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_DATA_TYPE,KDCOMPLEX));

        /* Set the type, and region size for input */
        KCALL(kpds_set_attribute(vec_obj,KPDS_VALUE_DATA_TYPE,KDCOMPLEX));
        KCALL(kpds_set_attribute(vec_obj,KPDS_VALUE_REGION_SIZE,wc,hc,1,1,1));

        /* Initialize value segment to all zeros first */
        kpds_initialize_value(out_obj,0.0,0.0);

        /* Get a complex double work array */
        KCALL(!((AZ=(kdcomplex *)kmalloc(wc*hc*sizeof(kdcomplex)))== NULL));
        objlist = klist_add(objlist,AZ,"KMALLOC");

        count = r;
        if (c < count) count = c;
        if (wc*hc < count) count = wc*hc;
        for (e=0; e<ec; e++)
          {
            for (t=0; t<tc; t++)
              {
                for (d=0; d<dc; d++)
                  {
                    /* Read a plane of the vector data, then go thru and
                       plop it into the diagonal elements */
                       AZ=(kdcomplex *)kpds_get_data(vec_obj,KPDS_VALUE_REGION,(kaddr)AZ);
                    for (j=0; j<count; j++)
                      {
                        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,j,j,d,t,e));
                        KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)(AZ+j)));
                      }
                  }
              }
          }
      }

    (void)klist_free(objlist, (kfunc_void)lkcall_free);
    return TRUE;
  }
/* -library_code_end */
