 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for mextract_diag
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lmextract_diag
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lmextract_diag - extract row, column, or diagonal from a matrix
* 
*       Purpose: lmextract_diag is used to extract a row, column
*                 or the diagonal from a matrix.
*
*         Input: kobject in_obj - input matrix object
*                int row_flag - if non-zero, extract specified row
*                int col_flag - if non-zero, extract specified column
*                int diag_flag - if non-zero, extract diagonal
*                int num - number of row or column to extract
*
*        Output: kobject out_obj - output object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Scott Wilson
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lmextract_diag(
kobject in_obj,
int row_flag,
int col_flag,
int diag_flag,
int num,
kobject out_obj)
/* -library_def_end */

/* -library_code */
{
        char *lib = "kmatrix", *rtn = "lmextract_diag";
        double *A=NULL,*S=NULL;
        kdcomplex *AZ=NULL,*SZ=NULL;
        int i,n,nplanes;
        int type, otype;
        int wc,hc,dc,tc,ec;
        int wo,ho;
        int s_len;
        klist *objlist=NULL;

        /* Make sure we have valid objects */
        if (in_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus input object");
            return(FALSE);
          }
        if (out_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus output object");
            return(FALSE);
          }

        /* Make sure we have something to do */
        if (row_flag == 0 && col_flag == 0 && diag_flag == 0)
          {
            kerror(lib, rtn, "Nothing to do");
            return(FALSE);
          }
        i = 0;
        if (row_flag) i++;
        if (col_flag) i++;
        if (diag_flag) i++;
        if (i != 1)
          {
            kerror(lib, rtn, "Can only extract one thing at a time!");
            return(FALSE);
          }

        /* Reference the input object to avoid side effects, then add the
           reference to the list of goodies to be autmatically free'd on
           error. */
        KCALL((in_obj = kpds_reference_object(in_obj)));
        objlist = klist_add(objlist,in_obj,"KOBJECT");

        /* See if the data type of the input object is real or complex */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_DATA_TYPE,&type));
        if (type == KCOMPLEX || type == KDCOMPLEX) otype = KDCOMPLEX;
        else otype = KDOUBLE;

        /* Constrain the input data to double real or double complex for read */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_DATA_TYPE, otype));

        /* See how big the data is */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_SIZE,&wc,&hc,&dc,&tc,&ec));
        /* Set up to process input by planes */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_REGION_SIZE,wc,hc,1,1,1));
        nplanes = dc*tc*ec;

        /* Make sure the row/col is in bounds */
        if ((row_flag && num >= hc) || (col_flag && num >= wc))
          {
            kerror(lib, rtn, "Row or column out of bounds");
            (void)klist_free(objlist,(kfunc_void)lkcall_free);
            return(FALSE);
          }

        if (diag_flag)
          {
            s_len = kmin(wc,hc);
            wo = s_len;
            ho = 1;
          }
        else if (row_flag)
          {
            s_len = wc;
            wo = wc;
            ho = 1;
          }
        else
          {
            s_len = hc;
            wo = 1;
            ho = hc;
          }

        /* Set the output object size and data type */
        if (!kpds_query_value(out_obj)) KCALL(kpds_create_value(out_obj));
        KCALL(kpds_set_attributes(out_obj,
                             KPDS_VALUE_SIZE,wo,ho,dc,tc,ec,
                             KPDS_VALUE_DATA_TYPE,otype,NULL));
        KCALL((out_obj = kpds_reference_object(out_obj)));
        objlist = klist_add(objlist,out_obj,"KOBJECT");
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_REGION_SIZE,
                                        wo,ho,1,1,1));

        /* Allocate buffers */
        if (otype == KDOUBLE)
          {
            KCALL(!((A=(double *)kmalloc(wc*hc*sizeof(double))) == NULL));
            objlist = klist_add(objlist,A,"KMALLOC");
            KCALL(!((S=(double *)kmalloc(s_len*sizeof(double))) == NULL));
            objlist = klist_add(objlist,S,"KMALLOC");
          }
        else
          {
            KCALL(!((AZ=(kdcomplex *)kmalloc(wc*hc*sizeof(kdcomplex)))== NULL));
            objlist = klist_add(objlist,AZ,"KMALLOC");
            KCALL(!((SZ=(kdcomplex *)kmalloc(s_len*sizeof(kdcomplex)))==NULL));
            objlist = klist_add(objlist,SZ,"KMALLOC");
          }

        for (n=0; n<nplanes; n++)
          {
            /* Get a plane from the input object */
            if (otype == KDOUBLE)
              A = (double *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)A);
            else
              AZ=(kdcomplex *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)AZ);

            if (diag_flag) /* Pull out diagonal */
              {
                if (otype == KDOUBLE)
                  {
                    for (i=0; i<s_len; i++) 
                      S[i] = A[i*wc+i];
                  }
                else
                  {
                    for (i=0; i<s_len; i++) 
                      SZ[i] = AZ[i*wc+i];
                  }
              }
            else if (row_flag) /* Pull out row */
              {
                if (otype == KDOUBLE)
                  {
                    for (i=0; i<s_len; i++)
                      S[i] = A[num*wc+i];
                  }
                else
                  {
                    for (i=0; i<s_len; i++)
                      SZ[i] = AZ[num*wc+i];
                  }
              }
            else /* Pull out col */
              {
                if (otype == KDOUBLE)
                  {
                    for (i=0; i<s_len; i++)
                      S[i] = A[i*wc+num];
                  }
                else
                  {
                    for (i=0; i<s_len; i++)
                      SZ[i] = AZ[i*wc+num];
                  }
              }

            if (otype == KDOUBLE)
              {
                KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)S));
              }
            else
              {
                KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)SZ));
              }
          }

        (void)klist_free(objlist, (kfunc_void)lkcall_free);

	return TRUE;
}
/* -library_code_end */
