 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for msvd
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "msvd.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute Singular Value Decomposition (SVD)
|
|       Purpose: main program for msvd
|
|         Input:
|		char *clui_info->i_file; {Input matrix}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o1_file; {Output matrix U}
|		int   clui_info->o1_flag; {TRUE if -o1 specified}
|
|		char *clui_info->o2_file; {Output matrix S}
|		int   clui_info->o2_flag; {TRUE if -o2 specified}
|
|		char *clui_info->o3_file; {Output matrix V}
|		int   clui_info->o3_flag; {TRUE if -o3 specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj = NULL;
kobject u_obj = NULL;
kobject s_obj = NULL;
kobject v_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(msvd_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "msvd",
		msvd_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	msvd_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("msvd","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->o1_flag)
          {
            if ((u_obj = kpds_open_output_object(clui_info->o1_file))
                    == KOBJECT_INVALID)
              {
                kerror("msvd","main", "Cannot open output object.");
                kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj, u_obj))
              {
                kerror("msvd","main",
                  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }
        if (clui_info->o2_flag)
          {
            if ((s_obj = kpds_open_output_object(clui_info->o2_file))
                == KOBJECT_INVALID)
              {
                 kerror("msvd","main", "Cannot open output object.");
                 kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj, s_obj))
              {
                kerror("msvd","main",
                  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }
        if (clui_info->o3_flag)
          {
            if ((v_obj = kpds_open_output_object(clui_info->o3_file))
                == KOBJECT_INVALID)
              {
                 kerror("msvd","main", "Cannot open output object.");
                 kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj, v_obj))
              {
                kerror("msvd","main",
                  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lmsvd(in_obj,u_obj,s_obj,v_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output objects and write */
        if (clui_info->o1_flag)
          {
            if (!kpds_set_attribute(u_obj,KPDS_HISTORY,kpds_history_string()))
              {
                kerror("msvd", "main","Unable to set history on output object");
                kexit(KEXIT_FAILURE);
              }
            kpds_close_object(u_obj);
          }
        if (clui_info->o2_flag)
          {
            if (!kpds_set_attribute(s_obj,KPDS_HISTORY,kpds_history_string()))
              {
                kerror("msvd", "main","Unable to set history on output object");
                kexit(KEXIT_FAILURE);
              }
            kpds_close_object(s_obj);
          }
        if (clui_info->o3_flag)
          {
            if (!kpds_set_attribute(v_obj,KPDS_HISTORY,kpds_history_string()))
              {
                kerror("msvd", "main","Unable to set history on output object");
                kexit(KEXIT_FAILURE);
              }
            kpds_close_object(v_obj);
          }

        kpds_close_object(in_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: msvd_usage_additions
| 
|       Purpose: Prints usage additions in msvd_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname msvd
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void msvd_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute Singular Value Decomposition (SVD)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: msvd_free_args
| 
|       Purpose: Frees CLUI struct allocated in msvd_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname msvd
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
msvd_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o1_file);
	kfree(clui_info->o2_file);
	kfree(clui_info->o3_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
