 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for minvert
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "minvert.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute Inverse Matrix
|
|       Purpose: main program for minvert
|
|         Input:
|		char *clui_info->i_file; {Input matrix}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Output matrix}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->diag_flag; {TRUE if -diag specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson 13 Aug 1994
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj = NULL;
kobject out_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(minvert_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "minvert",
		minvert_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	minvert_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("minvert","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
          {
            kerror("minvert","main", "Cannot open output object.");
            kexit(KEXIT_FAILURE);
          }
        if (!kpds_copy_object_attr(in_obj, out_obj))
          {
            kerror("minvert","main",
              "Unable to copy attributes from input to output object.");
            kexit(KEXIT_FAILURE);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lminvert(in_obj,clui_info->diag_flag,out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        if (!kpds_set_attribute(out_obj,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("minvert", "main","Unable to set history on output object");
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: minvert_usage_additions
| 
|       Purpose: Prints usage additions in minvert_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname minvert
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void minvert_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute Inverse Matrix\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: minvert_free_args
| 
|       Purpose: Frees CLUI struct allocated in minvert_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname minvert
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
minvert_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
