 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for itexture
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "itexture.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Texture Feature Extraction Using LAW Metrics
|
|       Purpose: main program for itexture
|
|         Input:
|		char *clui_info->i_file; {input object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Loose group:
|		    int clui_info->L5L5_flag; {TRUE if -L5L5 specified}
|
|		    int clui_info->E5L5_flag; {TRUE if -E5L5 specified}
|
|		    int clui_info->S5L5_flag; {TRUE if -S5L5 specified}
|
|		    int clui_info->W5L5_flag; {TRUE if -W5L5 specified}
|
|		    int clui_info->R5L5_flag; {TRUE if -R5L5 specified}
|
|		    int clui_info->L5E5_flag; {TRUE if -L5E5 specified}
|
|		    int clui_info->E5E5_flag; {TRUE if -E5E5 specified}
|
|		    int clui_info->S5E5_flag; {TRUE if -S5E5 specified}
|
|		    int clui_info->W5E5_flag; {TRUE if -W5E5 specified}
|
|		    int clui_info->R5E5_flag; {TRUE if -R5E5 specified}
|
|		    int clui_info->L5S5_flag; {TRUE if -L5S5 specified}
|
|		    int clui_info->E5S5_flag; {TRUE if -E5S5 specified}
|
|		    int clui_info->S5S5_flag; {TRUE if -S5S5 specified}
|
|		    int clui_info->W5S5_flag; {TRUE if -W5S5 specified}
|
|		    int clui_info->R5S5_flag; {TRUE if -R5S5 specified}
|
|		    int clui_info->L5W5_flag; {TRUE if -L5W5 specified}
|
|		    int clui_info->E5W5_flag; {TRUE if -E5W5 specified}
|
|		    int clui_info->S5W5_flag; {TRUE if -S5W5 specified}
|
|		    int clui_info->W5W5_flag; {TRUE if -W5W5 specified}
|
|		    int clui_info->R5W5_flag; {TRUE if -R5W5 specified}
|
|		    int clui_info->L5R5_flag; {TRUE if -L5R5 specified}
|
|		    int clui_info->E5R5_flag; {TRUE if -E5R5 specified}
|
|		    int clui_info->S5R5_flag; {TRUE if -S5R5 specified}
|
|		    int clui_info->W5R5_flag; {TRUE if -W5R5 specified}
|
|		    int clui_info->R5R5_flag; {TRUE if -R5R5 specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson (stolen from K2.0.1 RETRO toolbox)
|          Date: Apr 11, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj = NULL;
kobject out_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(itexture_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "itexture",
		itexture_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	itexture_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("itexture","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
        {
           kerror("itexture","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }
 
        if (!kpds_copy_object_attr(in_obj, out_obj))
        {
           kerror("itexture","main",
                  "Unable to copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
if(! litexture(in_obj,
               clui_info->L5L5_flag,
               clui_info->L5E5_flag,
               clui_info->L5S5_flag,
               clui_info->L5W5_flag,
               clui_info->L5R5_flag,
               clui_info->E5L5_flag,
               clui_info->E5E5_flag,
               clui_info->E5S5_flag,
               clui_info->E5W5_flag,
               clui_info->E5R5_flag,
               clui_info->S5L5_flag,
               clui_info->S5E5_flag,
               clui_info->S5S5_flag,
               clui_info->S5W5_flag,
               clui_info->S5R5_flag,
               clui_info->W5L5_flag,
               clui_info->W5E5_flag,
               clui_info->W5S5_flag,
               clui_info->W5W5_flag,
               clui_info->W5R5_flag,
               clui_info->R5L5_flag,
               clui_info->R5E5_flag,
               clui_info->R5S5_flag,
               clui_info->R5W5_flag,
               clui_info->R5R5_flag,
               out_obj))
 {
  (void) kfprintf(kstderr,"ERROR, lvtexture failed\n");
  kexit(KEXIT_FAILURE);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("itexture", "main",
                  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
        }
 
        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: itexture_usage_additions
| 
|       Purpose: Prints usage additions in itexture_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname itexture
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void itexture_usage_additions(void)
{
	kfprintf(kstderr, "\tTexture Feature Extraction Using LAW Metrics\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: itexture_free_args
| 
|       Purpose: Frees CLUI struct allocated in itexture_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname itexture
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
itexture_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
