 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "irotate.h"
/*-----------------------------------------------------------
| 
|  Routine Name: irotate_get_args
| 
|       Purpose: Gets command line args for irotate
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname irotate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void irotate_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for irotate is out of sync with arguments specified in irotate's *.pane file; please rerun ghostwriter on irotate.";


	/*
	 * allocate the irotate structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "angle",
			  &(clui_info->angle_double),
			  &(clui_info->angle_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "resize",
			  &(clui_info->resize_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "planes",
			  &(clui_info->planes_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wc",
			  &(clui_info->wc_double),
			  &(clui_info->wc_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "wctr",
			  &(clui_info->wctr_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "hc",
			  &(clui_info->hc_double),
			  &(clui_info->hc_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hctr",
			  &(clui_info->hctr_flag))))
	{
	    kerror(NULL, "irotate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



