 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for igeowarp
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _igeowarp_h_
#define _igeowarp_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <image.h>

/* -include_includes */
#include <dataserv.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$IMAGE/objects/kroutine/igeowarp/uis/igeowarp.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data object (required infile)
 */
char	*i_file;	/* Input data object FILENAME */
int	 i_flag;	/* Input data object FLAG */

/*
 *  Output data object (required outfile)
 */
char	*o_file;	/* Output data object FILENAME */
int	 o_flag;	/* Output data object FLAG */

/*----- required ME group ----*/
/*
 *  W warp function coeffs object (optional infile)
 */
char	*wcoeffs_file;	/* W warp function coeffs object FILENAME */
int	 wcoeffs_flag;	/* W warp function coeffs object FLAG */

	/*---- nested optional MI group ----*/
/*
 *  A00 (W warp function, constant term) (optional double)
 */
double	 a00_double;	/* A00 (W warp function, constant term) DOUBLE */
int	 a00_flag;   	/* A00 (W warp function, constant term) FLAG */

/*
 *  A01 (W warp function, w term) (optional double)
 */
double	 a01_double;	/* A01 (W warp function, w term) DOUBLE */
int	 a01_flag;   	/* A01 (W warp function, w term) FLAG */

/*
 *  A10 (W warp function, h term) (optional double)
 */
double	 a10_double;	/* A10 (W warp function, h term) DOUBLE */
int	 a10_flag;   	/* A10 (W warp function, h term) FLAG */

/*
 *  A11 (W warp function, wh term) (optional double)
 */
double	 a11_double;	/* A11 (W warp function, wh term) DOUBLE */
int	 a11_flag;   	/* A11 (W warp function, wh term) FLAG */

	/*-- nested optional MI group end --*/

/*-- required ME group end ---*/

/*----- required ME group ----*/
/*
 *  H warp function coeffs object (optional infile)
 */
char	*hcoeffs_file;	/* H warp function coeffs object FILENAME */
int	 hcoeffs_flag;	/* H warp function coeffs object FLAG */

	/*---- nested optional MI group ----*/
/*
 *  B00 (H warp function, constant term) (optional double)
 */
double	 b00_double;	/* B00 (H warp function, constant term) DOUBLE */
int	 b00_flag;   	/* B00 (H warp function, constant term) FLAG */

/*
 *  B01 (H warp function, w term) (optional double)
 */
double	 b01_double;	/* B01 (H warp function, w term) DOUBLE */
int	 b01_flag;   	/* B01 (H warp function, w term) FLAG */

/*
 *  B10 (H warp function, h term) (optional double)
 */
double	 b10_double;	/* B10 (H warp function, h term) DOUBLE */
int	 b10_flag;   	/* B10 (H warp function, h term) FLAG */

/*
 *  B11 (H warp function, wh term) (optional double)
 */
double	 b11_double;	/* B11 (H warp function, wh term) DOUBLE */
int	 b11_flag;   	/* B11 (H warp function, wh term) FLAG */

	/*-- nested optional MI group end --*/

/*-- required ME group end ---*/

/*
 *  Process data by full planes instead of small prisms (optional flag)
 */
int	 planes_flag;  	/* Process data by full planes instead of small prisms FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void igeowarp_get_args PROTO((kform *));
void igeowarp_usage_additions PROTO((void));
void igeowarp_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
