
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/
/*
   
This code is a derivative work of that produced by J. Leech of UNC.

*/


/*% cc -g sphere.c -o sphere -lm
 *
 * sphere - generate a triangle mesh approximating a sphere by
 *  recursive subdivision. First approximation is an octahedron;
 *  each level of refinement increases the number of triangles by
 *  a factor of 4.
 * Level 3 (128 triangles) is a good tradeoff if gouraud
 *  shading is used to render the database.
 *
 * Usage: sphere [level] [-p] [-c]
 *	level is an integer >= 1 setting the recursion level (default 1).
 *	-p causes generation of a PPHIGS format ASCII archive
 *	    instead of the default generic output format.
 *	-c causes triangles to be generated with vertices in counterclockwise
 *	    order as viewed from the outside in a RHS coordinate system.
 *	    The default is clockwise order.
 *
 *  The subroutines print_object() and print_triangle() should
 *  be changed to generate whatever the desired database format is.
 *
 * Jon Leech (leech@cs.unc.edu) 3/24/89
 *
 *
 * hacked into submission for khoros renderer  summer 1993
 * 
 */

#include <design.h>
#include <geometry.h>
#include "poly.h"

typedef struct {
    double  x, y, z;
} point;

typedef struct {
    point     pt[3];	/* Vertices of triangle */
    double    area;	/* Unused; might be used for adaptive subdivision */
} triangle;

typedef struct {
    int       npoly;	/* # of triangles in object */
    triangle *poly;	/* Triangles */
} object;

/* Six equidistant points lying on the unit sphere */
#define XPLUS {  1,  0,  0 }	/*  X */
#define XMIN  { -1,  0,  0 }	/* -X */
#define YPLUS {  0,  1,  0 }	/*  Y */
#define YMIN  {  0, -1,  0 }	/* -Y */
#define ZPLUS {  0,  0,  1 }	/*  Z */
#define ZMIN  {  0,  0, -1 }	/* -Z */

/* Vertices of a unit octahedron */
triangle octahedron[] = {
    { { XPLUS, ZPLUS, YPLUS }, 0.0 },
    { { YPLUS, ZPLUS, XMIN  }, 0.0 },
    { { XMIN , ZPLUS, YMIN  }, 0.0 },
    { { YMIN , ZPLUS, XPLUS }, 0.0 },
    { { XPLUS, YPLUS, ZMIN  }, 0.0 },
    { { YPLUS, XMIN , ZMIN  }, 0.0 },
    { { XMIN , YMIN , ZMIN  }, 0.0 },
    { { YMIN , XPLUS, ZMIN  }, 0.0 }
};

/* A unit octahedron */
object oct = {
    sizeof(octahedron) / sizeof(octahedron[0]),
    &octahedron[0]
};


/* Forward declarations */
static point *normalize PROTO(( point *));
static point *midpoint PROTO((point *, point *));
static void print_object PROTO((object *, int ));
static void print_triangle PROTO((triangle *));
#if 0
static void pphigs_header(/* int */);
static void pphigs_trailer();

extern char *malloc(/* unsigned */);
#endif

static int tri_ptr;
static vertex_3d screen_translate;
static vertex_3d view_translate;
static float view_scale,screen_scale;
static float rgba[4];
static Poly *sphere_tess;

int
sphere_tesselator(
int subdivisions,
float *sphere_color,
Poly *poly_list)
{
    object *old,
	   *new;
    int     ccwflag = 0,	/* Reverse vertex order if true */
	    i,
	    level,		/* Current subdivision level */
	    maxlevel = 1;	/* Maximum subdivision level */

    float *tf;

    tri_ptr = 0;
    maxlevel = subdivisions;
    sphere_tess = poly_list;
#if 0    
    for (i=0;i<3;i++)
	screen_translate.v[i] = center_screen->v[i];
    for (i=0;i<3;i++)
	view_translate.v[i] = center_view->v[i];
    
    view_scale = view_radius;
    screen_scale = screen_radius;
#endif    
    for (i=0;i<4;i++)
	rgba[i] = sphere_color[i];
    
    if (ccwflag) {
	/* Reverse order of points in each triangle */
	for (i = 0; i < oct.npoly; i++) {
	    point tmp;
			  tmp = oct.poly[i].pt[0];
	    oct.poly[i].pt[0] = oct.poly[i].pt[2];
	    oct.poly[i].pt[2] = tmp;
	}
    }

    old = &oct;

    /* Subdivide each starting triangle (maxlevel - 1) times */
    for (level = 1; level < maxlevel; level++) {
	/* Allocate a new object */
	new = (object *)kmalloc(sizeof(object));
	if (new == NULL) {
/*	    kfprintf(kstderr, "%s: Out of memory on subdivision level %d\n",
		av[0], level); */
	    exit(1);
	}
	new->npoly = old->npoly * 4;

	/* Allocate 4* the number of points in the current approximation */
	new->poly  = (triangle *)kmalloc(new->npoly * sizeof(triangle));
	if (new->poly == NULL) {
/*	    kfprintf(kstderr, "%s: Out of memory on subdivision level %d\n",
		av[0], level); */
	    exit(1);
	}

	/* Subdivide each triangle in the old approximation and normalize
	 *  the new points thus generated to lie on the surface of the unit
	 *  sphere.
	 * Each input triangle with vertices labelled [0,1,2] as shown
	 *  below will be turned into four new triangles:
	 *
	 *			Make new points
	 *			    a = (0+2)/2
	 *			    b = (0+1)/2
	 *			    c = (1+2)/2
	 *	  1
	 *	 /\		Normalize a, b, c
	 *	/  \
	 *    b/____\ c		Construct new triangles
	 *    /\    /\		    [0,b,a]
	 *   /	\  /  \		    [b,1,c]
	 *  /____\/____\	    [a,b,c]
	 * 0	  a	2	    [a,c,2]
	 */
	for (i = 0; i < old->npoly; i++) {
	    triangle
		 *oldt = &old->poly[i],
		 *newt = &new->poly[i*4];
	    point a, b, c;

	    a = *normalize(midpoint(&oldt->pt[0], &oldt->pt[2]));
	    b = *normalize(midpoint(&oldt->pt[0], &oldt->pt[1]));
	    c = *normalize(midpoint(&oldt->pt[1], &oldt->pt[2]));

	    newt->pt[0] = oldt->pt[0];
	    newt->pt[1] = b;
	    newt->pt[2] = a;
	    newt++;

	    newt->pt[0] = b;
	    newt->pt[1] = oldt->pt[1];
	    newt->pt[2] = c;
	    newt++;

	    newt->pt[0] = a;
	    newt->pt[1] = b;
	    newt->pt[2] = c;
	    newt++;

	    newt->pt[0] = a;
	    newt->pt[1] = c;
	    newt->pt[2] = oldt->pt[2];
	}

	if (level > 1) {
	    kfree(old->poly);
	    kfree(old);
	}

	/* Continue subdividing new triangles */
	old = new;
    }

    /* Print out resulting approximation */
    print_object(old, maxlevel);

    /* do the scale then translation */

    return(CHILL);
}

/* Normalize a point p */
static point *normalize(
point *p)
{
    static point r;
    double mag;

    r = *p;
    mag = r.x * r.x + r.y * r.y + r.z * r.z;
    if (mag != 0.0) {
	mag = 1.0 / sqrt(mag);
	r.x *= mag;
	r.y *= mag;
	r.z *= mag;
    }

    return &r;
}

/* Return the midpoint on the line between two points */
static point *midpoint(
point *a,
point *b)
{
    static point r;

    r.x = (a->x + b->x) * 0.5;
    r.y = (a->y + b->y) * 0.5;
    r.z = (a->z + b->z) * 0.5;

    return &r;
}

/* Write out all triangles in an object */
static void print_object(
object *obj,
int level)
{
    int i;
#if 0
    if (PPHIGSflag)
	pphigs_header(level);
#endif

    /* Spit out coordinates for each triangle */
    for (i = 0; i < obj->npoly; i++)
	print_triangle(&obj->poly[i]);

#if 0
    if (PPHIGSflag)
	pphigs_trailer();
#endif

}

/* Output a triangle */
static void print_triangle(
triangle *t)
{
    vertex_3d p1,p2,normal;
    double mag;
    
    int i;

    sphere_tess[tri_ptr].n = 3;
    sphere_tess[tri_ptr].mask =  POLY_MASK(sx) | POLY_MASK(sy) | POLY_MASK(sz);
    
    for (i=0;i<3;i++)
    {

	sphere_tess[tri_ptr].vert[i].sx = t->pt[i].x ;
	sphere_tess[tri_ptr].vert[i].sy = t->pt[i].y ;
	sphere_tess[tri_ptr].vert[i].sz = t->pt[i].z ;

	sphere_tess[tri_ptr].vert[i].x = t->pt[i].x;
	sphere_tess[tri_ptr].vert[i].y = t->pt[i].y;
	sphere_tess[tri_ptr].vert[i].z = t->pt[i].z;

	sphere_tess[tri_ptr].vert[i].nx = t->pt[i].x;
	sphere_tess[tri_ptr].vert[i].ny = t->pt[i].y;
	sphere_tess[tri_ptr].vert[i].nz = t->pt[i].z * -1.;

	sphere_tess[tri_ptr].vert[i].r = rgba[0];
	sphere_tess[tri_ptr].vert[i].g = rgba[1];
	sphere_tess[tri_ptr].vert[i].b = rgba[2];
	sphere_tess[tri_ptr].vert[i].a = rgba[3];
    }
    tri_ptr++;
}

