
/*********************************************************************

Copyright (C) 1993, 1994 Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  *
  * 16 June 1993, wes
  *       this file contains routines that interface between the
  *       renderered image and the outside world.
  *
  *       init_output(widht,height,do_display,output_kobject) is
  *           called: 1. upon entry to rmonster; 2. when there is
  *           a user-requested change of image size; or 3. whenever
  *           there is a change in the display status (that is,
  *           whenever the user changes their mind about if they
  *           want the image displayed on the screen by rmonster.)
  *
  *       flush_output() will typically be called from within the
  *           renderer after a scene has been rendered.  this routine
  *           will cause the contents of the current framebuffer to be
  *           dumped (either to the screen or to a file).
  *
  *       additionally, this file contains static pointers to the
  *       software framebuffer.
  *
  * 28 June 1993, wes
  *       some hack work to try out 3-3-2 images.
  *
  * 19 July 1993, wes
  *       beefing up the support for named-file output.  if the user
  *       doesn't choose to have a named file/transport for output, then
  *       we create a temporaty transport in shared memory.  at present,
  *       there is no error recovery/detection in case this fails.  the
  *       transport mechanism is necessary for xvs to display the image
  *       (it needs a bona-fide kobject, an image).  if the user does
  *       choose to have a named file/transport for output, it is used
  *       rather than using ktempnam() generated transport name.
  *
  *       added support for display of either 3-3-2 or 24bit images.
  *
  * 18 Jan 1995, wes
  *       code reorg to support on-the-fly parm changes, such as imaging
  *       dimensions, display mode, etc.
  * 
  * 14 Apr 1995, steve k modifications to speed-up on-the-fly parm
  * 	   changes.  also added best-possible option so rmonster
  * 	   doesn't mess with initial 332 if it's displaying to a 24
  * 	   bit display. also added image depth checking to prohibit
  *        24 bit display if screen won't support it.
  *
  */

/*
 * Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "design.h"

#include "geometry/geometry.h"
#include "rmonster.h"
#include "imaging.h"
#include "zbuffer.h"
#include "sort_trans.h"
#include "imaging.h"
#include "rmonster_mouse.h"

#include "xvinclude.h"
#include "xvisual/xvisual.h"

/* globals */
char rmap[256],gmap[256],bmap[256];
float *img_buffer=NULL;
int    display_depth=0;

static kobject output_kimage;
static xvobject xvimage;

static int img_width,img_height;
static int image_display_choice;
static int have_active_kobject=FALSE;
static unsigned char *bimg_buffer=NULL;
static int loc_do_display_mode;
static char transport_name[512];
static int do_named_output=TRUE;

int deinit_render_buffers PROTO((void));

int make_332_colormap PROTO((void));

int
set_do_named_output (int flag)
{
    do_named_output = flag;
    return(CHILL);
}

int
get_do_named_output (int *flag)
{
    *flag = do_named_output;
    return(CHILL);
}

int
set_output_transport_name(char *n)
{
    kstrcpy(transport_name,n);
    return(CHILL);
}

int
get_output_transport_name(char *n)
{
    kstrcpy(n,transport_name);
    return(CHILL);
}

int
set_image_display_choice(int i)
{
    image_display_choice = i;
    return(CHILL);
}

int
get_image_display_choice(int *i)
{
    *i = image_display_choice;
    return(CHILL);
}

int
set_image_dims(int w,int h)
{
    /* range check ?? */
    img_width = w;
    img_height = h;
    return(CHILL);
}

int
get_image_dims(int *w, int *h)
{
    *w = img_width;
    *h = img_height;
    return(CHILL);
}

int
set_display_depth(int d)
{
    display_depth = d;
    return(CHILL);
}

int
get_display_depth(int *d)
{
    *d = display_depth;
    return(CHILL);
}

/**
  * routines for creating, updating the user-selected image type.
  * there are separate routines for each of: 3-3-2 images, 24bit
  * images, or no-display images.
  *
  * the software renderer does its thing into a 24bit image buffer.
  * what happens in terms of display is specific to the type of
  * image display desired.  in the future, we will support two types
  * of dithering;  cheap and expensive.
**/

static void init_332_image PROTO((int, int, kobject));
static void init_24bit_image PROTO((int, int, kobject));
static void init_quant_image PROTO((int, int, kobject));
static void init_dither_image PROTO((int, int, kobject));

static void init_no_image PROTO((int, int, kobject));
static void load_332_image PROTO((kobject, float *));
static void load_24bit_image PROTO((kobject, float *));
static void load_quant_image PROTO((kobject, float *));
static void load_dither_image PROTO((kobject, float *));
static void load_no_image PROTO((kobject, float *));

static void
(*init_img_funcs[])() =
{
   init_332_image,
   init_24bit_image,
   init_quant_image,
   init_dither_image,
   init_no_image
};

static void
(*load_img_funcs[])() =
{
   load_332_image,
   load_24bit_image,
   load_quant_image,
   load_dither_image,
   load_no_image
};

/**
  * prior to calling the following routine, the following variables need
  * to have been set:
  *    1. image width and height, via set_image_dims(w,h);
**/
int
init_rmonster_output(int width,
		     int height,
		     int img_disp_choice,
		     int do_named_output,
		     char *name)
{
#if 0
   set_image_dims(width,height); 
   set_image_display_choice(img_disp_choice-1); /* UI counts from 1,
						    not zero */
#endif

    set_do_named_output(do_named_output);
    set_output_transport_name(name);

    init_render_buffers();
    init_output_object();
    return(CHILL);
}

int
shutdown_rmonster_output()
{
    xvw_destroy(xvimage);
    if (have_active_kobject)
    {
	kpds_close_object(output_kimage);
	have_active_kobject = FALSE;
    }

    deinit_render_buffers();
    return(CHILL);
}


int
deinit_render_buffers()
{
    int width,height;
    if (img_buffer != NULL)  /* free up old memory */
	kfree(img_buffer);

    /* grab space for new buffer. */

    get_image_dims(&width,&height);

    /* initialize zbuffer */
    deinit_zbuffer();

    /* initialize the abuffer */
    deinit_abuffer();
    free_bucket_zbuffer(width,height);

    return(CHILL);
}

int
init_render_buffers()
{
    int width,height;
    if (img_buffer != NULL)  /* free up old memory */
	kfree(img_buffer);

    /* grab space for new buffer. */

    get_image_dims(&width,&height);
    img_buffer = (float *)kmalloc(sizeof(float)*width*height*3);  /* RGB */
    if (img_buffer == NULL)
    {
	kerror("GEOMETRY","rmonster","Can't malloc memory for requested image size.");
	return(WHACKED);
    }
    /* initialize zbuffer */
    init_zbuffer(width,height);

    /* initialize the abuffer */
    init_abuffer(width,height);
    init_bucket_zbuffer(width,height);
    
    clear_framebuffer();
}

int
init_output_object()
{
    /* check for old object ?? */
    int do_named_output;
    char transport_name[512];
    int width,height;
    int image_display_choice;

    get_do_named_output(&do_named_output);
    get_output_transport_name(transport_name);
    
    have_active_kobject = TRUE;
    /*
     * if the user hasn't provided an output transport name, then
     * just create a temporary object for the output image.
     */
    if (do_named_output == FALSE)
       output_kimage = kpds_create_object();
    else
       output_kimage = kpds_open_object(transport_name,KOBJ_WRITE);
    
    /*  -- tell image widget to interpret data as RGB with no alpha -- */
    kcolor_set_attribute(output_kimage,KCOLOR_COLORSPACE,KRGB);
    kcolor_set_attribute(output_kimage,KCOLOR_HAS_ALPHA,FALSE);

    /* initialize the image output buffer */
    get_image_dims(&width,&height);
    get_image_display_choice(&image_display_choice);

    if (image_display_choice == sNO_DISPLAY) /* if "no display" */
    {
       (init_img_funcs[image_display_choice])(width,height,output_kimage);
       (*load_img_funcs[image_display_choice])(output_kimage,img_buffer);
    }
    else /* -- not "no display" -- */
    {
       int depth;

	/**
	  * call the routine that establishes the interaction model.
	**/
	xvimage = xvw_create_image(NULL, "image");

	/* -- backing store slows us down -- */
	xvw_set_attribute(xvimage, XVW_IMAGE_BACKING, FALSE);
	xvw_set_attribute(xvimage, XVW_MENUABLE, FALSE);

	/* -- don't want it creatin one of those pan-icon thingies -- */
	xvw_set_attribute(xvimage, XVW_MAXIMUM_WIDTH,  10000);
	xvw_set_attribute(xvimage, XVW_MAXIMUM_HEIGHT, 10000);

	/* -- get the depth of the image -- */
	xvw_get_attribute(xvimage, XVW_DEPTH, &depth);
	set_display_depth(depth);

	if (image_display_choice == -1) /* -- get best possible visual -- */
	{
	   if (depth == 24) /* -- true color is certainly best -- */
	      image_display_choice = s24_DISPLAY;
	   else  /* -- 332 is arguable not the best -- */
	      image_display_choice = s332_DISPLAY;
	}

	if (depth != 24 && image_display_choice == s24_DISPLAY)
	{
	   kinfo(KSTANDARD, "Current display does not support 24 bit images. Defaulting to 332 diaplay.");
	   image_display_choice = s332_DISPLAY;
	}

	(init_img_funcs[image_display_choice])(width,height,output_kimage);
	(*load_img_funcs[image_display_choice])(output_kimage,img_buffer);

	xvw_set_attribute(xvimage, XVW_IMAGE_IMAGEOBJ, output_kimage);
	set_up_rmonster_mouse_button_definitions(xvimage,output_kimage);

	set_image_display_choice(image_display_choice);
    }
    return(CHILL);
}

int
reinit_output_object(int new_xvimage, int new_kobject)
{
    /* check for old object ?? */
    int do_named_output;
    char transport_name[512];
    int width,height;
    int image_display_choice;

    get_image_display_choice(&image_display_choice);

#if 0
    /* -- xvisual won't work unless we recreate when going to 24 bit :( -- */
    if (image_display_choice == s24_DISPLAY)
       new_kobject = TRUE;
#endif

    /* -- !#@$%# xvisual won't work unless we recreate the kobject -- */
    new_kobject = TRUE;    /* -- this should not have to be the case -- */

    /*
     * if the user hasn't provided an output transport name, then
     * just create a temporary object for the output image.
     */
    if (new_kobject)
    {
       kpds_close_object(output_kimage);
       
       get_do_named_output(&do_named_output);
       get_output_transport_name(transport_name);
    
       if (do_named_output == FALSE)
	  output_kimage = kpds_create_object();
       else 
	  output_kimage = kpds_open_object(transport_name,KOBJ_WRITE); 

       /*  -- tell image widget to interpret data as RGB with no alpha -- */
       kcolor_set_attribute(output_kimage,KCOLOR_COLORSPACE,KRGB);
       kcolor_set_attribute(output_kimage,KCOLOR_HAS_ALPHA,FALSE);
    }

#if 0
    if (have_active_kobject)
	kpds_close_object(output_kimage);
    
    if (do_named_output == FALSE)
       output_kimage = kpds_create_object();
    else 
       output_kimage = kpds_open_object(transport_name,KOBJ_WRITE); 
#endif
    
    /* initialize the image output buffer */
    get_image_dims(&width,&height);

    (init_img_funcs[image_display_choice])(width,height,output_kimage);
    
    /* -- below is a kludge to get around a shitty bug --
       I hope this line can go away soon -- */

    /* -- sync our new size before xvisual syncs its new size -- */
    kpds_sync_object(output_kimage, KPRES2PHYS);
    
#if 0
    (*load_img_funcs[image_display_choice])(output_kimage,img_buffer);
#endif

    if (image_display_choice != sNO_DISPLAY) /* not "no display" */
    {
#if 0
	if (new_xvimage == TRUE)
	{
	    xvw_destroy(xvimage);
	    xvimage = xvw_create_image(NULL, "image");  
	    set_up_rmonster_mouse_button_definitions(xvimage,output_kimage);
	}
#endif
	/*if (new_kobject)*/
	   xvw_set_attribute(xvimage, XVW_IMAGE_IMAGEOBJ, output_kimage);
    }
    return(CHILL);
}

int
flush_output()
{
    (*load_img_funcs[image_display_choice])(output_kimage,img_buffer);

    return(CHILL);
}

int
clear_framebuffer()
{
    register int offset,i;
    register float r,g,b;
    register int limit;
    float mr,mg,mb;
    
    int w,h;
    get_image_dims(&w,&h);
    get_background_color(&mr,&mg,&mb);

    limit = w*h;
    r = mr;
    g = mg;
    b = mb;

    offset = 0;
    for (i=0;i<limit;i++)
    {
	*(img_buffer+offset++) = r;
	*(img_buffer+offset++) = g;
	*(img_buffer+offset++) = b;
    }
	
    return(CHILL);   
}

int
read_dot(int x, int y, float *r, float *g, float *b)
{
    int w,h;
    float *f;
    
    /* temporary */
    get_image_dims(&w,&h);
    f = img_buffer + x*3 + (h-y-1)*w*3;
    *r = *f++;
    *g = *f++;
    *b = *f;

    return(CHILL);
}

int
write_dot(int x, int y, float r, float g, float b)
{
    int w,h;
    float *f;
    
    /* temporary: alpha 2.0 */
    get_image_dims(&w,&h);

    /* temporary clipping: alpha 2.0 */
    if ((x < 0) || (x >= w))
	return(WHACKED);
    if ((y < 0) || (y >= h))
	return(WHACKED);
    
    f = img_buffer + x*3 + (h-y-1)*w*3;
    *f++ = r;
    *f++ = g;
    *f = b;

    return(CHILL);
}

int
change_image_dims(int w,
		  int h)
{
    int width,height;
    
    get_image_dims(&width,&height);
    free_bucket_zbuffer(width,height);
    
    set_image_dims(w,h);
    
    init_render_buffers();

    /* -- xvisual can't cope with kobject resize, so make a new one :( -- */
    reinit_output_object(FALSE, TRUE);
    
    return(CHILL);
}


int
change_image_width(int w)
{
    int width,height;
    
    get_image_dims(&width,&height);
    free_bucket_zbuffer(width,height);
    
    width = w;
    set_image_dims(width,height);

    
    init_render_buffers();
    reinit_output_object(FALSE, TRUE);
    
    return(CHILL);
}

int
change_image_height(int h)
{
    int width,height;
    
    get_image_dims(&width,&height);
    free_bucket_zbuffer(width,height);
    
    height = h;
    set_image_dims(width,height);

    
    init_render_buffers();
    reinit_output_object(FALSE, TRUE);
    
    return(CHILL);
}

static unsigned char level8[8] =
{
    0,36,72,108,144,181,217,255
};
static unsigned char level4[4] =
{
    0,85,170,255
};

int
make_332_colormap(void)
{
    int i;

    for (i=0;i<256;i++)
	bmap[i] = level4[i % 4];

    for (i=0;i<256;i++)
	gmap[i] = level8[ (i>>2) % 8];

    for (i=0;i<256;i++)
	rmap[i] = level8[ (i>>5) % 8];

    return(CHILL);
}

static void
init_332_image(int width,int height,kobject k)
{
    int i;

    if (bimg_buffer != NULL)
	kfree(bimg_buffer);
    bimg_buffer = (unsigned char *)kmalloc(sizeof(unsigned char)*width*height);
    
    if (!kpds_query_value(output_kimage))
       kpds_create_value(output_kimage);

    kpds_set_attribute(output_kimage,KPDS_VALUE_SIZE,width,height,1,1,1);
    kpds_set_attribute(output_kimage,KPDS_VALUE_DATA_TYPE,KUBYTE);

    if (!kpds_query_map(output_kimage))
    {
       kpds_create_map(output_kimage);
       kpds_set_attribute(output_kimage,KPDS_MAP_SIZE,3,256,1,1,1);
       kpds_set_attribute(output_kimage,KPDS_MAP_DATA_TYPE,KUBYTE);
    }
    
    /* make the colormap for the 3-3-2 image */
    make_332_colormap();

    kpds_set_attributes(output_kimage,
			KPDS_MAP_POSITION,0,0,0,0,0,
			KPDS_MAP_REGION_SIZE,1,256,1,1,1, NULL);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, rmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, gmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, bmap);

#if 0
    /* put the colormap to the object */
    for (i=0;i<256;i++)
    {
	kpds_put_data(output_kimage,KPDS_MAP_POINT,rmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,gmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,bmap+i);
    }
#endif

}

static void
init_quant_image(int width,int height,kobject k)
{
    int i;

    /* same as 3-3-2 init */
    
    if (bimg_buffer != NULL)
	kfree(bimg_buffer);
    bimg_buffer = (unsigned char *)kmalloc(sizeof(unsigned char)*width*height);
    
    if (!kpds_query_value(output_kimage))
       kpds_create_value(output_kimage);

    kpds_set_attribute(output_kimage,KPDS_VALUE_SIZE,width,height,1,1,1);
    kpds_set_attribute(output_kimage,KPDS_VALUE_DATA_TYPE,KUBYTE);

    if (!kpds_query_map(output_kimage))
    {
       kpds_create_map(output_kimage);
       kpds_set_attribute(output_kimage,KPDS_MAP_SIZE,3,256,1,1,1);
       kpds_set_attribute(output_kimage,KPDS_MAP_DATA_TYPE,KUBYTE);
    }
    
    /* make the colormap for the 3-3-2 image */
    make_332_colormap();

    kpds_set_attributes(output_kimage,
			KPDS_MAP_POSITION,0,0,0,0,0,
			KPDS_MAP_REGION_SIZE,1,256,1,1,1, NULL);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, rmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, gmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, bmap);

#if 0
    /* put the colormap to the object */
    for (i=0;i<256;i++)
    {
	kpds_put_data(output_kimage,KPDS_MAP_POINT,rmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,gmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,bmap+i);
    }
#endif
}

static void
init_dither_image(int width,int height,kobject k)
{
    int i;

    /* same as 3-3-2 init */
    
    if (bimg_buffer != NULL)
	kfree(bimg_buffer);
    bimg_buffer = (unsigned char *)kmalloc(sizeof(unsigned char)*width*height);
    
    if (!kpds_query_value(output_kimage))
       kpds_create_value(output_kimage);

    kpds_set_attribute(output_kimage,KPDS_VALUE_SIZE,width,height,1,1,1);
    kpds_set_attribute(output_kimage,KPDS_VALUE_DATA_TYPE,KUBYTE);

    if (!kpds_query_map(output_kimage))
    {
       kpds_create_map(output_kimage);
       kpds_set_attribute(output_kimage,KPDS_MAP_SIZE,3,256,1,1,1);
       kpds_set_attribute(output_kimage,KPDS_MAP_DATA_TYPE,KUBYTE);
    }

    /* make the colormap for the 3-3-2 image */
    make_332_colormap();
    
    kpds_set_attributes(output_kimage,
			KPDS_MAP_POSITION,0,0,0,0,0,
			KPDS_MAP_REGION_SIZE,1,256,1,1,1, NULL);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, rmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, gmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, bmap);

#if 0
    /* put the colormap to the object */
    for (i=0;i<256;i++)
    {
	kpds_put_data(output_kimage,KPDS_MAP_POINT,rmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,gmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,bmap+i);
    }
#endif
}


static void
init_24bit_image(int width,int height,kobject k)
{
    int i;
    /* 24 bit images are byte, RGB images. */

    if (bimg_buffer != NULL)
	kfree(bimg_buffer);
    
    bimg_buffer = (unsigned char *)kmalloc(sizeof(unsigned char)*width*height*3);
    
    /* set up value segment */
    if (!kpds_query_value(output_kimage))
       kpds_create_value(k);
    kpds_set_attribute(k,KPDS_VALUE_SIZE,width,height,1,1,3);
    kpds_set_attribute(k,KPDS_VALUE_DATA_TYPE,KUBYTE);

    if (!kpds_query_value(output_kimage))
       kpds_destroy_value(k);
    
#if 0
    /* make a grey-scale map (xvisual'll do this anyway) */
    kcolor_set_attribute(k, KCOLOR_MAP_AUTOCOLOR, KGREYSCALE);
#endif
}

static void
init_no_image(int width, int height,kobject k)
{
    /* set up value setgment */
    init_24bit_image(width,height,k);
}

static void
load_332_image(kobject k, float *f)
{
    register float *fb;
    register unsigned char *bb;
    register int acc,acc2;
    int i,j;

    fb = f;
    bb = bimg_buffer; 
    
    for (j=0;j<img_height;j++)
    {
	for (i=0;i<img_width;i++)
        {
	    acc2 = (int)(*(fb++) * 255.0);
	    acc = acc2 & 0xe0;
	    acc2 = (int)(*(fb++) * 255.0);
	    acc |= ((acc2 & 0xe0) >> 3);
	    acc2 = (int)(*(fb++) * 255.0);
	    acc |= ((acc2 & 0xc0) >> 6);
	    *(bb++) = acc;
	}
    }
    kpds_set_attribute(k,KPDS_VALUE_POSITION,0,0,0,0,0);
    kpds_put_data(k,KPDS_VALUE_ALL,bimg_buffer);
}

static void
load_quant_image(kobject k, float *f)
{
    int i;

    /* compute the new colormap, and put new bytes into the image buffer.  */
    ppmquant(f,img_width,img_height,(unsigned char *) rmap, (unsigned char *) gmap, (unsigned char *) bmap, (unsigned char *) bimg_buffer);

    kpds_set_attributes(output_kimage,
			KPDS_MAP_POSITION,0,0,0,0,0,
			KPDS_MAP_REGION_SIZE,1,256,1,1,1, NULL);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, rmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, gmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, bmap);
#if 0      
    /* put the colormap to the object */
    for (i=0;i<256;i++)
    {
	kpds_put_data(output_kimage,KPDS_MAP_POINT,rmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,gmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,bmap+i);
    }
#endif
    
    kpds_set_attribute(k,KPDS_VALUE_POSITION,0,0,0,0,0);
    kpds_put_data(k,KPDS_VALUE_ALL,bimg_buffer);
}

static void
load_dither_image(kobject k, float *f)
{
    int i;

    /* compute the new colormap, and put new bytes into the image buffer.  */
    ppmdither(f,img_width,img_height,(unsigned char *) bimg_buffer, (unsigned  char *) rmap, (unsigned char *) gmap, (unsigned char *)bmap);

    kpds_set_attributes(output_kimage,
			KPDS_MAP_POSITION,0,0,0,0,0,
			KPDS_MAP_REGION_SIZE,1,256,1,1,1, NULL);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, rmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, gmap);
    kpds_put_data(output_kimage, KPDS_MAP_REGION, bmap);
#if 0      
    /* put the colormap to the object */
    for (i=0;i<256;i++)
    {
	kpds_put_data(output_kimage,KPDS_MAP_POINT,rmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,gmap+i);
	kpds_put_data(output_kimage,KPDS_MAP_POINT,bmap+i);
    }
#endif
    
    kpds_set_attribute(k,KPDS_VALUE_POSITION,0,0,0,0,0);
    kpds_put_data(k,KPDS_VALUE_ALL,bimg_buffer);
}

static void
load_24bit_image(kobject k, float *f)
{
#ifdef RGBRGB    
    register float *fb;
    register unsigned char *bb; 
    register int acc;
    int i,j;


    fb = f;
    bb = bimg_buffer; 
    
    for (j=0;j<img_height;j++)
    {
	for (i=0;i<img_width*3;i++)
        {
	    acc = (int)(*fb++ * 255.0);
	    *bb++ = (unsigned char)(acc);
	}
    }
    kpds_set_attribute(k,KPDS_VALUE_POSITION,0,0,0,0,0);
/*    kpds_set_attribute(k,KPDS_ELEMENTS_FIRST,TRUE) */
    kpds_put_data(k,KPDS_VALUE_ALL,bimg_buffer);
#else
    /** RRGGBB **/
    register float *fb;
    register unsigned char *bb;
    register int acc;
    int i,j;
    
    /* do the red plane */
    fb = f;
    bb = bimg_buffer;

    for (j=0;j<img_height;j++)
	for (i=0;i<img_width;i++,fb+=3)
	{
	    acc = (int)(*fb * 255.0);
	    *bb++ = (unsigned char)(acc);
	}

    /* do the green plane */
    fb = f+1;
    bb = bimg_buffer+img_width*img_height;

    for (j=0;j<img_height;j++)
	for (i=0;i<img_width;i++,fb+=3)
	{
	    acc = (int)(*fb * 255.0);
	    *bb++ = (unsigned char)(acc);
	}
    
    /* do the blue plane */
    fb = f+2;
    bb = bimg_buffer+img_width*img_height*2;

    for (j=0;j<img_height;j++)
	for (i=0;i<img_width;i++,fb+=3)
	{
	    acc = (int)(*fb * 255.0);
	    *bb++ = (unsigned char)(acc);
	}
    kpds_set_attribute(k,KPDS_VALUE_POSITION,0,0,0,0,0);
    kpds_put_data(k,KPDS_VALUE_ALL,bimg_buffer);
#endif
}

static void
load_no_image(kobject k, float *f)
{
    load_24bit_image(k,f);
}


