
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

  august 1994 -
     lights are described using the struct below.  there is an
     array of lights which may hold a given number of point and
     directional light sources.  there is a separate struct for the
     ambient light.  the assumption is that there is only 1 ambient
     light in the reflection model.

*********************************************************************/



#include <design.h>
#include "rmonster.h"
#include "lights.h"
#include "rmatrix.h"

/**
  * there is an array for the "normal" lights, and a single
  * struct dedicated to the single ambient light.
**/
static light_struct *scene_lights[MAX_LIGHTS];
static light_struct *ambient_light_struct=NULL;
static int num_lights = 0;
static float default_ambient_light_color[3] = {0.5,0.5,0.5};
static float default_point_light_color[3] = {1.0,1.0,1.0};
static float default_directional_light_color[3] = {1.0,1.0,1.0};
static vertex_3d default_direction={0.0,1.0,1.0};
static int current_light;

static void malloc_light PROTO((light_struct **));

static void
malloc_light(light_struct **l)
{
    light_struct *t;
    t = (light_struct *)kmalloc(sizeof(light_struct));
    t->light_type = DIRECTIONAL_LIGHT;
    t->position.v[0] = t->position.v[1] = t->position.v[2] = 0.;
    t->direction.v[0] = t->direction.v[2] = 0.;
    t->direction.v[1] = 1.0;
    t->rgb[0] = t->rgb[1] = t->rgb[2] = 1.;
    t->light_on = LIGHT_OFF;
    *l = t;
}

static void
free_light(light_struct *l)
{
    kfree(l);
}

/** public routines **/


void init_lights()
{
    /**
      * initialize so that we have two lights by default.  one is
      * used to control the amount of ambient light in the scene, the
      * other is a default unidirectional light source coming from
      * the +z axis.
    **/
    int i;
    light_struct *l;

    for (i=0;i<MAX_LIGHTS;i++)
	scene_lights[i] = NULL;

    /* set up the ambient light */
    malloc_light(&ambient_light_struct);
    ambient_light_struct->light_type = AMBIENT_LIGHT;
    ambient_light_struct->light_on = LIGHT_ON;
    set_ambient_light_color((vertex_3d *)(default_ambient_light_color));
    
    for (i=0;i<MAX_LIGHTS;i++)
    {
	malloc_light(&l);
	scene_lights[i] = l;
	set_light_type(i,DIRECTIONAL_LIGHT);
	set_light_color(i,default_directional_light_color[0],
			default_directional_light_color[1],
			default_directional_light_color[2]);
	set_light_direction(i,&default_direction);
    }

    /* turn on light #0 */
    set_light_onoff(0,LIGHT_ON);
    
    num_lights = 1;
    current_light = 0;
}

int
set_current_light (int i)
{
    /* check input ?? */
    current_light = i;
    return(CHILL);
}


int
get_current_light(int *i)
{
    *i = current_light;
    return(CHILL);
}

int
set_light_color(int i, float r, float g, float b)
{
    light_struct *l;
    l = scene_lights[i];
    l->rgb[0] = r;
    l->rgb[1] = g;
    l->rgb[2] = b;
    return(CHILL);
}

int
get_light_color(int i, float *r, float *g, float *b)
{
    light_struct *l;
    l = scene_lights[i];
    *r = l->rgb[0];
    *g = l->rgb[1];
    *b = l->rgb[2];
    return(CHILL);
}

int
set_light_onoff(int i, int val)
{
    light_struct *l;
    l = scene_lights[i];
    l->light_on = val;
    if (val == LIGHT_ON)
	num_lights++;
    else if (val == LIGHT_OFF)
	num_lights = (num_lights-1) >= 0 ? num_lights-1 : 0;
    
    return(CHILL);
}

int
get_light_onoff(int i, int *val)
{
    light_struct *l;
    l = scene_lights[i];
    *val = l->light_on;
    return(CHILL);
}

int
set_light_type(int i, int type)
{
    light_struct *l;
    l = scene_lights[i];
    l->light_type = type;
    return(CHILL);
}

int
get_light_type(int i, int *type)
{
    light_struct *l;
    l = scene_lights[i];
    *type = l->light_type;
    return(CHILL);
}

int
set_light_direction(int i, vertex_3d *xyz)
{
    light_struct *l;
    double mag;
    vertex_3d v;

/*    memcpy((char *)&v,(char *)xyz,sizeof(vertex_3d)); */
    VCOPY(&v,xyz);
    vertex_unit(&v,&mag);
    l = scene_lights[i];
/*     memcpy((char *)&(l->direction),(char *)&v,sizeof(vertex_3d)); */
    VCOPY(&(l->direction),&v);
    return(CHILL);
}
    
int
get_light_direction(int i,vertex_3d *xyz)
{
    light_struct *l;
    l = scene_lights[i];
/*    memcpy((char *)xyz,(char *)&(l->direction),sizeof(vertex_3d)); */
    VCOPY(xyz,&(l->direction));
    return(CHILL);

}

int
set_light_position(int i, vertex_3d *xyz)
{
    light_struct *l;
    l = scene_lights[i];
/*    memcpy((char *)&(l->position),(char *)xyz,sizeof(vertex_3d)); */
    VCOPY(&(l->position),xyz);
    return(CHILL);
}
    
int
get_light_position(int i,vertex_3d *xyz)
{
    light_struct *l;
    l = scene_lights[i];
/*    memcpy((char *)xyz,(char *)&(l->position),sizeof(vertex_3d)); */
    VCOPY(xyz,&(l->position));
    return(CHILL);
}

int
get_ambient_light_color(vertex_3d *rgb)
{
    int i;

/*    for (i=0;i<3;i++)
	rgb->v[i] = ambient_light_struct->rgb[i]; */
    VCOPY(rgb,&(ambient_light_struct->rgb));
    return(CHILL);
}


int
set_ambient_light_color(vertex_3d *rgb)
{
    int i;

    for (i=0;i<3;i++)
	ambient_light_struct->rgb[i] = rgb->v[i];
    return(CHILL);
}

int
get_num_lights(int *n)
{
    *n = num_lights;
    return(CHILL);
}

int
set_num_lights(int n)
{
    num_lights = n;
    return(CHILL);
}
