 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane Cameras
   >>>> 
   >>>>  Private: 
   >>>> 	Cameras_projection_cycle
   >>>> 	Cameras_eye_x
   >>>> 	Cameras_up_x
   >>>> 	Cameras_at_x
   >>>> 	Cameras_eye_y
   >>>> 	Cameras_up_y
   >>>> 	Cameras_at_y
   >>>> 	Cameras_eye_z
   >>>> 	Cameras_up_z
   >>>> 	Cameras_at_z
   >>>> 	Cameras_hither_clip_form_loc
   >>>> 	Cameras_yon_clip_form_loc
   >>>> 	Cameras_back_clip_form_on_off
   >>>> 	Cameras_fov_input
   >>>> 	Cameras_aspect
   >>>> 	Cameras_normalize_cam
   >>>> 	Cameras_reset_camera
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"

/**
  * camera.h has routine protos for accessing the camera parms.
**/
#include "camera.h"

/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_projection_cycle
| 
|       Purpose: Do routine which is called when
|                  cycle selection projection_cycle is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_projection_cycle(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    int proj;
    proj = Cameras_info->projection_cycle;
    /* range check?? */
    set_projection(proj);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_eye_x
| 
|       Purpose: Do routine which is called when
|                  float selection eye_x is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_eye_x(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_eye(&t);
    t.v[0] = Cameras_info->eye_x;
    set_eye(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_up_x
| 
|       Purpose: Do routine which is called when
|                  float selection up_x is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_up_x(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_up(&t);
    t.v[0] = Cameras_info->up_x;
    set_up(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_at_x
| 
|       Purpose: Do routine which is called when
|                  float selection at_x is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_at_x(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_at(&t);
    t.v[0] = Cameras_info->at_x;
    set_at(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_eye_y
| 
|       Purpose: Do routine which is called when
|                  float selection eye_y is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_eye_y(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_eye(&t);
    t.v[1] = Cameras_info->eye_y;
    set_eye(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_up_y
| 
|       Purpose: Do routine which is called when
|                  float selection up_y is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_up_y(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_up(&t);
    t.v[1] = Cameras_info->up_y;
    set_up(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_at_y
| 
|       Purpose: Do routine which is called when
|                  float selection at_y is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_at_y(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_at(&t);
    t.v[1] = Cameras_info->at_y;
    set_at(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_eye_z
| 
|       Purpose: Do routine which is called when
|                  float selection eye_z is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_eye_z(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_eye(&t);
    t.v[2] = Cameras_info->eye_z;
    set_eye(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_up_z
| 
|       Purpose: Do routine which is called when
|                  float selection up_z is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_up_z(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_up(&t);
    t.v[2] = Cameras_info->up_z;
    set_up(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_at_z
| 
|       Purpose: Do routine which is called when
|                  float selection at_z is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_at_z(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d t;
    get_at(&t);
    t.v[2] = Cameras_info->at_z;
    set_at(&t);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_hither_clip_form_loc
| 
|       Purpose: Do routine which is called when
|                  float selection hither_clip_form_loc is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_hither_clip_form_loc(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */

    float hither;

    hither = Cameras_info->hither_clip_form_loc;
    set_user_hither(hither);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_yon_clip_form_loc
| 
|       Purpose: Do routine which is called when
|                  float selection yon_clip_form_loc is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_yon_clip_form_loc(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    float yon;
    yon = Cameras_info->yon_clip_form_loc;
    set_user_yon(yon);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_back_clip_form_on_off
| 
|       Purpose: Do routine which is called when
|                  logical selection back_clip_form_on_off is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_back_clip_form_on_off(
     RenderMonster_Cameras *Cameras_info)
{
    int flag;
	/* PUT YOUR CODE HERE ! */
    flag = Cameras_info->back_clip_form_on_off;
    set_yon_clip_flag(flag);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_fov_input
| 
|       Purpose: Do routine which is called when
|                  float selection fov_input is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_fov_input(
     RenderMonster_Cameras *Cameras_info)
{
    /* PUT YOUR CODE HERE ! */
    float fov;
    fov = Cameras_info->fov_input;
    set_fov(fov);
    compute_view_xform(); /* recompute and update internal view matrix. */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_aspect
| 
|       Purpose: Do routine which is called when
|                  float selection aspect is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_aspect(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_normalize_cam
| 
|       Purpose: Do routine which is called when
|                  pane action button normalize_cam is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_normalize_cam(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    /* if we got here, then we want to reset the view parms. */
    set_normalized_view();
    update_cameras_pane_GUI(Cameras_info);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Cameras_reset_camera
| 
|       Purpose: Do routine which is called when
|                  pane action button reset_camera is used
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Cameras_reset_camera(
     RenderMonster_Cameras *Cameras_info)
{
	/* PUT YOUR CODE HERE ! */
    set_startup_default_camera_parms();
    update_cameras_pane_GUI(Cameras_info);
}

/*-----------------------------------------------------------
| 
|  Routine Name: update_cameras_pane_GUI
| 
|       Purpose: called to force update of GUI to reflect
|                  current renderer camera parms.
| 
|         Input: Cameras_info - ptr to PaneInfo struct for Cameras pane
| 
|        Output: None
|    Written By: wes
|          Date: Jun 19, 1993
| Modifications:
|
|     Notes    :  there is a lot of dependency between this
|                 routine and the .form file.  if the .form
|                 file gets changed, then this routine will need
|                 to get changed (probably) also.
| 
------------------------------------------------------------*/
void
update_cameras_pane_GUI(RenderMonster_Cameras *ci)
{
    int proj;
    float fov,t;
    vertex_3d v;
    
    /* set the projection thingy.  in the form file, perspective==0,
     and parallel == 1 */
    get_projection(&proj);
    xvf_set_attribute(ci->projection_cycle_struct,
                   XVF_CYCLE_VAL,
                   proj);

    /* set the FOV thingy */
    get_fov(&fov);
    xvf_set_attribute(ci->fov_input_struct,
                   XVF_FLOAT_VAL, 
                   fov);

    /* set the eye thingy */
    get_eye(&v);
    xvf_set_attribute(ci->eye_x_struct,
                   XVF_FLOAT_VAL, 
                   v.v[0]);
    xvf_set_attribute(ci->eye_y_struct,
                   XVF_FLOAT_VAL, 
                   v.v[1]);
    xvf_set_attribute(ci->eye_z_struct,
                   XVF_FLOAT_VAL, 
                   v.v[2]);
    ci->eye_x = v.v[0];
    ci->eye_y = v.v[1];
    ci->eye_z = v.v[2];

    /* set the at_thingy */
    get_at(&v);
    xvf_set_attribute(ci->at_x_struct,
                   XVF_FLOAT_VAL, 
                   v.v[0]);
    xvf_set_attribute(ci->at_y_struct,
                   XVF_FLOAT_VAL, 
                   v.v[1]);
    xvf_set_attribute(ci->at_z_struct,
                   XVF_FLOAT_VAL, 
                   v.v[2]);

    /* set the up thingy */
    get_up(&v);
    xvf_set_attribute(ci->up_x_struct,
                   XVF_FLOAT_VAL, 
                   v.v[0]);
    xvf_set_attribute(ci->up_y_struct,
                   XVF_FLOAT_VAL, 
                   v.v[1]);
    xvf_set_attribute(ci->up_z_struct,
                   XVF_FLOAT_VAL, 
                   v.v[2]);
    /* set the hither thingy */
    get_user_hither(&t);
    xvf_set_attribute(ci->hither_clip_form_loc_struct,
                      XVF_FLOAT_VAL,
                      t);
    /* set the yon thingy */
    get_user_yon(&t);
    xvf_set_attribute(ci->yon_clip_form_loc_struct,
                      XVF_FLOAT_VAL,
                      t);
}

