
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#ifndef __camera_h_
#define __camera_h_

#include "geometry/geom.h"

int set_projection PROTO((int));
int get_projection PROTO((int *));

int set_eye PROTO((vertex_3d *));
int get_eye PROTO((vertex_3d *));

int set_at PROTO((vertex_3d *));
int get_at PROTO((vertex_3d *));

int set_up PROTO((vertex_3d *));
int get_up PROTO((vertex_3d *));

int set_fov PROTO((float));
int get_fov PROTO((float *));

int set_user_hither PROTO((float));
int get_user_hither PROTO((float *));

int set_rmonster_hither PROTO((float));
int get_rmonster_hither PROTO((float *));

int set_user_yon PROTO((float));
int get_user_yon PROTO((float *));

int set_rmonster_yon PROTO((float));
int get_rmonster_yon PROTO((float *));

int set_zmin PROTO((float));
int get_zmin PROTO((float *));

int set_zproj PROTO((float));
int get_zproj PROTO((float *));

int get_view_xform PROTO((matrix4x4 *));
int set_view_xform PROTO((matrix4x4 *));

int compute_view_xform PROTO(());

int set_world_to_view_scale PROTO((float, float));
int get_world_to_view_scale PROTO((float *, float *));

int set_hither_clip_flag PROTO((int));
int get_hither_clip_flag PROTO((int *));

int set_yon_clip_flag PROTO((int));
int get_yon_clip_flag PROTO((int *));

int compute_perspective_projection PROTO((matrix4x4 *, vertex_3d *, vertex_3d *,vertex_3d *,float *,float *,float *,float *, float *));
int compute_parallelprojection PROTO((matrix4x4 *, vertex_3d *, vertex_3d *,vertex_3d *,float *,float *,float *,float *, float *));

int get_view_rotation_matrix PROTO((matrix4x4 *));

int set_normalized_view PROTO((void));
int set_startup_default_camera_parms PROTO((void));

int software_set_camera PROTO((void));

#endif
