 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for ggencmap
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lggencmap
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lggencmap - create a vis colormap
* 
*       Purpose: This routine creates a vis colormap
*         Input:      1. use_hsv_space - int, when set to 1, indicates that
*                    values in color_parms[] are min/max values for
*                    HSV channels.  when set to 0, indicates that
*                    values in color_parms[] are RGB.
*                 2. color_parms[] - float array of min/max values for
*                    either HSV or RGB maps.
*                 3. use_alpha - int, when 1, indicates that the user
*                    has min/max values for alpha in the alpha_parms[]
*                 4. alpha_parms[] - float array of min/max values for
*                    alpha channel of the map.
*                 5. nitems - indicates the number of entries in the cmap
*                 6. minvalue, maxvalue : floats indiciating the min and
*                    max values to be associated with entry 0 and entry
*                    nitems-1 when data mapping (ie, colorizing) occurs 
*                    (in downstream processes)
*        Output: map: kobject containing created vis colormap
*       Returns: CHILL on success, WHACKED otherwise
*  Restrictions: 
*    Written By: Wes Bethel
*          Date: Apr 13, 1995
*      Verified: 
*  Side Effects: 
* Modifications: Moved from xvroutine make_cmap (7/10/93) //SK
*                overhauled clui  8/25/94
****************************************************************/
/* -library_def */
int lggencmap(int use_hsv_space,
	       float *color_parms,
	       int use_alpha,
	       float *alpha_parms,
	       int nitems,
	       float minvalue,
	       float maxvalue,
	       kobject mapobj)
/* -library_def_end */

/* -library_code */
{
   vis_cmap vmap;
   float dt, t;
   int i;

   float h[MAX_VIS_CMAP_ENTRIES];
   float s[MAX_VIS_CMAP_ENTRIES];
   float v[MAX_VIS_CMAP_ENTRIES];
   float a[MAX_VIS_CMAP_ENTRIES];

   vmap.nentries = nitems;
    
   dt = (maxvalue - minvalue)/(nitems-1);
   t  = minvalue;

   for (i=0;i<nitems+1;i++,t+=dt)
      vmap.bracket[i] = t;

   /* do hue or red */
   dt = (color_parms[1] - color_parms[0])/(nitems-1); 
   t = color_parms[0];
   for (i=0;i<nitems;i++,t+=dt)
      h[i] = t;

   /* do saturation */
   dt = (color_parms[3] - color_parms[2])/(nitems-1);
   t = color_parms[2];
   for (i=0;i<nitems;i++,t+=dt)
      s[i] = t;

   /* do value */
   dt = (color_parms[5] - color_parms[4])/(nitems-1);
   t = color_parms[4];
   for (i=0;i<nitems;i++,t+=dt)
      v[i] = t;

   /* do alpha */

   if (use_alpha)
   {
       dt = (alpha_parms[1] - alpha_parms[0])/(nitems-1);
       t = alpha_parms[0];

       /* -- xvisual needs these to be able to interpret a vis colormap -- */
       kdms_create_attribute(mapobj,NULL,KCOLOR_ALPHA_MIN,1,1, KDOUBLE, 1, 1);
       kdms_create_attribute(mapobj,NULL,KCOLOR_ALPHA_MAX,1,1, KDOUBLE, 1, 1);

       /* -- set the alpha min and max attributes -- */
       kdms_set_attribute(mapobj,NULL,
			  KCOLOR_ALPHA_MIN,(double) alpha_parms[0]);
       kdms_set_attribute(mapobj,NULL,
			  KCOLOR_ALPHA_MAX,(double) alpha_parms[1]);
   }
   else
   {
       t = 1.;
       dt = 0.;  /* if user didnt specify anything for alpha, fill it up
		    with 1.0's */
   }
   for (i=0;i<nitems;i++,t+=dt)
      a[i] = t;

   /* since the colormap must be in RGBA space, call the
      library routine to do the conversion if the user didn't specify
      it in RGB space to begin with */

   for (i=0;i<nitems;i++)
   {
       if (use_hsv_space)
	   lhsv_to_rgb(h[i],s[i],v[i],&(vmap.r[i]),&(vmap.g[i]),&(vmap.b[i]));
       vmap.a[i] = a[i];
   }

   /* call the library routine that places the vmap into the kobject */
   lvismap_to_kobj(&vmap,mapobj);
    
   return(CHILL);
}
/* -library_code_end */
