 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for gcmaplegend
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lgcmaplegend
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lgcmaplegend - generate a color legend
* 
*       Purpose: This function is used to contruct geometry
*		 representing a color legend showing the colors
*		 contained in a vis colormap.  The length and
*		 thickness of the legend can be controlled, along with
*		 its 2d position in space.  The legend can be oriented
*		 either vertically or horizontally.  An outline around
*		 the distinct colors in the legend may be optionally
*		 included.  The colors in the legend can be reversed.
*
*         Input: input      - input data object containing vis colormap
*	         name       - object name to assign to the output geometry
*		 reverse    - TRUE if a reversed legend should be generated
*		 outline    - TRUE if the legend should have an outline
*		 horiz_vert - 1 if a horizontal legend should be generated
*		              anything else implies a vertical legend.
*		 length     - length of the legend
*		 thickness  - thickness of the legend
*		 xpos       - x position for the legend
*		 ypos       - y position for the legend
*
*        Output: output - data object to contain color legend geometry
*
*       Returns: CHILL (1) on success, WHACKED (0) on failure
*  Restrictions: 
*    Written By: Wes Bethel
*          Date: Apr 13, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lgcmaplegend (kobject input,
		   kobject output,
		   char *name,
		   int reverse,
		   int outline,
		   int horiz_vert,
		   float *length,
		   float *thickness,
		   float *xpos,
		   float *ypos)
/* -library_def_end */

/* -library_code */
{
    int ntriangles, nverts, i, vindex, cindex, j;
    vis_cmap map;
    vertex_3d *verts,*colors=NULL;
    vertex_3d v0,v1,dv;
    vertex_3d bmin,bmax,center;

    int result;
    float zval = 0.4; /* arbitrary zval for the colorbar */

    /* make call to put the map into a structure. */
    result = lkobj_to_vismap(input,&map);
    if (result == WHACKED)
        return(WHACKED);

    kgeom_create_primitive_list(output);
    
    /* set up stuff for output object */
    ntriangles = map.nentries * 2;
    nverts = ntriangles+2;

    
    lset_common_geom_attributes(output);
    
    kgeom_set_attribute(output,KGEOM_OBJECT,KGEOM_HAS_ALPHA,FALSE); /* ignore alpha */

    /* set modeling space to ndc -- the coords map to -1..1 in x/y for
       facilitating placing the color legend on the screen, irrespective
       of what's happening in the world coord system */
/* not yet implemented in rmonster.
    kgeom_set_attribute(output,KGEOM_OBJECT,KGEOM_MODELING_SPACE,KNDC_SPACE);
*/
    /* set layout of colors to per-face. */
    kgeom_set_attribute(output,KGEOM_OBJECT,KGEOM_LAYOUT,KPER_FACE);

    kgeom_set_attribute(output,KGEOM_OBJECT,KGEOM_NAME,name);

    verts = (vertex_3d *)kmalloc(sizeof(vertex_3d)*nverts);
    colors = (vertex_3d *)kmalloc(sizeof(vertex_3d)*nverts);

    if (horiz_vert == 1)  /* horiz. */
    {
        v0.v[0] = *xpos;
	v0.v[1] = *ypos;
	v0.v[2] = zval;

	v1.v[0] = *xpos;
	v1.v[1] = *ypos + *thickness;
	v1.v[2] = zval;

	dv.v[0] = (*length)/(map.nentries);
	dv.v[1] = dv.v[2] = 0.;

    }
    else /* vert. */
    {
        v0.v[0] = *xpos;
	v0.v[1] = *ypos;
	v0.v[2] = zval;

	v1.v[0] = *xpos + *thickness;
	v1.v[1] = *ypos;
	v1.v[2] = zval;

	dv.v[1] = (*length)/(map.nentries);
	dv.v[0] = dv.v[2] = 0.;
    }

    /* compute the triangle vertices */
    vindex = 0;
    /* changed map.nentries+2 to map.nentries+1
     *
     *	logic for doing this :   (map.nentries+2)/2 = map.nentries+1
     *
     *							// Steve K 
     */
    for (i=0;i<(map.nentries+1);i++)
    {
        memcpy((char *)(verts+vindex),(char *)&v0,sizeof(vertex_3d));
	vindex++;
	memcpy((char *)(verts+vindex),(char *)&v1,sizeof(vertex_3d));
	vindex++;

	for (j=0;j<3;j++)
	{
	    v0.v[j] += dv.v[j];
	    v1.v[j] += dv.v[j];
	}
    }

    /* deal with colors. */

    memset((char *)colors,0,sizeof(vertex_3d)*ntriangles);
    cindex = 0;
    for (i=0;i<map.nentries;i++)
    {
        colors[cindex].v[0] = map.r[i];
	colors[cindex].v[1] = map.g[i];
	colors[cindex].v[2] = map.b[i];
	cindex++;

        colors[cindex].v[0] = map.r[i];
	colors[cindex].v[1] = map.g[i];
	colors[cindex].v[2] = map.b[i];
	cindex++;
    }

    kgeom_set_attribute(output,KGEOM_OBJECT,KGEOM_NUMBER_PRIMITIVES,1);
    kgeom_set_attribute(output,KGEOM_TRIANGLES_CONNECTED,KGEOM_NUMBER_VERTICES,nverts);
    kgeom_put_data(output,KGEOM_TRIANGLES_CONNECTED,verts,colors,NULL,NULL);

    /**
      * call library routine to compute the bounding box.
    **/
    lcompute_bbox(verts,nverts,&bmin,&bmax);
    for (i=0;i<3;i++)
	center.v[i] = bmin.v[i] + (bmax.v[i] - bmin.v[i])*0.5;

    kgeom_set_attribute(output,KGEOM_OBJECT,KGEOM_BOUNDING_BOX,
			(float *)&(bmin.v[0]),(float *)&(bmax.v[0]));
    kgeom_set_attribute(output,KGEOM_OBJECT,KGEOM_CENTER,
			(float *)&(center.v[0]));
    

    /* if requested, construct the outline */
    

    kfree(verts);
    kfree(colors);
    
    return(CHILL);
}
/* -library_code_end */
