 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for gtubeness
   >>>> 
   >>>>    Written By: wes
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 13, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _gtubeness_h_
#define _gtubeness_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>

/* -include_includes */
#include <geometry/geometry.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/kroutine/gtubeness/uis/gtubeness.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input geometry object. (required infile)
 */
char	*i_file;	/* Input geometry object. FILENAME */
int	 i_flag;	/* Input geometry object. FLAG */

/*
 *  Tube-ified geometry object (required outfile)
 */
char	*o_file;	/* Tube-ified geometry object FILENAME */
int	 o_flag;	/* Tube-ified geometry object FLAG */

/*
 *  A scalar which indicates the radius of the tube. (optional float)
 */
float	 scale_float;	/* A scalar which indicates the radius of the tube. FLOAT */
int	 scale_flag;   	/* A scalar which indicates the radius of the tube. FLAG */

/*
 *  number onumber of sides for each tube will be 2 << (subdivisions - 1). (optional integer)
 */
int	 subdivisions_int; 	/* number onumber of sides for each tube will be 2 << (subdivisions - 1). INT */
int	 subdivisions_flag;	/* number onumber of sides for each tube will be 2 << (subdivisions - 1). FLAG */

/*
 *  A list of choices for possible methods for capping the tubes. (Optional list)
 */
int	 cap_style_list;	/* A list of choices for possible methods for capping the tubes. LIST INDEX */
char	 *cap_style_label;	/* A list of choices for possible methods for capping the tubes. LIST LABEL */
int	 cap_style_flag;	/* A list of choices for possible methods for capping the tubes. FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void gtubeness_get_args PROTO((kform *));
void gtubeness_usage_additions PROTO((void));
void gtubeness_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
