 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for gquadmesh
   >>>> 
   >>>>    Written By: Yo Momma
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 13, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _gquadmesh_h_
#define _gquadmesh_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>

/* -include_includes */
#include <geometry/geometry.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/kroutine/gquadmesh/uis/gquadmesh.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input 2d data for quadmesh (required infile)
 */
char	*i_file;	/* input 2d data for quadmesh FILENAME */
int	 i_flag;	/* input 2d data for quadmesh FLAG */

/*
 *  ouput geometry quadmesh (required outfile)
 */
char	*o_file;	/* ouput geometry quadmesh FILENAME */
int	 o_flag;	/* ouput geometry quadmesh FLAG */

/*
 *  object name (optional string)
 */
char	*name_string;	/* object name STRING */
int	 name_flag;   	/* object name FLAG */

/*----- optional ME group ----*/
/*
 *  input vis colormap (optional infile)
 */
char	*cmap_file;	/* input vis colormap FILENAME */
int	 cmap_flag;	/* input vis colormap FLAG */

	/*---- nested optional MI group ----*/
/*
 *  generate 2D texture coords (optional flag)
 */
int	 tc2d_flag;  	/* generate 2D texture coords FLAG */

/*
 *  umin (optional double)
 */
double	 umin2d_double;	/* umin DOUBLE */
int	 umin2d_flag;   	/* umin FLAG */

/*
 *  umax (optional double)
 */
double	 umax2d_double;	/* umax DOUBLE */
int	 umax2d_flag;   	/* umax FLAG */

/*
 *  vmin (optional double)
 */
double	 vmin2d_double;	/* vmin DOUBLE */
int	 vmin2d_flag;   	/* vmin FLAG */

/*
 *  vmax (optional double)
 */
double	 vmax2d_double;	/* vmax DOUBLE */
int	 vmax2d_flag;   	/* vmax FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  generate 3D texture coords (optional flag)
 */
int	 tc3d_flag;  	/* generate 3D texture coords FLAG */

/*
 *  umin (optional double)
 */
double	 umin3d_double;	/* umin DOUBLE */
int	 umin3d_flag;   	/* umin FLAG */

/*
 *  umax (optional double)
 */
double	 umax3d_double;	/* umax DOUBLE */
int	 umax3d_flag;   	/* umax FLAG */

/*
 *  vmin (optional double)
 */
double	 vmin3d_double;	/* vmin DOUBLE */
int	 vmin3d_flag;   	/* vmin FLAG */

/*
 *  vmax (optional double)
 */
double	 vmax3d_double;	/* vmax DOUBLE */
int	 vmax3d_flag;   	/* vmax FLAG */

/*
 *  wmin (optional double)
 */
double	 wmin3d_double;	/* wmin DOUBLE */
int	 wmin3d_flag;   	/* wmin FLAG */

/*
 *  wmax (optional double)
 */
double	 wmax3d_double;	/* wmax DOUBLE */
int	 wmax3d_flag;   	/* wmax FLAG */

	/*-- nested optional MI group end --*/

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void gquadmesh_get_args PROTO((kform *));
void gquadmesh_usage_additions PROTO((void));
void gquadmesh_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
