 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "gisosurface.h"
/*-----------------------------------------------------------
| 
|  Routine Name: gisosurface_get_args
| 
|       Purpose: Gets command line args for gisosurface
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gisosurface
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gisosurface_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for gisosurface is out of sync with arguments specified in gisosurface's *.pane file; please rerun ghostwriter on gisosurface.";


	/*
	 * allocate the gisosurface structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "gisosurface_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "l",
			  &(clui_info->l_float),
			  &(clui_info->l_flag))))
	{
	    kerror(NULL, "gisosurface_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "normals",
			  &(clui_info->normals_logic),
			  &(clui_info->normals_flag))))
	{
	    kerror(NULL, "gisosurface_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "flip",
			  &(clui_info->flip_logic),
			  &(clui_info->flip_flag))))
	{
	    kerror(NULL, "gisosurface_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "name",
			  &(clui_info->name_string),
			  &(clui_info->name_flag))))
	{
	    kerror(NULL, "gisosurface_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "gisosurface_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



