 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gimpfacet
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gimpfacet.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Import FACET data
|
|       Purpose: main program for gimpfacet
|
|         Input:
|		char *clui_info->i_file; {input facet file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output geometry object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->name_string; {object name}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|        Output:
|       Returns:
|
|    Written By: Steve Kubica
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kfile  *in;
	kobject out;
	char   *name;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gimpfacet_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY",
			       "gimpfacet",
			       gimpfacet_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gimpfacet_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in = kfopen(clui_info->i_file, "r")) == NULL)
	{
	   kerror(NULL, "gimpfacet", 
		  "Unable to open input '%s' for reading",
		  (clui_info->i_file == NULL) ? "NULL" : clui_info->i_file);
	   kexit(KEXIT_FAILURE);
	}

	if ((out = kgeom_open_output_object(clui_info->o_file)) == NULL)
	{
	   kerror(NULL, "gimpfacet", 
		  "Unable to open output '%s' for writing",
		  (clui_info->o_file == NULL) ? "NULL" : clui_info->o_file);
	   kexit(KEXIT_FAILURE);
	}

	if (clui_info->name_flag)
	   name = clui_info->name_string;
	else
	   name = "facets";
/* -main_before_lib_call_end */

/* -main_library_call */
	lgimpfacet(in, name, out);
/* -main_library_call_end */

/* -main_after_lib_call */
	kfclose(in);
	
	kgeom_close_object(out);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gimpfacet_usage_additions
| 
|       Purpose: Prints usage additions in gimpfacet_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gimpfacet
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gimpfacet_usage_additions(void)
{
	kfprintf(kstderr, "\tImport FACET data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gimpfacet_free_args
| 
|       Purpose: Frees CLUI struct allocated in gimpfacet_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gimpfacet
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gimpfacet_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->name_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
