 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for ggridder2d
   >>>> 
   >>>>    Written By: Wes Bethel
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 12, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _ggridder2d_h_
#define _ggridder2d_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>

/* -include_includes */
#include <geometry/geometry.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#if (KOPSYS_LOCAL == KOPSYS_AIX) || (KOPSYS_LOCAL == KOPSYS_HPUX)
#  define IDSFFT idsfft
#else
#  if (KOPSYS_LOCAL != KOPSYS_UNICOS)
#    define IDSFFT idsfft_
#  endif
#endif
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/kroutine/ggridder2d/uis/ggridder2d.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input data object (required infile)
 */
char	*i_file;	/* input data object FILENAME */
int	 i_flag;	/* input data object FLAG */

/*
 *  output data object (required outfile)
 */
char	*o_file;	/* output data object FILENAME */
int	 o_flag;	/* output data object FLAG */

/*
 *  value indicating x-resolution of output grid (optional integer)
 */
int	 grid_size_x_int; 	/* value indicating x-resolution of output grid INT */
int	 grid_size_x_flag;	/* value indicating x-resolution of output grid FLAG */

/*
 *  value indicating y-resolution of output grid (optional integer)
 */
int	 grid_size_y_int; 	/* value indicating y-resolution of output grid INT */
int	 grid_size_y_flag;	/* value indicating y-resolution of output grid FLAG */

/*----- optional ME group ----*/
	/*---- nested optional MI group ----*/
/*
 *  use inverse-distance method (optional flag)
 */
int	 inverse_distance_method_flag;  	/* use inverse-distance method FLAG */

/*
 *  user-defined radius, inside which points will be averaged  (optional double)
 */
double	 inverse_distance_radius_double;	/* user-defined radius, inside which points will be averaged  DOUBLE */
int	 inverse_distance_radius_flag;   	/* user-defined radius, inside which points will be averaged  FLAG */

/*
 *  exponent to use in denominator of inversion equation (optional double)
 */
double	 inverse_distance_exponent_double;	/* exponent to use in denominator of inversion equation DOUBLE */
int	 inverse_distance_exponent_flag;   	/* exponent to use in denominator of inversion equation FLAG */

/*
 *  the value to use when the output grid point is not defined (optional double)
 */
double	 inverse_distance_undefined_value_double;	/* the value to use when the output grid point is not defined DOUBLE */
int	 inverse_distance_undefined_value_flag;   	/* the value to use when the output grid point is not defined FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  use 2d fourier analysis flag (optional flag)
 */
int	 idsfft_method_flag;  	/* use 2d fourier analysis flag FLAG */

/*
 *  number of points to use in computing partial derivatives (optional double)
 */
double	 idsfft_npoints_double;	/* number of points to use in computing partial derivatives DOUBLE */
int	 idsfft_npoints_flag;   	/* number of points to use in computing partial derivatives FLAG */

	/*-- nested optional MI group end --*/

/*-- optional ME group end ---*/

/*----- optional ME group ----*/
/*
 *  Compute output grid min/max from input location data (optional flag)
 */
int	 compute_grid_min_max_flag;  	/* Compute output grid min/max from input location data FLAG */

	/*---- nested optional MI group ----*/
/*
 *  user defined grid min/max vertices, in 2D (optional flag)
 */
int	 user_grid_min_max_flag;  	/* user defined grid min/max vertices, in 2D FLAG */

/*
 *  X min coordinate for interpolation grid (optional double)
 */
double	 user_grid_x_min_double;	/* X min coordinate for interpolation grid DOUBLE */
int	 user_grid_x_min_flag;   	/* X min coordinate for interpolation grid FLAG */

/*
 *  Y min coordinate for interpolation grid (optional double)
 */
double	 user_grid_y_min_double;	/* Y min coordinate for interpolation grid DOUBLE */
int	 user_grid_y_min_flag;   	/* Y min coordinate for interpolation grid FLAG */

/*
 *  X max coordinate for interpolation grid (optional double)
 */
double	 user_grid_x_max_double;	/* X max coordinate for interpolation grid DOUBLE */
int	 user_grid_x_max_flag;   	/* X max coordinate for interpolation grid FLAG */

/*
 *  Y max coordinate for interpolation grid (optional double)
 */
double	 user_grid_y_max_double;	/* Y max coordinate for interpolation grid DOUBLE */
int	 user_grid_y_max_flag;   	/* Y max coordinate for interpolation grid FLAG */

	/*-- nested optional MI group end --*/

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void ggridder2d_get_args PROTO((kform *));
void ggridder2d_usage_additions PROTO((void));
void ggridder2d_free_args PROTO((int, kaddr));

/* -include_routines */
int lggridder2d PROTO((kobject, kobject, int, float *, int, float *, int, int));
void bivar_work PROTO((float *, float *, float *, int, float *, float *, float *, int, int, float *, float *, float *));
/* -include_routines_end */

#endif
