
/*********************************************************************

Copyright (C) 1994, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#include "design.h"

void
bivar_work(float *in_x,
	   float *in_y,
	   float *in_z,
	   int inpoints,
	   float *out_x,
	   float *out_y,
	   float *out_z,
	   int xres,
	   int yres,
	   float *undef_value,
	   float *exponent,
	   float *radius)
{
    int i,j,k,l;
    int offset=0;
    double xdist,t,xnumer,xdenom,wf,sr,t2;
    int direct_hit;

    wf = *exponent;
    sr = *radius;
    
    for (k=0;k<yres;k++)  /* loop over grid J dimension */
    {
	for (j=0;j<xres;j++)  /* loop over grid I dimension */
	{
	    xnumer = 0.;
	    xdenom = 0.;
	    direct_hit = 0;
	    l=0;
	    for (i=0;i<inpoints;i++)  /* loop on all input scattter points */
	    {
		
/*	old rectilinear version:
	t = (xg[j]-x[i])*(xg[j]-x[i]) + (yg[k]-y[i])*(yg[k]-y[i]); */
		
		t = (out_x[offset]-in_x[i])*(out_x[offset]-in_x[i]) +
		    (out_y[offset]-in_y[i])*(out_y[offset]-in_y[i]); 
	    
		xdist = ksqrt(t);
		
		if (xdist < 1.0e-5)  /* if distance == 0 */
		{
		    direct_hit = 1;
		    out_z[offset] = in_z[i];
		    break;
		}

		if (xdist < sr)  /* if distance < search radius */
		{
		    l++;
		    t2 = 1./(kpow(xdist,wf));
		    xnumer = xnumer+ t2 * in_z[i];
		    xdenom = xdenom+t2;
		}
	    }
	    
	    if (direct_hit != 1)
	    {
		if (l == 0)
/*		    zg[d] = *undef_value; */
		    out_z[offset] = *undef_value;
		else
/*		    zg[d] = xnumer/xdenom; */
		    out_z[offset] = xnumer/xdenom;
	    }
	    offset++;
	}
    }
}
