 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gcuberille
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gcuberille.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Volume Visualization using Geometric Icons.
|
|       Purpose: main program for gcuberille
|
|         Input:
|		char *clui_info->i_file; {input 3d data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->cmap_file; {input vis colormap}
|		int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		float clui_info->shrink_float; {ratio of cuberille size to grid block size.}
|		int   clui_info->shrink_flag; {TRUE if -shrink specified}
|
|		char *clui_info->name_string; {object name}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|        Output:
|       Returns:
|
|    Written By: Wes Bethel
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
    kobject inobj, cmapobj, outobj;
    float shrinkage;
    char *name;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gcuberille_free_args, NULL);

/* -main_get_args_call */
    pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gcuberille",
			   gcuberille_usage_additions);

    if (!(kclui_check_args()))
	kexit(KEXIT_FAILURE);
    gcuberille_get_args(pane);
    kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
    inobj = kpds_open_object(clui_info->i_file,KOBJ_READ);
    cmapobj = kpds_open_object(clui_info->cmap_file,KOBJ_READ);
    outobj = kgeom_open_output_object(clui_info->o_file);
    shrinkage = clui_info->shrink_float;
    name = clui_info->name_string;
/* -main_before_lib_call_end */

/* -main_library_call */
    lgcuberille(inobj,cmapobj,outobj,&shrinkage,name);
/* -main_library_call_end */

/* -main_after_lib_call */
    kpds_close_object(inobj);
    kpds_close_object(cmapobj);
    kgeom_close_object(outobj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gcuberille_usage_additions
| 
|       Purpose: Prints usage additions in gcuberille_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gcuberille
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gcuberille_usage_additions(void)
{
	kfprintf(kstderr, "\tVolume Visualization using Geometric Icons.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gcuberille_free_args
| 
|       Purpose: Frees CLUI struct allocated in gcuberille_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gcuberille
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gcuberille_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->cmap_file);
	kfree(clui_info->o_file);
	kfree(clui_info->name_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
