 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gapplytex
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gapplytex.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Assign a Texture to a Geometry Object
|
|       Purpose: main program for gapplytex
|
|         Input:
|		char *clui_info->i_file; {input geometry object apply texture to}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->i2_file; {texture object to apply}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->o_file; {output geometry object with associated texture}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: wes
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_geom,in_texture,out_geom;
	char *in_texture_tname;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gapplytex_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gapplytex",
		gapplytex_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gapplytex_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	in_geom = kpds_open_object(clui_info->i_file,KOBJ_READ);
	in_texture_tname = clui_info->i2_file;
	in_texture = kpds_open_object(in_texture_tname,KOBJ_READ);
	out_geom = kpds_open_object(clui_info->o_file,KOBJ_WRITE);
/* -main_before_lib_call_end */

/* -main_library_call */
	lgapplytex(in_geom,out_geom,in_texture,in_texture_tname);
/* -main_library_call_end */

/* -main_after_lib_call */
	kpds_close_object(in_geom);
	kpds_close_object(out_geom);
	kpds_close_object(in_texture);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gapplytex_usage_additions
| 
|       Purpose: Prints usage additions in gapplytex_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gapplytex
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gapplytex_usage_additions(void)
{
	kfprintf(kstderr, "\tAssign a Texture to a Geometry Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gapplytex_free_args
| 
|       Purpose: Frees CLUI struct allocated in gapplytex_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gapplytex
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gapplytex_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
