
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is nearly 100% hand-crafted by a human being in the USA"

*********************************************************************/
 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:
   >>>>
   >>>>    Written By: wes
   >>>>
   >>>>          Date: may 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _geometry_geom_h_
#define _geometry_geom_h_



	/*-------------------------------------*
	|       #include
	---------------------------------------*/
/**
  * kappserv.h contains some default values, like default projection type,
  * etc.
**/
#include <design.h>

	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/**
  * manifest constants
**/
#define CHILL 0
#define WHACKED 1
#define KGEOM_BIGNUM 1.0e+10
#define KGEOM_SMALLNUM -1.0e+10

/**
  * KGEOM_VERTEX_TYPE is VERY important - it is used to
  * dictate the type representation used for holding vertex,
  * normal, colors, etc in the rmonster renderer.  "float"
  * and "double" make the most sense.  before trying "int",
  * all code should be scoured with precision, etc. issues in mind.
**/
#define KGEOM_VERTEX_TYPE float

#define KMAX_IMAGE_WIDTH 4096
#define KMAX_IMAGE_HEIGHT 4096


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct vertex_3d
{
    KGEOM_VERTEX_TYPE v[3];
} vertex_3d;

typedef struct vector4
{
    KGEOM_VERTEX_TYPE v[4];
} vector4;

typedef struct
{
    KGEOM_VERTEX_TYPE rgb[3];
} rgb_vertex;

typedef struct
{
    KGEOM_VERTEX_TYPE rgba[4];
} rgba_vertex;

typedef struct
{
    KGEOM_VERTEX_TYPE m[4][4];
} matrix4x4;



	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/* a * PI/180. */
#define PI 3.1415927
#define DEGREES_TO_RADIANS(a) ((a)*0.017453292)
/* #define VCOPY(d,s) (memcpy((char *)(d),(char *)(s),sizeof(vertex_3d))) */
#define VCOPY(d,s) (kmemcpy((d),(s),sizeof(vertex_3d))) 
#define IABS(a) ((a) > 0 ? (a) : (-1 * (a)))
#define FABS(a) ((a) > 0 ? (a) : (-1. * (a)))

/* on some architectures, these are already defined  /SK */
#ifdef MAX
	#undef MAX
#endif

#ifdef MIN
	#undef MIN
#endif

#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define MIN(a,b) ((a) < (b) ? (a) : (b))

	/*-------------------------------------*
	|       constants and default values
	---------------------------------------*/

static vertex_3d DEFAULT_EYE = {0.,10.,50.};
static vertex_3d DEFAULT_AT = {0.,0.,0.};
static vertex_3d DEFAULT_UP = {0.,1.,0.};
static KGEOM_VERTEX_TYPE DEFAULT_FOV = 90.;
static KGEOM_VERTEX_TYPE DEFAULT_HITHER = 45.;
static KGEOM_VERTEX_TYPE DEFAULT_YON = 45.;
static int DEFAULT_PROJECTION = KPROJECTION_PERSPECTIVE;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/



#endif /* _geometry_geom_h_ */
/* Don't add after this point */
