 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane screen_dump
   >>>> 
   >>>>  Private: 
   >>>> 	screen_dump_display_file
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xprism.h"

/*-----------------------------------------------------------
| 
|  Routine Name: screen_dump_display_file
| 
|       Purpose: Do routine which is called when
|                  output selection display_file is used
| 
|         Input: screen_dump_info - ptr to PaneInfo struct for screen_dump pane
| 
|        Output: None
|    Written By: 
|          Date: Nov 01, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void screen_dump_display_file(
     Print_screen_dump *screen_dump_info)
{
	kobject o;
	xvobject screen;


	if ((o = kpds_open_object(screen_dump_info->display_file, KOBJ_WRITE))
		== NULL)
	   return;

	screen = (screen_dump_info->dump_what_val == 1) ? current_area : layout;
	xvw_getimage(screen, FALSE, FALSE, o);
	kpds_close_object(o);
	kinfo(KSTANDARD, "Screen dump written to '%s'", 
	      screen_dump_info->display_file);
}
