 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>           Utility Routines 
   >>>>
   >>>>  Private:
   >>>>           spc_get_new_classname()
   >>>>           spc_spc_set_displayed_min_max()
   >>>>           spc_set_total_min_max()
   >>>>           spc_cleanup()
   >>>>           spc_get_unassigned_class_id()
   >>>>           spc_find_class_from_id()
   >>>>           spc_update_utm_position()
   >>>>           spc_update_GUI_from_mapcol_names()
   >>>>           spc_install_add_or_delete_cluster_handler()
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "spectrum.h"

/*-----------------------------------------------------------
|
|  Routine Name: spc_get_new_classname
|
|       Purpose: Gets a new name for the class  
|         Input: None
|        Output: classname - allocates & returns new class name
|       Returns: TRUE on success, FALSE on failure
|    Written By: Danielle Argiro
|          Date: May 12, 1993
| Modifications: Updated from Khoros 1.0 (DA)
|
------------------------------------------------------------*/
int spc_get_new_classname(
    char **classname)
{
        LegendEntry *legend_ptr;
	char        *label = "Setting title of class", *button = "OK"; 
        char        **answers, **prompts; 
        int         num_prompts = 1, size = 35;

	answers = kcalloc(1, sizeof(char *));
	prompts = kcalloc(1, sizeof(char *));
        prompts[0] = kstring_copy("Enter new title:", NULL);
        answers[0] = (char *) kcalloc(1, KLENGTH*sizeof(char));
	*classname = NULL;

        /* prompt for class name */
        if (!(xvu_query_wait(label, prompts, button,
                             answers, num_prompts, size)))
	    return(FALSE);

        /* make sure that name is not already used */
        legend_ptr = spc_legend_list;
        while (legend_ptr != NULL)
        {
            if (legend_ptr->classname != NULL)
            {
                if (kstrcmp(spc_striptext(legend_ptr->classname), 
			   spc_striptext(answers[0]))==0)
                {
                    kerror(NULL, "spc_get_new_classname",
			   "There is already a class named, '%s'.  Please provide a distinct name.", legend_ptr->classname);
		    kinfo(KHOSTILE, "You can't possibly be doing anything meaningful."); 

                    return(TRUE);
                }
            }
            legend_ptr = legend_ptr->next;
        }

	karray_free(prompts, 1, NULL);
        *classname = kstring_copy(answers[0], NULL);
	karray_free(answers, 1, NULL);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: spc_set_displayed_min_max
|
|       Purpose: sets min & max over all 3 displayed columns for
|                global normalization (assumes that mins & maxes
|                for each column => have already been set)
|
|         Input: none
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: May 17, 1993
| Modifications: 
|
---------------------------------------------------------------*/
void spc_set_displayed_min_max(void)
{
        spc_display->disp_min = kmin(spc_display->red_min,   
				     spc_display->blue_min);
        spc_display->disp_min = kmin(spc_display->green_min, 
				     spc_display->disp_min);
        spc_display->disp_max = kmax(spc_display->red_max,   
				     spc_display->blue_max);
        spc_display->disp_max = kmax(spc_display->green_max, 
				     spc_display->disp_max);
}

/*-----------------------------------------------------------
|
|  Routine Name: spc_set_total_min_max
|       Purpose: sets min & max over ALL columns (displayed or not) 
|                for use with PrintClass
|         Input: none
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: May 17, 1993
| Modifications: 
|
---------------------------------------------------------------*/
void spc_set_total_min_max(void)
{
        int i, j;

        spc_display->total_min = (double) KMAXFLOAT;
        spc_display->total_max = (double) -KMAXFLOAT;
        for (i = 0; i < spc_map_colnum; i++)
        {
            for (j = 0; j < spc_map_rownum; j++)
            {
		if (spc_maps[i][j] < spc_display->total_min) 
		    spc_display->total_min = spc_maps[i][j];
		if (spc_maps[i][j] > spc_display->total_max) 
	 	    spc_display->total_max = spc_maps[i][j];
            }
        }
}


/*-----------------------------------------------------------
|
|  Routine Name: spc_cleanup
|       Purpose: Frees all memory associated with global variables,
|                for use before spectrum exits.
|         Input: none
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: May 17, 1993
| Modifications: 
|
---------------------------------------------------------------*/
void spc_cleanup(void)
{
	int         i, j, place;
	LegendEntry *legend_ptr, *next;
	
	/* free spc_maps memory */
	karray_free((kaddr)spc_maps, spc_map_rownum, NULL);

	/* free covariance matrix memory: what a pain */
	if (spc_covar_matrix != NULL)
	{
            for (i = 0; i < spc_map_rownum; i++)
	        kfree(spc_covar_matrix[i][0]); 
	    for (i = 0; i < spc_map_rownum; i++)
                kfree(spc_covar_matrix[i]);
	    kfree(spc_covar_matrix);
	}
	
	kfree(spc_covar_diag); 

	/* free class & count column memory */
	kfree(spc_classes);
	kfree(spc_count);

	/* close data object defining displayed image */
	if (spc_image != NULL)
	    kpds_close_object(spc_image);

	/* free legend list */
	kfree(spc_legend_lookup);
	legend_ptr = spc_legend_list;
	while (legend_ptr != NULL)
	{
	    next = legend_ptr->next;
	    kfree(legend_ptr); 
	    legend_ptr = next;
	}

	/* free various ptrs that are part of spc_display structure */
	if (spc_display == NULL) return;
	kfree(spc_display->red_func);
	kfree(spc_display->green_func);
	kfree(spc_display->blue_func);
	kfree(spc_display->red_col);
	kfree(spc_display->green_col);
	kfree(spc_display->blue_col);

}


/*-----------------------------------------------------------
|
|  Routine Name: spc_get_unassigned_class_id
|
|       Purpose: Finds an image class ID that is not already assigned
|
|         Input: None
|        Output: None
|       Returns: Returns class ID
|    Written By: Danielle Argiro
|          Date: Nov 3, 1993
| Modifications:
|
------------------------------------------------------------*/

int spc_get_unassigned_class_id(void)
{
        LegendEntry *legend_ptr;
        int         found = FALSE;
        int         trial_id, repeated;

        trial_id = 0;
        while (!found)
        {
            repeated = FALSE;
            trial_id++;
            legend_ptr = spc_legend_list;
            while (legend_ptr != NULL)
            {
                if (trial_id == legend_ptr->class)
                    repeated = TRUE;
                legend_ptr = legend_ptr->next;
            }
            if (!repeated) found = TRUE;
        }
        return(trial_id);
}

/*-----------------------------------------------------------
|
|  Routine Name: spc_find_class_from_id
|
|       Purpose: Searches the legend list for a class with a particular ID
|
|         Input: class - class ID to search for
|        Output: None
|       Returns: legend_ptr to class with specified ID on success, 
|                NULL on failure
|    Written By: Danielle Argiro
|          Date: Nov 4, 1993
| Modifications: 
|
------------------------------------------------------------*/
LegendEntry *spc_find_class_from_id(
    int class_id)
{
	LegendEntry *legend_ptr;

	legend_ptr = spc_legend_list;
	while (legend_ptr != NULL)
	{
	    if (legend_ptr->class == class_id)
		return(legend_ptr);
	    legend_ptr = legend_ptr->next;
	}
	return(NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: spc_update_utm_position
|
|       Purpose: Event handler which updates the UTM position 
|                in the labelstring under the image workspace as 
|                the pointer is moved across the image.
|
|         Input: object      - the image object
|                client_data - unused
|                event       - the PointerMotion event
|        Output: dispatch    - whether or not to dispatch event; unused
|       Returns: 
|    Written By: Danielle Argiro
|          Date: Aug 8, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void spc_update_utm_position(
    xvobject  object,
    kaddr     clientData,
    XEvent    *event,
    int       *dispatch)
{
	char   temp[KLENGTH];
	double northing, easting;
	int    xposition, yposition;

	
	xvw_get_attributes(object, 
			   XVW_IMAGE_XPOSITION, &xposition,
			   XVW_IMAGE_YPOSITION, &yposition,
	                   NULL);

	northing = spc_display->utm_00_N - 
		   (spc_display->pixel_dim_y * ((double) yposition));

	easting = spc_display->utm_00_E +
		   (spc_display->pixel_dim_x * ((double) xposition));

        ksprintf(temp, "%.1fN, %.1fE, Zone %s",
		 northing, easting, spc_display->utm_zone);
	xvw_set_attribute(spc_display->utm_position, XVW_LABEL, temp);
}


/*-----------------------------------------------------------
|
|  Routine Name: spc_update_GUI_from_mapcol_names
|
|       Purpose: When the map column names are changed by the user,
|                either by clicking on the "Change Mapcol Names"
|                button of the Display subform, or by entering
|                map column names as part of a display environment file,
|                there are a variety of places on the GUI that then
|                need to have strings updated to reflect the new
|                mapcol names.  This routine updates them all.
|
|         Input: none
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: Aug 8, 1994
| Modifications:
|
------------------------------------------------------------*/
void spc_update_GUI_from_mapcol_names(void)
{
	int i;
	Disp_disp       *disp_info    = gui_info->Disp->disp;
	Scatter_scatter *scatter_info = gui_info->Scatter->scatter;

	int red_col = 0, green_col = 1, blue_col = 2;

	if (spc_display->workspace != NULL)
	{
            xvw_get_attribute(spc_display->workspace,
                              XVW_COLOR_RED_MAPCOL, &red_col);
            xvw_get_attribute(spc_display->workspace,
                              XVW_COLOR_GREEN_MAPCOL, &green_col);
            xvw_get_attribute(spc_display->workspace,
                              XVW_COLOR_BLUE_MAPCOL, &blue_col);
	}

        for (i = 0; i < spc_map_colnum; i++)
        {
	     /* update label next to "RED" button on Display subform */
             if (red_col == i)
                 xvf_set_attribute(disp_info->redcol_struct,
                                   XVF_TITLE, spc_mapcol_names[i]);

	     /* update label next to "GREEN" button on Display subform */
             if (green_col == i)
                  xvf_set_attribute(disp_info->grcol_struct,
                                    XVF_TITLE, spc_mapcol_names[i]);

	     /* update label next to "BLUE" button on Display subform */
             if (blue_col == i)
                  xvf_set_attribute(disp_info->blcol_struct,
                                    XVF_TITLE, spc_mapcol_names[i]);
             if (spc_scatter != NULL)
             {
	        /* 
		 * update label next to "Column Displayed as X" button 
	         * on Scatterplot subform 
	         */
                if (spc_scatter->xcol == i)
                {
                    xvw_set_attribute(spc_scatter->xaxis,
                                      XVW_AXIS_LABEL, spc_mapcol_names[i]);
                    xvf_set_attribute(scatter_info->xcol_blank_struct,
                                      XVF_TITLE, spc_mapcol_names[i]);
                }
	        /* 
		 * update label next to "Column Displayed as Y" button 
	         * on Scatterplot subform 
	         */
                if (spc_scatter->ycol == i)
                {
                    xvw_set_attribute(spc_scatter->yaxis,
                                      XVW_AXIS_LABEL, spc_mapcol_names[i]);
                    xvf_set_attribute(scatter_info->ycol_blank_struct,
                                      XVF_TITLE, spc_mapcol_names[i]);

                }
            }

            if ((spc_info != NULL) &&
                (spc_info->mapcols_obj != NULL) &&
                (spc_info->mapcols_obj[i] != NULL))
            {
                xvw_set_attribute(spc_info->mapcols_obj[i],
                                  XVW_LABEL, spc_mapcol_names[i]);
            }
        }

}

/*-----------------------------------------------------------
|
|  Routine Name: spc_find_unique_values_from_polygon
|
|       Purpose: Given a data object representing a polygonal
|		 region of interest, finds all the unique values
|		 in the polygon and returns an array containing 
|		 those values
|
|         Input: roi  - data object representing polygon ROI
|        Output: size - size of integer array returned
|       Returns: an integer array containing all the unique values in polygon
|    Written By: Danielle Argiro
|          Date: Feb 20, 1995
| Modifications:
|
------------------------------------------------------------*/
int *spc_find_unique_values_from_polygon(
    kobject roi,
    int     *size)
{
        int  found, i, w, h, d, t, e;
        int  *value_region, *mask_region;
        int  *unique_values = NULL;

        kpds_get_attribute(roi, KPDS_VALUE_SIZE, &w, &h, &d, &t, &e);
        kpds_set_attribute(roi, KPDS_VALUE_REGION_SIZE, w, h, d, t, e);
        kpds_set_attribute(roi, KPDS_MASK_REGION_SIZE, w, h, d, t, e);
        kpds_set_attribute(roi, KPDS_VALUE_POSITION, 0, 0, 0, 0, 0);
        kpds_set_attribute(roi, KPDS_MASK_POSITION, 0, 0, 0, 0, 0);
        kpds_set_attribute(roi, KPDS_VALUE_DATA_TYPE, KINT);
        kpds_set_attribute(roi, KPDS_MASK_DATA_TYPE, KINT);

        value_region = (int *) kpds_get_data(roi, KPDS_VALUE_REGION, NULL);
        mask_region = (int *)  kpds_get_data(roi, KPDS_MASK_REGION, NULL);

        /*
         * get an array of the unique cluster values in the polygon ROI
         */
        *size = 0;
        for (i = 0; i < w*h*d*t*e; i++)
        {
            found = karray_locate((kaddr)unique_values, (kaddr) value_region[i],
 *size);
            if ((found == -1) && (mask_region[i] != 0))
                unique_values = (int *) karray_add((char **)unique_values,
                                           (kaddr) value_region[i], (*size)++);
        }
	if (*size == 0)
	    return(NULL);

	return(unique_values);
}


/*-----------------------------------------------------------
|
|  Routine Name: spc_install_add_or_delete_cluster_handler
|
|       Purpose: Event handlers (for pointer motion) and action
|		 handlers (for double click) are installed/deinstalled
|		 in the main spectrum workspace and in the zoom window
|		 depending on what's going on.  This utility routine
|		 simply isolates the installation/deinstallation procedure
|		 as it gets done fairly often in a number of situations.
|
|         Input: install - TRUE to install handlers, FALSE to remove them.
|        Output: None
|    Written By: Danielle Argiro
|          Date: Feb 14, 1995
| Modifications:
|
------------------------------------------------------------*/

void spc_install_add_or_delete_cluster_handler(
    int install)
{
	/*
	 * sanity check
	 */
	if (spc_image == NULL) return;

        /*
	 * installing the event/action handlers that let user PAINT to 
         * classify. if zoom mode is set to button press, add event handler 
	 * to zoom window; otherwise add it to the displayed image
         */
	if ((install) && (clui_info->method_cycle == SPC_PAINT))
	{
            if (gui_info->Zoom->zoom->zoommode == KZOOM_UM_BUTTON_PRESS)
            {
                xvw_add_event(zoom_workspace, ButtonMotionMask,
                              spc_paint_from_img, NULL);
                xvw_add_action(zoom_workspace, "<Btn1Down>(2)",
                               spc_paint_from_img, NULL, TRUE);
            }
            else
            {
                xvw_add_event(spc_display->workspace, ButtonMotionMask,
                              spc_paint_from_img, NULL);
                xvw_add_action(spc_display->workspace, "<Btn1Down>(2)",
                              spc_paint_from_img, NULL, TRUE);
            }
	}

	/*
	 * removing the event/action handlers that let user PAINT to 
         * classify. if zoom mode is set to button press, remove event handler 
	 * from zoom window; otherwise remove it from the displayed image
	 */
	else if ((!install) && (clui_info->method_cycle == SPC_PAINT))
	{
            if (gui_info->Zoom->zoom->zoommode == KZOOM_UM_BUTTON_PRESS)
            {
                xvw_remove_event(zoom_workspace, ButtonMotionMask,
                              spc_paint_from_img, NULL);
                xvw_remove_action(zoom_workspace, "<Btn1Down>(2)",
                               spc_paint_from_img, NULL);
            }
            else
            {
                xvw_remove_event(spc_display->workspace, ButtonMotionMask,
                              spc_paint_from_img, NULL);
                xvw_remove_action(spc_display->workspace, "<Btn1Down>(2)",
                              spc_paint_from_img, NULL);
            }
	}
        /*
         * installing the event/action handlers that let user POLYGON to 
         * classify. if zoom mode is set to button press, add event handler
         * to zoom window; otherwise add it to the displayed image
         */
        if ((install) && (clui_info->method_cycle == SPC_POLYGON))
        {
            if (gui_info->Zoom->zoom->zoommode == KZOOM_UM_BUTTON_PRESS)
            {
                xvw_add_event(zoom_workspace, ButtonMotionMask,
                              spc_polygon_from_img, NULL);
                xvw_add_action(zoom_workspace, "<Btn1Down>(2)",
                               spc_paint_from_img, NULL, TRUE);
            }
            else
            {
                xvw_add_event(spc_display->workspace, ButtonMotionMask,
                              spc_polygon_from_img, NULL);
                xvw_add_action(spc_display->workspace, "<Btn1Down>(2)",
                              spc_paint_from_img, NULL, TRUE);
            }
        }

        /*
         * removing the event/action handlers that let user POLYGON to 
         * classify. if zoom mode is set to button press, remove event handler
         * from zoom window; otherwise remove it from the displayed image
         */
        else if ((!install) && (clui_info->method_cycle == SPC_POLYGON))
        {
            if (gui_info->Zoom->zoom->zoommode == KZOOM_UM_BUTTON_PRESS)
            {
                xvw_remove_event(zoom_workspace, ButtonMotionMask,
                              spc_polygon_from_img, NULL);
                xvw_remove_action(zoom_workspace, "<Btn1Down>(2)",
                               spc_paint_from_img, NULL);
            }
            else
            {
                xvw_remove_event(spc_display->workspace, ButtonMotionMask,
                              spc_polygon_from_img, NULL);
                xvw_remove_action(spc_display->workspace, "<Btn1Down>(2)",
                              spc_paint_from_img, NULL);
            }
        }


}



