 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>           Input Routines 
   >>>>
   >>>>  Private:
   >>>>         spc_input_new_image
   >>>>
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "spectrum.h"

/*-----------------------------------------------------------
|
|  Routine Name: spc_input_new_image
|
|       Purpose: Inputs a new image, updates GUI
|         Input: filename - name of new image file
|        Output: None
|       Returns: TRUE on success, FALSE on failure
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications:
|
------------------------------------------------------------*/
void spc_input_new_image(
    char  *filename)
{
	int         i, cluster;
	char        temp[KLENGTH];
	LegendEntry *legend_ptr;
	double      spectral_min, spectral_max;
	xvobject    master_back, offset;
	int         norm_type   = gui_info->Disp->disp->norm_type;
	int         norm_method = gui_info->Disp->disp->norm_method_val;

	/*
	 * if there are any classes already created, delete the
	 * old clusters belonging to the classes  (leave the classes
	 * themselves, they might be useful this time, too).
	 */
	if (spc_legend_list != NULL)
	{
	    legend_ptr = spc_legend_list;
	    while (legend_ptr != NULL)
	    {
            	spc_empty_class(legend_ptr);
		legend_ptr = legend_ptr->next;
	    }
	}

	/*
	 * if there was a previous image w/ codebook, destroy labelstrings
	 * on statistics subform in preparation for creation of new labelstrings
	 * for new map columns.
	 */
	spc_destroy_mapcolstats_labels();

	/* 
	 * create the image display structure if it hasn't been created yet 
         */
	if (spc_display == NULL)
	{
	    spc_display = (ImageDisplayStruct *) 
			   kcalloc(1, sizeof(ImageDisplayStruct));

	    spc_display->parent = gui_info->image_workspace;

	    /* create the image xvobject */
	    spc_display->workspace = xvw_create_image(spc_display->parent,
					              "image_workspace");

	    xvw_set_attribute(spc_display->workspace, XVW_CURSORNAME, 
		     "$DESIGN/objects/library/xvisual/misc/cursors/cross");

	    if (clui_info->visual_cycle == KCOLOR_ALLOC_READWRITE)
	    {
	        xvw_set_attribute(spc_display->workspace, 
			  XVW_COLOR_ALLOC_POLICY, KCOLOR_ALLOC_READWRITE);
	    }

	    /*
             * create a colorcell
             */
            spc_display->colorbox = xvw_create_colorcell(spc_display->parent,
                                                          "colorcell");
            xvw_set_attributes(spc_display->colorbox,
                           XVW_BELOW,       spc_display->workspace,
                           XVW_RIGHT_OF,    NULL,
                           XVW_ABOVE,       NULL,
                           XVW_WIDTH,       30,
                           XVW_HEIGHT,      30,
                           NULL);
            /*
             *  create the label that will display the plot position
             */
            spc_display->position_label = 	
			xvw_create_labelstr(spc_display->parent,
                                                    "position_label");
            ksprintf(temp, "Image Position = (XXX x YYY) ");
            xvw_set_attributes(spc_display->position_label,
                               XVW_BELOW,           spc_display->workspace,
                               XVW_RIGHT_OF,        spc_display->colorbox,
                               XVW_HORIZ_DIST,      25,
                               XVW_LABEL,           temp,
                               NULL);
	    /*
             *  create the label that will display the cluster number
             */
            spc_display->cluster_label = 	
				xvw_create_labelstr(spc_display->parent,
                                                    "cluster_label");
            ksprintf(temp, "Cluster Number XX, not member of class");
            xvw_set_attributes(spc_display->cluster_label,
                           XVW_BELOW,           spc_display->position_label,
                           XVW_RIGHT_OF,        spc_display->colorbox,
                           XVW_HORIZ_DIST,      25,
                           XVW_LABEL,           temp,
                           NULL);


	    /* add pan icon xvobject for use with too-large images */
	    master_back = xvf_get_xvobject(gui_info->spectrum_struct,
					   XVF_BACKPLANE, TRUE);
	    spc_display->panicon = xvw_create_panicon(master_back, "panicon");
	    xvw_set_attributes(spc_display->panicon,
		       XVW_ABOVE,        NULL,
		       XVW_RIGHT_OF,     NULL,
		       XVW_LEFT_OF,      spc_display->parent,
		       XVW_PANICON_SIZE, 125,
		       NULL);

	    /* initialize names of functions for red, green, blue bands */
	    spc_display->red_func   = kstring_copy("M0", NULL);
            spc_display->green_func = kstring_copy("M1", NULL);
            spc_display->blue_func  = kstring_copy("M2", NULL);

	}

	/*
	 *  set the spc_image and spc_map
	 */
	if (!(spc_set_image_and_maps(filename)))
	    return;

	/*
	 * re-initialize plot information
	 */
	spc_init_plot_info();

	/*
	 * display the new image in the workspace
	 */
	xvw_set_attributes(spc_display->workspace, 
			   XVW_IMAGE_IMAGEOBJ,   spc_image,
			   XVW_IMAGE_ROI_SHAPE,  KIMAGE_ROI_POLYLINE,
			   NULL); 
	/*
	 * pan icon for when image is too large to fit in image workspace
	 */
	xvw_set_attribute(spc_display->panicon, 
			  XVW_IMAGE_IMAGEOBJ,  spc_image);

	/*
	 * zoom object will zoom on position of pointer in image
 	 */
	if (zoom_workspace != NULL)
	    xvw_set_attribute(zoom_workspace, XVW_IMAGE_IMAGEOBJ, spc_image);

	/*
	 * add event handlers to main spectrum workspace:
	 * 	1 - to update spectral curve,
         * 	2 - to update individual cluster statistics, 
	 *	3 - to update scatterplot marker
	 *	4 - to update image position/cluster number labels under image
	 */
	if (spc_image != NULL)
	{
            xvw_add_event(spc_display->workspace, PointerMotionMask,
                          spc_update_spectral_curve, NULL);
            xvw_add_event(spc_display->workspace, PointerMotionMask,
                          spc_update_cluster_stats, NULL);
            xvw_add_event(spc_display->workspace, PointerMotionMask,
                          spc_highlight_pointer_position, NULL);
	    xvw_add_event(spc_display->workspace, PointerMotionMask,
                          spc_update_image_position, NULL);
	}

	/*
	 * update GUI to reflect filename
	 */
	xvf_set_attribute(gui_info->Files->files->in_image_struct,
		          XVF_FILE_NAME, filename);
	kfree(gui_info->Files->files->in_image);
	gui_info->Files->files->in_image = kstrdup(filename);


	/*	
         * need to add the event/action handlers to let user 
	 * add/delete clusters from main spectrum workspace or zoom window.
	 */
	spc_install_add_or_delete_cluster_handler(TRUE);

	/*
	 * add event handlers to zoom window:
	 * 	 1 - to update spectral curve
	 * 	 2 - to update individual cluster statistics
         *       3 - to update scatterplot marker
	 * 	 4 - to update image position/cluster number labels under image
	 */
        xvw_add_event(zoom_workspace, PointerMotionMask,
                      spc_update_spectral_curve, NULL);
	xvw_add_event(zoom_workspace, PointerMotionMask,
                      spc_update_cluster_stats, NULL);
        xvw_add_event(zoom_workspace, PointerMotionMask,
                      spc_highlight_pointer_position, NULL);
	xvw_add_event(zoom_workspace, PointerMotionMask,
                      spc_update_image_position, NULL);
	/*
         *  set colors for pre-existing classes
	 */
	legend_ptr = spc_legend_list;
	
	spc_legend_lookup = (LegendEntry **) krealloc(spc_legend_lookup,
						      spc_map_rownum *
						      (sizeof(LegendEntry *)));
	for (i = 0; i < spc_map_rownum; i++)
	   spc_legend_lookup[i] = NULL;

        while (legend_ptr != NULL)
        {
	    /*
	     * set the colorbox to be associated with the new image;
	     * clear old colorcell list
	     */
	    xvw_set_attributes(legend_ptr->colorbox, 
			       XVW_COLOR_COLOROBJ, spc_image,
			       XVW_COLORCELL_CLEAR, TRUE,
			       NULL);
	    /*
	     *  add each cluster in the class to the colorcell list,
	     *  and add in the reference in the spc_legend_lookup[] array.
	     */
	    for (i = 0; i < legend_ptr->clusternum; i++)
	    {
		xvw_set_attribute(legend_ptr->colorbox, XVW_COLORCELL_ADD, 
				  legend_ptr->clusters[i]);
		spc_legend_lookup[legend_ptr->clusters[i]] = legend_ptr; 
	    }

	    /*
	     *  set color displayed in colorcell to class color
             *  (unless class is currently hidden)
	     */
	    if (!legend_ptr->hidden)
	        xvw_set_attributes(legend_ptr->colorbox,
                          XVW_COLORCELL_REDVAL,   (int) legend_ptr->redval,
                          XVW_COLORCELL_GREENVAL, (int) legend_ptr->greenval,
                          XVW_COLORCELL_BLUEVAL,  (int) legend_ptr->blueval,
                          NULL);

	    legend_ptr = legend_ptr->next;
    	}

				
	/*
	 *  the pseudo color bars will affect both the color boxes and
         *  the colors in the image
	 */
	if (legend_pseudo != NULL)
	    xvw_set_attribute(legend_pseudo, XVW_COLOR_COLOROBJ, spc_image);

	/*
	 *  the colors of the scatterplot will reflect the colors of the classes
	 */
	if (spc_scatter->plot != NULL)
	    xvw_set_attribute(spc_scatter->plot, XVW_COLOR_COLOROBJ, spc_image);
	
	/*
	 *  eventually, will need to read in the map column names.
	 */
	kfree(spc_mapcol_names);
	spc_mapcol_names = (char **) 
			   kcalloc(1, spc_map_colnum * sizeof(char *));
	for (i = 0; i < spc_map_colnum; i++)
	{
	    ksprintf(temp, "Band %d", i+1);
	    spc_mapcol_names[i] = kstring_copy(temp, NULL);
	}

	/*
	 *  create labelstr objects on Statistics/ClassContents subform
         *  to print values of map columns for clusters as the pointer
         *  is moved across the image;  one labelstr for each map col.
         *  note this has to be done after initialization of mapcol names.
	 */
	offset = spc_info->count_obj;
	for (i = 0; i < spc_map_colnum; i++)
	    offset = spc_create_mapcolstats_label(i, offset);

	/*
 	 *  update the scatter plot
	 */
        spc_init_plot_info();
	spc_set_plotdata();

	/*
	 * update the spectral curve
 	 */
	spc_find_spectral_min_max(&spectral_min, &spectral_max);
        xvw_set_attributes(spc_curve->axis,
                           XVW_GRAPHICS_WCMIN_Y,  spectral_min,
                           XVW_GRAPHICS_WCMAX_Y,  spectral_max,
                           XVW_GRAPHICS_WCMIN_X,  1.0,
                           XVW_GRAPHICS_WCMAX_X,  (double) spc_map_colnum,
                           NULL);

	/*
	 * set the default normalization policy, normalization type,
         * and normalization method according to defaults in UIS file.
	 */
	xvw_set_attributes(spc_display->workspace,
	                   XVW_COLOR_NORM_TYPE,   norm_type,
	                   XVW_COLOR_NORM_METHOD, norm_method,
		           NULL);

	/*
	 * register classified clusters (if any) 
	 */
	for (cluster = 0; cluster < spc_map_rownum; cluster++)
	{
	   if (spc_classes[cluster] != -1)
	   { 
		legend_ptr = spc_find_class_from_id(spc_classes[cluster]);
		if (legend_ptr != NULL)
		    spc_add_cluster_to_class(legend_ptr, cluster);
	   }
	}

	/*
	 * refresh colors of clusters in classes
	 */
	spc_refresh_class_colors();

	/*
	 *  associate colorcells on main spectrum workspace, 
	 *  spectral curve, and scatter plot w/ image
	 */
	xvw_set_attribute(spc_scatter->colorcell,
                          XVW_COLOR_COLOROBJ, spc_image);
	xvw_set_attribute(spc_display->colorbox,
                          XVW_COLOR_COLOROBJ, spc_image);
	xvw_set_attribute(spc_curve->colorbox,
                          XVW_COLOR_COLOROBJ, spc_image);

	/*
	 * update Class Contents display
	 */
	spc_update_all_classcontents_labels();

}
