 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'spectrum'
   >>>> 
   >>>>  Private: 
   >>>> 	run_spectrum
   >>>> 	run_Files
   >>>> 	run_files
   >>>> 	run_Disp
   >>>> 	run_disp
   >>>> 	run_Curve
   >>>> 	run_curve
   >>>> 	run_Legend
   >>>> 	run_legend
   >>>> 	run_Zoom
   >>>> 	run_zoom
   >>>> 	run_Scatter
   >>>> 	run_scatter
   >>>> 	run_Contents
   >>>> 	run_contents
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "spectrum.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_spectrum
| 
|       Purpose: Main GUI Driver for spectrum
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_spectrum(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_spectrum(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_spectrum(master_info);
	    return;
	}

	    /*
	     * user clicked on pane action button selection 'add_class'
	     */
	    if (master_info->add_class)
	    {
	        spectrum_add_class(master_info);
	        master_info->add_class = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'delete_class'
	     */
	    else if (master_info->delete_class)
	    {
	        spectrum_delete_class(master_info);
	        master_info->delete_class = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'select'
	     */
	    else if (master_info->select)
	    {
	        spectrum_select(master_info);
	        master_info->select = FALSE;
	    }
	    /*
	     * user selected 'live' toggle selection 'cluster_operation'
	     */
	    else if (master_info->cluster_operation_selected)
	    {
	        spectrum_cluster_operation(master_info);
	        master_info->cluster_operation_selected = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'add_cluster_manually'
	     */
	    else if (master_info->add_cluster_manually)
	    {
	        spectrum_add_cluster_manually(master_info);
	        master_info->add_cluster_manually = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'delete_cluster_manually'
	     */
	    else if (master_info->delete_cluster_manually)
	    {
	        spectrum_delete_cluster_manually(master_info);
	        master_info->delete_cluster_manually = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'reassign'
	     */
	    else if (master_info->reassign)
	    {
	        spectrum_reassign(master_info);
	        master_info->reassign = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'autoclass'
	     */
	    else if (master_info->autoclass)
	    {
	        spectrum_autoclass(master_info);
	        master_info->autoclass = FALSE;
	    }
	/*
	 * action came from the 'Files' subform
	 */
	if (master_info->Files_selected)
	    run_Files(master_info->Files);
	/*
	 * action came from the 'Disp' subform
	 */
	if (master_info->Disp_selected)
	    run_Disp(master_info->Disp);
	/*
	 * action came from the 'Curve' subform
	 */
	if (master_info->Curve_selected)
	    run_Curve(master_info->Curve);
	/*
	 * action came from the 'Legend' subform
	 */
	if (master_info->Legend_selected)
	    run_Legend(master_info->Legend);
	/*
	 * action came from the 'Zoom' subform
	 */
	if (master_info->Zoom_selected)
	    run_Zoom(master_info->Zoom);
	/*
	 * action came from the 'Scatter' subform
	 */
	if (master_info->Scatter_selected)
	    run_Scatter(master_info->Scatter);
	/*
	 * action came from the 'Contents' subform
	 */
	if (master_info->Contents_selected)
	    run_Contents(master_info->Contents);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_Files
| 
|       Purpose: GUI Driver for subform 'Files'
| 
|         Input: form      - pointer to the form tree
|                Files_info - pointer to spectrum_Files struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Files(
     spectrum_Files *Files_info)
{

	/*
	 * action came from the 'files' pane
	 */
	if (Files_info->files_selected)
	    run_files(Files_info->files);


}   /* end run_Files */



/*-----------------------------------------------------------
| 
|  Routine Name: run_files
| 
|       Purpose: GUI Driver for pane 'files'
| 
|         Input: form - pointer to the form tree
|                files_info - pointer to Files_files struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_files(
     Files_files *files_info)

{

	/*
	 * user selected 'live' input file selection 'in_image'
	 */
	if (files_info->in_image_selected)
	{
	    files_in_image(files_info);
	    files_info->in_image_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'in_legend'
	 */
	else if (files_info->in_legend_selected)
	{
	    files_in_legend(files_info);
	    files_info->in_legend_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'in_environ'
	 */
	else if (files_info->in_environ_selected)
	{
	    files_in_environ(files_info);
	    files_info->in_environ_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'out_image'
	 */
	else if (files_info->out_image_selected)
	{
	    files_out_image(files_info);
	    files_info->out_image_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'out_legend'
	 */
	else if (files_info->out_legend_selected)
	{
	    files_out_legend(files_info);
	    files_info->out_legend_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'out_group'
	 */
	else if (files_info->out_group_selected)
	{
	    files_out_group(files_info);
	    files_info->out_group_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'out_maps'
	 */
	else if (files_info->out_maps_selected)
	{
	    files_out_maps(files_info);
	    files_info->out_maps_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Disp
| 
|       Purpose: GUI Driver for subform 'Disp'
| 
|         Input: form      - pointer to the form tree
|                Disp_info - pointer to spectrum_Disp struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Disp(
     spectrum_Disp *Disp_info)
{

	/*
	 * action came from the 'disp' pane
	 */
	if (Disp_info->disp_selected)
	    run_disp(Disp_info->disp);


}   /* end run_Disp */



/*-----------------------------------------------------------
| 
|  Routine Name: run_disp
| 
|       Purpose: GUI Driver for pane 'disp'
| 
|         Input: form - pointer to the form tree
|                disp_info - pointer to Disp_disp struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_disp(
     Disp_disp *disp_info)

{

	/*
	 * user selected 'live' cycle selection 'norm_type'
	 */
	if (disp_info->norm_type_selected)
	{
	    disp_norm_type(disp_info);
	    disp_info->norm_type_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'norm_method'
	 */
	else if (disp_info->norm_method_selected)
	{
	    disp_norm_method(disp_info);
	    disp_info->norm_method_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'change_mapcol_names'
	 */
	else if (disp_info->change_mapcol_names)
	{
	    disp_change_mapcol_names(disp_info);
	    disp_info->change_mapcol_names = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'list_mapcol_names'
	 */
	else if (disp_info->list_mapcol_names)
	{
	    disp_list_mapcol_names(disp_info);
	    disp_info->list_mapcol_names = FALSE;
	}
	/*
	 * user clicked on pane action button selection 't'
	 */
	else if (disp_info->t)
	{
	    disp_t(disp_info);
	    disp_info->t = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'red'
	 */
	else if (disp_info->red)
	{
	    disp_red(disp_info);
	    disp_info->red = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'green'
	 */
	else if (disp_info->green)
	{
	    disp_green(disp_info);
	    disp_info->green = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'blue'
	 */
	else if (disp_info->blue)
	{
	    disp_blue(disp_info);
	    disp_info->blue = FALSE;
	}
	/*
	 * user selected 'live' string selection 'red_func'
	 */
	else if (disp_info->red_func_selected)
	{
	    disp_red_func(disp_info);
	    disp_info->red_func_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'green_func'
	 */
	else if (disp_info->green_func_selected)
	{
	    disp_green_func(disp_info);
	    disp_info->green_func_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'blue_func'
	 */
	else if (disp_info->blue_func_selected)
	{
	    disp_blue_func(disp_info);
	    disp_info->blue_func_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Curve
| 
|       Purpose: GUI Driver for subform 'Curve'
| 
|         Input: form      - pointer to the form tree
|                Curve_info - pointer to spectrum_Curve struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Curve(
     spectrum_Curve *Curve_info)
{

	/*
	 * action came from the 'curve' pane
	 */
	if (Curve_info->curve_selected)
	    run_curve(Curve_info->curve);


}   /* end run_Curve */



/*-----------------------------------------------------------
| 
|  Routine Name: run_curve
| 
|       Purpose: GUI Driver for pane 'curve'
| 
|         Input: form - pointer to the form tree
|                curve_info - pointer to Curve_curve struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_curve(
     Curve_curve *curve_info)

{

	/*
	 * user selected 'live' logical selection 'update_mode'
	 */
	if (curve_info->update_mode_selected)
	{
	    curve_update_mode(curve_info);
	    curve_info->update_mode_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'clear'
	 */
	else if (curve_info->clear)
	{
	    curve_clear(curve_info);
	    curve_info->clear = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Legend
| 
|       Purpose: GUI Driver for subform 'Legend'
| 
|         Input: form      - pointer to the form tree
|                Legend_info - pointer to spectrum_Legend struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Legend(
     spectrum_Legend *Legend_info)
{

	/*
	 * action came from the 'legend' pane
	 */
	if (Legend_info->legend_selected)
	    run_legend(Legend_info->legend);


}   /* end run_Legend */



/*-----------------------------------------------------------
| 
|  Routine Name: run_legend
| 
|       Purpose: GUI Driver for pane 'legend'
| 
|         Input: form - pointer to the form tree
|                legend_info - pointer to Legend_legend struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_legend(
     Legend_legend *legend_info)

{

	/*
	 * user clicked on pane action button selection 'empty'
	 */
	if (legend_info->empty)
	{
	    legend_empty(legend_info);
	    legend_info->empty = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'show'
	 */
	else if (legend_info->show)
	{
	    legend_show(legend_info);
	    legend_info->show = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'catch_all'
	 */
	else if (legend_info->catch_all)
	{
	    legend_catch_all(legend_info);
	    legend_info->catch_all = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'hide'
	 */
	else if (legend_info->hide)
	{
	    legend_hide(legend_info);
	    legend_info->hide = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'transfer'
	 */
	else if (legend_info->transfer)
	{
	    legend_transfer(legend_info);
	    legend_info->transfer = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Zoom
| 
|       Purpose: GUI Driver for subform 'Zoom'
| 
|         Input: form      - pointer to the form tree
|                Zoom_info - pointer to spectrum_Zoom struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Zoom(
     spectrum_Zoom *Zoom_info)
{

	/*
	 * action came from the 'zoom' pane
	 */
	if (Zoom_info->zoom_selected)
	    run_zoom(Zoom_info->zoom);


}   /* end run_Zoom */



/*-----------------------------------------------------------
| 
|  Routine Name: run_zoom
| 
|       Purpose: GUI Driver for pane 'zoom'
| 
|         Input: form - pointer to the form tree
|                zoom_info - pointer to Zoom_zoom struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_zoom(
     Zoom_zoom *zoom_info)

{

	/*
	 * user selected 'live' logical selection 'zoommode'
	 */
	if (zoom_info->zoommode_selected)
	{
	    zoom_zoommode(zoom_info);
	    zoom_info->zoommode_selected = FALSE;
	}
	/*
	 * user selected 'live' double selection 'zoomfactor'
	 */
	else if (zoom_info->zoomfactor_selected)
	{
	    zoom_zoomfactor(zoom_info);
	    zoom_info->zoomfactor_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Scatter
| 
|       Purpose: GUI Driver for subform 'Scatter'
| 
|         Input: form      - pointer to the form tree
|                Scatter_info - pointer to spectrum_Scatter struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Scatter(
     spectrum_Scatter *Scatter_info)
{

	/*
	 * action came from the 'scatter' pane
	 */
	if (Scatter_info->scatter_selected)
	    run_scatter(Scatter_info->scatter);


}   /* end run_Scatter */



/*-----------------------------------------------------------
| 
|  Routine Name: run_scatter
| 
|       Purpose: GUI Driver for pane 'scatter'
| 
|         Input: form - pointer to the form tree
|                scatter_info - pointer to Scatter_scatter struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_scatter(
     Scatter_scatter *scatter_info)

{

	/*
	 * user clicked on pane action button selection 'x_column'
	 */
	if (scatter_info->x_column)
	{
	    scatter_x_column(scatter_info);
	    scatter_info->x_column = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'y_column'
	 */
	else if (scatter_info->y_column)
	{
	    scatter_y_column(scatter_info);
	    scatter_info->y_column = FALSE;
	}
	/*
	 * user selected 'live' string selection 'x_func'
	 */
	else if (scatter_info->x_func_selected)
	{
	    scatter_x_func(scatter_info);
	    scatter_info->x_func_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'y_func'
	 */
	else if (scatter_info->y_func_selected)
	{
	    scatter_y_func(scatter_info);
	    scatter_info->y_func_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'set'
	 */
	else if (scatter_info->set)
	{
	    scatter_set(scatter_info);
	    scatter_info->set = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'reset'
	 */
	else if (scatter_info->reset)
	{
	    scatter_reset(scatter_info);
	    scatter_info->reset = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Contents
| 
|       Purpose: GUI Driver for subform 'Contents'
| 
|         Input: form      - pointer to the form tree
|                Contents_info - pointer to spectrum_Contents struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Contents(
     spectrum_Contents *Contents_info)
{

	/*
	 * action came from the 'contents' pane
	 */
	if (Contents_info->contents_selected)
	    run_contents(Contents_info->contents);


}   /* end run_Contents */



/*-----------------------------------------------------------
| 
|  Routine Name: run_contents
| 
|       Purpose: GUI Driver for pane 'contents'
| 
|         Input: form - pointer to the form tree
|                contents_info - pointer to Contents_contents struct
| 
|        Output: None
|    Written By: conductor -program_name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_contents(
     Contents_contents *contents_info)

{

	/*
	 * user selected 'live' output file selection 'o'
	 */
	if (contents_info->o_selected)
	{
	    contents_o(contents_info);
	    contents_info->o_selected = FALSE;
	}


}


