 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane zoom
   >>>> 
   >>>>  Private: 
   >>>> 	zoom_zoomfactor
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "spectrum.h"

/*-----------------------------------------------------------
| 
|  Routine Name: zoom_zoomfactor
| 
|       Purpose: Do routine which is called when
|                  double selection zoomfactor is used
| 
|         Input: zoom_info - ptr to PaneInfo struct for zoom pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void zoom_zoomfactor(
     Zoom_zoom *zoom_info)
{
	if (zoom_workspace != NULL)
	    xvw_set_attribute(zoom_workspace, 
		      XVW_ZOOM_FACTOR, zoom_info->zoomfactor);

}

/*-----------------------------------------------------------
| 
|  Routine Name: zoom_zoommode
| 
|       Purpose: Do routine which is called when
|                  logical selection zoommode is used
| 
|         Input: zoom_info - ptr to PaneInfo struct for zoom pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Sep 30, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void zoom_zoommode(
     Zoom_zoom *zoom_info)
{
	int *zoommode;

	zoommode = (int *) kmalloc(sizeof(int));
	*zoommode = zoom_info->zoommode;
	spc_set_zoommode((kaddr)zoommode);
}

/*-----------------------------------------------------------
|
|  Routine Name: spc_set_zoommode
|
|       Purpose: Utility routine to be called when the zoom updatemode
|                is changed; either from 
|
|         Input: client_data - used to pass in Zoom Update Mode to set:
|                              KZOOM_UM_CONTINUOUS or KZOOM_UM_BUTTON_PRESS
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro
|          Date: Nov 3, 1993
| Modifications:
|
------------------------------------------------------------*/

void spc_set_zoommode(
   kaddr client_data)
{
	int *zoommode = (int *) client_data;

	/*
	 * set zoom workspace to work in specified update mode.
	 */
        if (zoom_workspace != NULL)
            xvw_set_attribute(zoom_workspace, XVW_ZOOM_UPDATEMODE, *zoommode);

	/*
	 * remove event/action handlers currently firing on old update mode
	 */
	spc_install_add_or_delete_cluster_handler(FALSE);

	/*
	 * update GUI with current zoom update mode.
	 */
	xvf_set_attribute(gui_info->Zoom->zoom->zoommode_struct,
			  XVF_LOGIC_VAL, *zoommode);
	gui_info->Zoom->zoom->zoommode = *zoommode;

	/*
	 * add event/action handlers to fire on new update mode
	 */
	spc_install_add_or_delete_cluster_handler(TRUE);

        if (*zoommode == KZOOM_UM_BUTTON_PRESS)
            xvf_set_attribute(gui_info->select_blk_struct,
                              XVF_TITLE, "Select Cluster From Zoom Box");
        else xvf_set_attribute(gui_info->select_blk_struct,
                               XVF_TITLE, "Select Cluster From Image");
}
