 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane files
   >>>> 
   >>>>  Private: 
   >>>> 	files_in_image
   >>>> 	files_in_legend
   >>>> 	files_in_environ
   >>>> 	files_out_image
   >>>> 	files_out_legend
   >>>> 	files_out_group
   >>>> 	files_out_maps
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "spectrum.h"

/*-----------------------------------------------------------
| 
|  Routine Name: files_in_image
| 
|       Purpose: Do routine which is called when
|                  input selection in_image is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_in_image(
     Files_files *files_info)
{
	/* sanity check */
	if (files_info->in_image == NULL)
	{
	    kerror(NULL, "files_in_image", 
		   "Please provide an input file!");
	    kinfo(KHOSTILE, "Don't be such an idiot.");
	    return;
	}
	spc_input_new_image(files_info->in_image);

	if ((files_info->in_legend == NULL) &&
	    (clui_info->l_file == NULL))
	    spc_initialize_legend_list();
}



/*-----------------------------------------------------------
|
|  Routine Name: files_in_legend
|
|       Purpose: Do routine which is called when
|                  input selection in_legend is used
|
|         Input: files_info - ptr to PaneInfo struct for files pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void files_in_legend(
     Files_files *files_info)
{
        char temp[KLENGTH];
        char *label;
        char **prompts, **answers;

	if (files_info->in_legend == NULL)
	{
	    kerror(NULL, "files_in_legend",
                   "No input file specified!");
            kinfo(KHOSTILE, "Don't be such an idiot.");
            return;
	}

        /*
         *  if there were classes assigned on the image already,
         *  prompt to overwrite, prompt to save, delete old legend
         */
        if (spc_legend_list != NULL)
        {
            ksprintf(temp, "WARNING:  inputting a new legend file will cause all current class categories to be over-written.  Are you SURE you want to replace all current class categories with those specified in the new legend?");
            if (!(kprompt(KSTANDARD, "Yes", "Cancel", 0, temp)))
                return;
        }

        /*
         * read in new legend
         */
        if (!(spc_read_legend_file(files_info->in_legend)))
            return;

	spc_update_all_classcontents_labels();
}



/*-----------------------------------------------------------
| 
|  Routine Name: files_in_environ
| 
|       Purpose: Do routine which is called when
|                  input selection in_equations is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: 
|          Date: Jul 16, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_in_environ(
     Files_files *files_info)
{
	/*
	 * there must be an image displayed
	 */
	if (spc_image == NULL)
	{
	    kerror(NULL, "files_in_environ",
		   "Please input an image before inputting a display environment file");
	    return;
	}

	/*
	 * read in the new environment file
	 */
	spc_read_environ_file(files_info->in_environ);

}

/*-----------------------------------------------------------
| 
|  Routine Name: files_out_image
| 
|       Purpose: Do routine which is called when
|                  output selection out_image is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_out_image(
     Files_files *files_info)
{
	/* sanity check */
	if (spc_image == NULL)
	{
	    kerror(NULL, "files_out_image",
		   "You must display an image before attempting output!");
	    kinfo(KHOSTILE, "Just post a message outside your door to warn innocent bystanders - 'Leave common sense outside'");
	    return;
	}

	/* sanity check # 2 */
	if (files_info->out_image == NULL)
	{
	    kerror(NULL, "files_out_image", 
		   "Please provide the name of an output file!");
	    kinfo(KHOSTILE, "Don't be such a dweeb.");
	    return;
	}

	/* write out the image */
	if (spc_write_output_image(files_info->out_image))
	    kinfo(KSTANDARD, "Output image written to '%s'", 
		  files_info->out_image);
}


/*-----------------------------------------------------------
| 
|  Routine Name: files_out_legend
| 
|       Purpose: Do routine which is called when
|                  output selection out_legend is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_out_legend(
     Files_files *files_info)
{
	/* sanity check */
	if (spc_image == NULL)
	{
	    kerror(NULL, "files_out_image",
		   "You must display an image & create a legend before attempting legend output!");
	    kinfo(KHOSTILE, "Have you considered thinking about what you're doing before you do it?");
	    return;
	}

	if (spc_write_legend_file(files_info->out_legend))
            kinfo(KSTANDARD, "Legend output to file %s",
                  files_info->out_legend);
}


/*-----------------------------------------------------------
| 
|  Routine Name: files_out_group
| 
|       Purpose: Do routine which is called when
|                  output selection out_group is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: 
|          Date: Jul 16, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_out_group(
     Files_files *files_info)
{
        /* sanity check */
        if (spc_image == NULL)
        {
            kerror(NULL, "files_out_group",
                   "You must display an image & classify it completely before attempting a grouped image output!");
            kinfo(KHOSTILE, "Have you considered group therapy?");
            return;
        }

        if (spc_write_output_grouped_image(files_info->out_group))
            kinfo(KSTANDARD, "Grouped image output to file %s",
                  files_info->out_group);

}


/*-----------------------------------------------------------
| 
|  Routine Name: files_out_maps
| 
|       Purpose: Do routine which is called when
|                  output selection out_maps is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: 
|          Date: Jul 16, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_out_maps(
     Files_files *files_info)
{
        /* sanity check */
        if (spc_image == NULL)
        {
            kerror(NULL, "files_out_maps",
                   "You must display an image (with maps) before attempting output the maps!");
            kinfo(KHOSTILE, "Have you considered a new line of work?");
            return;
        }

        if (spc_write_output_maps(files_info->out_maps))
            kinfo(KSTANDARD, "Map data output to file %s",
                  files_info->out_maps);

}

