 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane disp
   >>>> 
   >>>>  Private: 
   >>>> 	disp_red
   >>>> 	disp_green
   >>>> 	disp_blue
   >>>> 	disp_red_func
   >>>> 	disp_green_func
   >>>> 	disp_blue_func
   >>>> 	disp_file_view
   >>>> 	disp_change_mapcol_names
   >>>> 	disp_norm_type
   >>>> 	disp_norm_method
   >>>> 	disp_norm_policy
   >>>> 	disp_t
   >>>>   Static: 
   >>>> 	change_mapcol
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "spectrum.h"

#define RED_MAPCOL   0
#define GREEN_MAPCOL 1
#define BLUE_MAPCOL  2

static int change_mapcol PROTO((int));


/*-----------------------------------------------------------
| 
|  Routine Name: disp_red
| 
|       Purpose: Do routine which is called when
|                  pane action button red is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: June 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_red(
     Disp_disp *disp_info)
{
	int  new_col;
	char temp[KLENGTH];

	if (!(change_mapcol(RED_MAPCOL)))
	    return;

	xvw_get_attribute(spc_display->workspace,
                          XVW_COLOR_RED_MAPCOL, &new_col);

	if (new_col != -1)
	{
	    ksprintf(temp, "%s", spc_mapcol_names[new_col]);
	    xvf_set_attribute(disp_info->redcol_struct, XVF_TITLE, temp);
	    ksprintf(temp, "M%d", new_col);
            xvf_set_attribute(disp_info->red_func_struct, XVF_STRING_VAL, temp);
	}
	xvf_set_attribute(disp_info->curr_trans_struct, XVF_TITLE, "none");

	spc_refresh_class_colors();
}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_green
| 
|       Purpose: Do routine which is called when
|                  pane action button green is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: June 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_green(
     Disp_disp *disp_info)
{
	int  new_col;
	char temp[KLENGTH];

	if (!(change_mapcol(GREEN_MAPCOL)))
	    return;

	xvw_get_attribute(spc_display->workspace,
                          XVW_COLOR_GREEN_MAPCOL, &new_col);

	if (new_col != -1)
	{
	    ksprintf(temp, "%s", spc_mapcol_names[new_col]);
	    xvf_set_attribute(disp_info->grcol_struct, XVF_TITLE, temp);
	    ksprintf(temp, "M%d", new_col);
            xvf_set_attribute(disp_info->green_func_struct, XVF_STRING_VAL, temp);
	}
	xvf_set_attribute(disp_info->curr_trans_struct, XVF_TITLE, "none");

	spc_refresh_class_colors();
}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_blue
| 
|       Purpose: Do routine which is called when
|                  pane action button blue is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: June 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_blue(
     Disp_disp *disp_info)
{
	int  new_col;
	char temp[KLENGTH];

	if (!(change_mapcol(BLUE_MAPCOL)))
            return;

	xvw_get_attribute(spc_display->workspace,
                          XVW_COLOR_BLUE_MAPCOL, &new_col);

        if (new_col != -1)
        {
	    ksprintf(temp, "%s", spc_mapcol_names[new_col]);
	    xvf_set_attribute(disp_info->blcol_struct, XVF_TITLE, temp);
	    ksprintf(temp, "M%d", new_col);
            xvf_set_attribute(disp_info->blue_func_struct, XVF_STRING_VAL, temp);
	}
	xvf_set_attribute(disp_info->curr_trans_struct, XVF_TITLE, "none");

	spc_refresh_class_colors();
}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_red_func
| 
|       Purpose: Do routine which is called when
|                  string selection red_func is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: June 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_red_func(
     Disp_disp *disp_info)
{
	int  mapcol = -1;
	char *equation = NULL;

	/* sanity check */
	if (disp_info->red_func == NULL)
	{
	    kerror(NULL, "disp_red_func", "Cannot apply NULL equation");
	    return;
	}

	/*
	 *  see if the name of a file containing a function was provided.
         *  if so, read the function out of the file; otherwise, take
         *  the function directly from the parameter box.  Update the
         *  map column displayed as Red according to that function. 
	 */
	equation = spc_read_eqn_string_from_file(disp_info->red_func);
	if (equation == NULL)
	    equation = disp_info->red_func;
	
	/*
	 *  save red function as spc_display->red_func
	 */
	kfree(spc_display->red_func);
	spc_display->red_func = kstring_copy(disp_info->red_func, NULL);

	/*
	 *  the image object, by virtue of the fact that it is subclassed
         *  off the Color object, handles the application of the function
	 *  to the Red column.
	 */
	xvw_set_attribute(spc_display->workspace,
			  XVW_COLOR_RED_FUNCTION, spc_display->red_func);
	xvf_set_attribute(disp_info->curr_trans_struct, XVF_TITLE, "none");
	
	spc_refresh_class_colors();

	/*
	 *  if the red function was simply a map column (not an equation)
	 *  update title of red column using map column names; else use eqn
	 */
	xvw_get_attribute(spc_display->workspace,
                          XVW_COLOR_RED_MAPCOL, &mapcol);

	/* function was an equation */
	if (mapcol == -1)
            xvf_set_attribute(disp_info->redcol_struct, XVF_TITLE,
                              disp_info->red_func);

	/* function was specification of a single map column */
	else xvf_set_attribute(disp_info->redcol_struct, XVF_TITLE,
                               spc_mapcol_names[mapcol]);


}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_green_func
| 
|       Purpose: Do routine which is called when
|                  string selection green_func is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: June 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_green_func(
     Disp_disp *disp_info)
{
	int  mapcol = -1;
        char *equation = NULL;

        /* sanity check */
        if (disp_info->green_func == NULL)
        {
            kerror(NULL, "disp_green_func", "Cannot apply NULL equation");
            return;
        }

        /*
         *  see if the name of a file containing a function was provided.
         *  if so, read the function out of the file; otherwise, take
         *  the function directly from the parameter box.  Update the
         *  map column displayed as Green according to that function.
         */
        equation = spc_read_eqn_string_from_file(disp_info->green_func);
        if (equation == NULL)
            equation = disp_info->green_func;
        
        /*
         *  save green function as spc_display->green_func
         */
        kfree(spc_display->green_func);
        spc_display->green_func = kstring_copy(disp_info->green_func, NULL);

        /*
         *  the image object, by virtue of the fact that it is subclassed
         *  off the Color object, handles the application of the function
         *  to the Green column.
         */
        xvw_set_attribute(spc_display->workspace,
                          XVW_COLOR_GREEN_FUNCTION, spc_display->green_func);
	xvf_set_attribute(disp_info->curr_trans_struct, XVF_TITLE, "none");
        
	spc_refresh_class_colors();

        /*
         *  if the green function was simply a map column (not an equation)
         *  update title of green column using map column names; else use eqn
         */
        xvw_get_attribute(spc_display->workspace,
                          XVW_COLOR_GREEN_MAPCOL, &mapcol);

        /* function was an equation */
        if (mapcol == -1)
            xvf_set_attribute(disp_info->grcol_struct, XVF_TITLE,
                              disp_info->green_func);

        /* function was specification of a single map column */
        else xvf_set_attribute(disp_info->grcol_struct, XVF_TITLE,
                               spc_mapcol_names[mapcol]);

}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_blue_func
| 
|       Purpose: Do routine which is called when
|                  string selection blue_func is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: June 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_blue_func(
     Disp_disp *disp_info)
{
	int  mapcol = -1;
        char *equation = NULL;

        /* sanity check */
        if (disp_info->blue_func == NULL)
        {
            kerror(NULL, "disp_blue_func", "Cannot apply NULL equation");
            return;
        }

        /*
         *  see if the name of a file containing a function was provided.
         *  if so, read the function out of the file; otherwise, take
         *  the function directly from the parameter box.  Update the
         *  map column displayed as Blue according to that function.
         */
        equation = spc_read_eqn_string_from_file(disp_info->blue_func);
        if (equation == NULL)
            equation = disp_info->blue_func;
        
        /*
         *  save blue function as spc_display->blue_func
         */
        kfree(spc_display->blue_func);
        spc_display->blue_func = kstring_copy(disp_info->blue_func, NULL);

        /*
         *  the image object, by virtue of the fact that it is subclassed
         *  off the Color object, handles the application of the function
         *  to the Blue column.
         */
        xvw_set_attribute(spc_display->workspace,
                          XVW_COLOR_BLUE_FUNCTION, spc_display->blue_func);
	xvf_set_attribute(disp_info->curr_trans_struct, XVF_TITLE, "none");
	spc_refresh_class_colors();
       
        /*
         *  if the blue function was simply a map column (not an equation)
         *  update title of blue column using map column names; else use eqn
         */
        xvw_get_attribute(spc_display->workspace,
                          XVW_COLOR_BLUE_MAPCOL, &mapcol);

        /* function was an equation */
        if (mapcol == -1)
            xvf_set_attribute(disp_info->blcol_struct, XVF_TITLE,
                              disp_info->blue_func);

        /* function was specification of a single map column */
        else xvf_set_attribute(disp_info->blcol_struct, XVF_TITLE,
                               spc_mapcol_names[mapcol]);

}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_change_mapcol_names
| 
|       Purpose: Do routine which is called when
|                  pane action button change_mapcol_names is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Sep 30, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_change_mapcol_names(
     Disp_disp *disp_info)
{
	char temp[KLENGTH];
	char **prompts, **answers;
	int  i, ok = FALSE;

	/* sanity check */
	if (spc_image == NULL)
	{
	    kerror(NULL, "disp_change_mapcol_names",
	         "You must display an image before changing band names!");
	    kinfo(KHOSTILE, "Use your head, doorknob.");
	    return;
	}

	prompts = (char **) kcalloc(1, spc_map_colnum * sizeof(char *));
        answers = (char **) kcalloc(1, spc_map_colnum * sizeof(char *));

	while (!ok)
	{
	    /*
	     *  set up prompts w/ old map column names entered
	     */
	    for (i = 0; i < spc_map_colnum; i++)
	    {
	        ksprintf(temp, "Band %d", i+1);
	        prompts[i] = kstring_copy(temp, NULL);
	        answers[i] = (char *) kcalloc(1, KLENGTH * sizeof(char));
	        ksprintf(answers[i], "%s", spc_mapcol_names[i]); 
	    }

	    /*
             *  prompt for new names
             */
	    (void) xvu_query_wait("Specify New Names for Bands",
                                  prompts, "ok", answers, spc_map_colnum, 25);


           /*
            *  check for invalid blank entries
            */
	    for (i = 0; i < spc_map_colnum; i++)
    	    {
	        kstring_cleanup(answers[i], temp);
	        if ((kstrlen(temp) > 0) && ((ok) || (i == 0)))
		    ok = TRUE;
	        else 
	        {
		    kerror(NULL, "disp_change_mapcol_names",
			   "NO Band Name may be left blank. Please try again.");
	            kinfo(KHOSTILE, "Jeez - you ask to change the names of bands, then leave them blank.  What a doofus.");
		    ok = FALSE;
		    break;
	        }
	    }
	}

	/*
         *  change names stored in spc_mapcol_names array
         */
	for (i = 0; i < spc_map_colnum; i++)
        {
	    kfree(spc_mapcol_names[i]);
	    spc_mapcol_names[i] = kstrdup(answers[i]);
	}

	spc_update_GUI_from_mapcol_names();

	karray_free(prompts, spc_map_colnum, NULL);
	karray_free(answers, spc_map_colnum, NULL);
}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_list_mapcol_names
| 
|       Purpose: Do routine which is called when
|                  pane action button list_mapcol_names is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
| 
|        Output: None
|    Written By: 
|          Date: Sep 30, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_list_mapcol_names(
     Disp_disp *disp_info)
{
	int  i;
	char temp[KLENGTH];
	char namelist[3*KLENGTH];

	/* sanity check */
	if (spc_image == NULL)
	{
	    kerror(NULL, "disp_list_mapcol_names",
		"You must display an image before listing band names!");
	    kinfo(KHOSTILE, "Have you seen a doctor lately?");
	    return;
	}
	ksprintf(namelist, "Band 1 = '%s'\n", spc_mapcol_names[0]);
	
	for (i = 1; i < spc_map_colnum; i++)
	{
	    ksprintf(temp, "Band %d = '%s'\n", i+1, spc_mapcol_names[i]);
	    kstring_cat(namelist, temp, namelist);
	}
	kinfo(KFORCE, namelist);

}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_norm_type
| 
|       Purpose: Do routine which is called when
|                  cycle selection norm_type is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
| 
|        Output: None
|    Written By: 
|          Date: Jun 22, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_norm_type(
     Disp_disp *disp_info)
{
	xvw_set_attribute(spc_display->workspace, XVW_COLOR_NORM_TYPE,
			  disp_info->norm_type);
	spc_refresh_class_colors();
}


/*-----------------------------------------------------------
| 
|  Routine Name: disp_norm_method
| 
|       Purpose: Do routine which is called when
|                  logical selection norm_method is used
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
| 
|        Output: None
|    Written By: 
|          Date: Jun 22, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_norm_method(
     Disp_disp *disp_info)
{
	xvw_set_attribute(spc_display->workspace, XVW_COLOR_NORM_METHOD,
			  disp_info->norm_method_val);
	spc_refresh_class_colors();
}

/*-----------------------------------------------------------
|
|  Routine Name: change_mapcol
|
|       Purpose: This routine pops up a list of the available map columns,
|                and allows the user to choose one to display as red, 
|                green, or blue.  It then calls xvw_set_attribute
|                on the corresponding red, green, blue mapcol attribute.
|
|         Input: color - RED_MAPCOL, GREEN_MAPCOL, or BLUE_MAPCOL
|        Output:
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Danielle Argiro
|          Date: Jun 24, 1994
| Modifications:
|
------------------------------------------------------------*/
static int change_mapcol(
    int color)
{
        char **list;
        char *prompt;
	char *mapcol_attribute;
        int  i, indx = -1;
        char temp[KLENGTH];

        if (color == RED_MAPCOL)
        {
            mapcol_attribute = XVW_COLOR_RED_MAPCOL;
            prompt = "Select band to use as RED";
        }
        else if (color == GREEN_MAPCOL)
        {
            mapcol_attribute = XVW_COLOR_GREEN_MAPCOL;
            prompt = "Select band to use as GREEN";
        }
        else
        {
            mapcol_attribute = XVW_COLOR_BLUE_MAPCOL;
            prompt = "Select band to use as BLUE";
        }

	/*
         *  Create the list of map column selections
         */
        list = (char **) kcalloc(1, spc_map_colnum * sizeof(char *));
        for (i = 0; i < spc_map_colnum; i++)
        {
            ksprintf(temp, "%s", spc_mapcol_names[i]);
            list[i] = kstring_copy(temp, NULL);
        }

	/*
         *  Prompt the user for which one they want.
         */
        if (kchoose(KFORCE, list, spc_map_colnum, 0, NULL, &indx, prompt) 
		    == NULL)
            indx = -1;
        else indx--;

        karray_free(list, spc_map_colnum, NULL);

	/*
         *  If the indx is not -1 (cancel), change the appropriate attribute
         */
        if (indx != -1)
            xvw_set_attribute(spc_display->workspace, mapcol_attribute, indx);
	else return(FALSE);

        return(TRUE);
}

/*-----------------------------------------------------------
| 
|  Routine Name: disp_t
| 
|       Purpose: Do routine which is called when the user clicks
|                on the Transformations action button
| 
|         Input: disp_info - ptr to PaneInfo struct for disp pane
| 
|        Output: None
|    Written By: 
|          Date: Aug 08, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void disp_t(
     Disp_disp *disp_info)
{
	int  i;
	char **transform_names;
	xvw_list_struct *list_return;
	char  *red_func, *green_func, *blue_func;

	/*
	 * the transforms were stored in the spc_trans_info array earlier, 
         * when the display environment ascii file was read in;  get the
	 * list of transform names from the spc_trans_info array, and
	 * pop up a list from which the user can select a transform.
	 */
	transform_names = (char **) kcalloc(spc_trans_num, sizeof(char *));
	for (i = 0; i < spc_trans_num; i++)
	    transform_names[i] = kstrdup(spc_trans_info[i]->name);
 	list_return = xvu_run_list_wait(transform_names, spc_trans_num,
				      "Choose the desired transform",
				      "Transforms currently defined",
				      -1, FALSE);

	karray_free(transform_names, spc_trans_num, NULL);
	if (list_return == NULL) return;

	/*
	 * set the red function according to the selected transform.
	 * all we need to do is fill in the value in the GUI, and assign the
	 * gui_info value, before calling the do routine for red functions.
	 */
	red_func = spc_trans_info[list_return->list_index]->red_equation;
	xvf_set_attribute(disp_info->red_func_struct, XVF_STRING_VAL,
			  red_func);
	kfree(disp_info->red_func);
	disp_info->red_func = kstrdup(red_func);
	disp_red_func(disp_info);

	/*
	 * set the green function according to the selected transform.
	 * all we need to do is fill in the value in the GUI, and assign the
	 * gui_info value, before calling the do routine for green functions.
	 */
	green_func = spc_trans_info[list_return->list_index]->green_equation;
	xvf_set_attribute(disp_info->red_func_struct, XVF_STRING_VAL, 
			  green_func);
	kfree(disp_info->green_func);
	disp_info->green_func = kstrdup(green_func);
	disp_green_func(disp_info);
	
	/*
	 * set the blue function according to the selected transform.
	 * all we need to do is fill in the value in the GUI, and assign the
	 * gui_info value, before calling the do routine for blue functions.
	 */
	blue_func = spc_trans_info[list_return->list_index]->blue_equation;
	xvf_set_attribute(disp_info->red_func_struct, XVF_STRING_VAL, 
			  blue_func);
	kfree(disp_info->blue_func);
	disp_info->blue_func = kstrdup(blue_func);
	disp_blue_func(disp_info);
	
	xvf_set_attribute(disp_info->curr_trans_struct, XVF_TITLE,
			  list_return->string);

}


