 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Functionality routines for putdata
   >>>>
   >>>>  Private:
   >>>>          create_putdata_workspace
   >>>>          quit_handler
   >>>>          quit_callback
   >>>>          help_callback
   >>>>          file_callback
   >>>>          menu_callback
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "putdata.h"

/*-----------------------------------------------------------
|
|  Routine Name: create_putdata_workspace()
|
|       Purpose: Creates the display workspace for putdata 
|
|         Input: none
|        Output: none
|       Returns: none
|    Written By: Mark Young
|          Date: Sep 08, 1993
| Modifications:
|
------------------------------------------------------------*/
void create_putdata_workspace(void)
{
	kobject  data = NULL;
	char	 temp[KLENGTH];
	int	 width, height;
	xvobject parent, quit, help, menu, object = NULL;

	/*
         * initialize xvwidgets
         */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "create_putdata_workspace", 
		  "Unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/*
	 * sensibility correction: [-axis] only implies [-plot2d -axis]
	 */
	if ((clui_info->axis2d_flag) && (!clui_info->plot2d_flag))
	{
	    clui_info->plot2d_flag = TRUE;
	}

	/*
	 * sanity check: need input file
	if ((!clui_info->i_flag) || (clui_info->i_file == NULL))
	   return;
	 */

	/*
	 *  create parent object
	 */
	ksprintf(temp, "Putdata: %s", !clui_info->i_file ? "(Unknown)" :
			clui_info->i_file);
	parent = xvw_create_manager(NULL, temp);

	/*
	 *  create quit button
	 */
	if (!clui_info->imageicon_flag)
	{
	    quit = xvw_create_button(parent, "quit");
	    xvw_set_attributes(quit,
		    XVW_LEFT_OF,     NULL,
		    XVW_LABEL,      "Quit",
		    XVW_CHAR_WIDTH,  5.0,
		    NULL);
	    xvw_add_callback(quit, XVW_BUTTON_SELECT, quit_callback, NULL);

	    /*
	     *  create help button
	     */
	    help = xvw_create_button(parent, "help");
	    xvw_set_attributes(help,
		    XVW_LEFT_OF,     quit,
		    XVW_LABEL,      "Help",
		    XVW_CHAR_WIDTH,  5.0,
		    NULL);
	    xvw_add_callback(help, XVW_BUTTON_SELECT, help_callback, NULL);
	}

	/*
	 * create button which will bring up internal menuform
	 */
	menu = xvw_create_button(parent, "Internal Menu");
	xvw_set_attributes(menu,
		XVW_BELOW,	  NULL,
		XVW_RIGHT_OF,	  NULL,
		XVW_LABEL,	  "Options",
		XVW_BUTTON_SHAPE, KBUTTON_SHAPE_OVAL,
		NULL);

	/*
	 * if (x,y) (w,h) device coordinates are provided, 
	 * have the toplevel pop up at that location
	 */
	if (clui_info->x_flag     || clui_info->y_flag ||
	    clui_info->width_flag || clui_info->height_flag)
	{
	   xvobject toplevel = xvw_toplevel(parent);

	   if (clui_info->x_flag)
	      xvw_set_attribute(toplevel, XVW_SHELL_X, clui_info->x_int);
	   if (clui_info->y_flag)
	      xvw_set_attribute(toplevel, XVW_SHELL_Y, clui_info->y_int);
	   if (clui_info->width_flag)
	       xvw_set_attribute(parent, XVW_WIDTH, clui_info->width_int);
	   if (clui_info->height_flag)
	       xvw_set_attribute(parent, XVW_HEIGHT, clui_info->height_int);
	}
	width = clui_info->width_int; height = clui_info->height_int;

	/*
	 * displaying an image object with position (use panicon if necessary)
	 */
	if (clui_info->image_flag)
	{
	   xvobject position, panicon;

	   /* create image object */
           object = xvw_create_image(parent, "image");
           position = xvw_create_position(parent, "position");
           xvw_set_attributes(object,
		XVW_IMAGE_IMAGEFILE,    clui_info->i_file,
		XVW_IMAGE_CLIPFILE,     clui_info->c_file,
		XVW_COLOR_COLORFILE,    clui_info->cmap_file,
	        XVW_BELOW,              menu,
	        /* XVW_ABOVE,              position, */
		/* XVW_TACK_EDGE,          KMANAGER_TACK_ALL, */
		NULL);
           xvw_get_attribute(object, XVW_IMAGE_IMAGEOBJ, &data);

	   /* create position object */
           xvw_set_attributes(position,
		XVW_POSITION_OBJECT,      data,
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
		XVW_BELOW,                object,
		/* XVW_ABOVE,		  NULL, */
		XVW_LEFT_OF,	          NULL,
		XVW_RIGHT_OF,	          NULL,
		XVW_TACK_EDGE,            KMANAGER_TACK_HORIZ, 
		NULL);

	   /* create panicon object */
	   panicon = xvw_create_panicon(parent, "panicon");
	   xvw_set_attributes(panicon,
		XVW_BELOW, menu,
		XVW_IMAGE_IMAGEOBJ, data,
		/*XVW_COLOR_ALLOC_POLICY, KCOLOR_ALLOC_READWRITE,*/
		NULL);
	}

	/*
	 *  displaying an imageicon object
	 */
	else if (clui_info->imageicon_flag)
	{
           object = xvw_create_imageicon(parent, "icon");
           xvw_set_attributes(object,
		XVW_IMAGE_IMAGEFILE, clui_info->i_file,
		XVW_IMAGE_CLIPFILE,  clui_info->c_file,
		XVW_COLOR_COLORFILE, clui_info->cmap_file,
		XVW_BELOW,           menu,
		/* XVW_TACK_EDGE,       KMANAGER_TACK_ALL,*/
		NULL);
	}

	/*
	 *  displaying a zoom object
	 */
	else if (clui_info->zoom_flag)
	{
	   xvobject position;

           object = xvw_create_zoom(parent, "zoom");
           position = xvw_create_position(parent, "position");
           xvw_set_attributes(object,
		XVW_IMAGE_IMAGEFILE, clui_info->i_file,
		XVW_IMAGE_CLIPFILE,  clui_info->c_file,
		XVW_COLOR_COLORFILE, clui_info->cmap_file,
		XVW_BELOW,           menu,
	        /* XVW_ABOVE,              position, */
		/* XVW_TACK_EDGE,          KMANAGER_TACK_ALL, */
		NULL);
           xvw_get_attribute(object, XVW_IMAGE_IMAGEOBJ, &data);
           xvw_set_attributes(position,
		XVW_POSITION_OBJECT,      data,
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
		XVW_BELOW,                object,
		/* XVW_ABOVE,		  NULL, */
		XVW_LEFT_OF,              NULL,
		XVW_RIGHT_OF,             NULL,
		XVW_TACK_EDGE,            KMANAGER_TACK_HORIZ, 
		NULL);
	}

	/*
	 *  displaying an animate object (use position object also)
	 */
	else if (clui_info->animate_flag)
	{
	   xvobject position;

           object = xvw_create_animate(parent, "animate");
           position = xvw_create_position(parent, "position");
           xvw_set_attributes(object,
		XVW_IMAGE_IMAGEFILE, clui_info->i_file,
		XVW_IMAGE_CLIPFILE,  clui_info->c_file,
		XVW_COLOR_COLORFILE, clui_info->cmap_file,
                XVW_BELOW,           menu,
	        /* XVW_ABOVE,              position, */
		/* XVW_TACK_EDGE,          KMANAGER_TACK_ALL, */
		NULL);
           xvw_get_attribute(object, XVW_IMAGE_IMAGEOBJ, &data);
           xvw_set_attributes(position,
		XVW_POSITION_OBJECT,      data,
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
		XVW_BELOW,                object,
		/* XVW_ABOVE,		  NULL, */
		XVW_LEFT_OF,	          NULL,
		XVW_RIGHT_OF,	          NULL,
		XVW_TACK_EDGE,            KMANAGER_TACK_HORIZ, 
		NULL);
	}

	/*
	 *  displaying a 2D plot object (use axes if requested)
	 */
	else if (clui_info->plot2d_flag)
	{
	   xvobject area, axis;
	
	   xvw_set_attributes(parent,
		XVW_WIDTH,  width,
		XVW_HEIGHT, height,
		NULL);

	   area = xvw_create_area(parent, "Area");
	   xvw_set_attributes(area,
		XVW_TACK_EDGE,               KMANAGER_TACK_ALL,
		XVW_AREA_DISPLAY_DATE,       FALSE,
                XVW_AREA_DISPLAY_TITLE,      FALSE,
                XVW_GRAPHICS_VIEWPORT_MIN_X, 0.1,
                XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.1,
                XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
                XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
		NULL);

	   if (clui_info->axis2d_flag)
	   {
              axis = xvw_create_axis2d(area, "Axis2d");
	      xvw_set_attribute(axis, XVW_AREA_ATTACH, axis);
	   }
	   else axis = area;

	   object = xvw_create_plot2d(area, "Plot2d");
	   xvw_set_attributes(object,
		XVW_AREA_ATTACH, axis,
		XVW_PLOT2D_PLOTFILE, clui_info->i_file,
		NULL);

	   xvw_set_attribute(area, XVW_BELOW, menu);

	   /* 
	    * need to install action handlers for quit on area object as
	    * well as on the plot object itself (which gets done later)
	    */
	   xvw_add_action(area, "<Key>q", quit_handler, NULL, TRUE);
           xvw_add_action(area, "<BtnDown>(2)", quit_handler, NULL, TRUE);

	}

	/*
	 *  displaying a 3D plot object (use axes if requested) 
	 */
	else if (clui_info->plot3d_flag)
	{
	   xvobject area;

	   xvw_set_attributes(parent,
		XVW_WIDTH,  width,
		XVW_HEIGHT, height,
		NULL);

	   area = xvw_create_area(parent, "Area");
	   xvw_set_attributes(area,
		XVW_TACK_EDGE,               KMANAGER_TACK_ALL,
		XVW_AREA_DISPLAY_DATE,       FALSE,
                XVW_AREA_DISPLAY_TITLE,      FALSE,
		XVW_GRAPHICS_VIEWPORT_MIN_X, 0.1,
		XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.1,
		XVW_GRAPHICS_VIEWPORT_MIN_Z, 0.1,
		XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
		XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
		XVW_GRAPHICS_VIEWPORT_MAX_Z, 0.9,
		NULL);

	   object = xvw_create_plot3d(area, "Plot3d");
	   xvw_set_attributes(object,
		XVW_AREA_ATTACH, area,
		XVW_PLOT3D_PLOTFILE, clui_info->i_file,
		NULL);

	   xvw_add_action(area, "<Key>q", quit_handler, NULL, TRUE);

	   /* 
	    * need to install action handlers for quit on area object as
	    * well as on the plot object itself (which gets done later)
	    */
           xvw_add_action(area, "<BtnDown>(2)", quit_handler, NULL, TRUE);
	   xvw_set_attribute(area, XVW_BELOW, menu);
	}

	/*
	 *  displaying a palette object
	 */
	else if (clui_info->palette_flag)
	{
	   object = xvw_create_palette(parent, "palette");
	   xvw_set_attribute(object, XVW_COLOR_COLORFILE, clui_info->i_file);
           xvw_set_attributes(parent,
                XVW_WIDTH,  320,
                XVW_HEIGHT, 100,
                NULL);
	   xvw_set_attributes(object, 
	        XVW_BELOW,     menu,
	        XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		NULL);
	}

	/*
	 *  displaying a printpixel object
	 */
	else if (clui_info->pixel_flag)
	{
	   object = xvw_create_printpixel(parent, "pixel");
	   xvw_set_attribute(object, XVW_PRINTPIXEL_FILENAME,clui_info->i_file);
	   xvw_set_attributes(parent, 
		XVW_WIDTH,  270,
		XVW_HEIGHT, 180,
		NULL);
	   xvw_set_attributes(object, 
		XVW_BELOW,     menu,
		XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		NULL);
	}

	/*
	 *  displaying a printmapval object
	 */
	else if (clui_info->mapval_flag)
	{
	   object = xvw_create_printmapval(parent, "mapval");
	   xvw_set_attribute(object,XVW_PRINTMAPVAL_FILENAME,clui_info->i_file);
           xvw_set_attributes(parent,
                XVW_WIDTH,  281,
                XVW_HEIGHT, 516,
                NULL);
	   xvw_set_attributes(object, 
		XVW_BELOW,     menu,
		XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		NULL);
	}
 
	/*
	 *  See if the user wishes to modify the default update time
	 */
	if (clui_info->update_flag || clui_info->update_float > 0.0)
	{
	   xvw_add_detectfile(object, clui_info->i_file,
			clui_info->update_float, file_callback, NULL);
	}
	xvw_add_callback(menu, XVW_BUTTON_SELECT, menu_callback, object);
	xvw_add_action(object, "<Key>q",    quit_handler, NULL, TRUE);
	xvw_add_action(object, "<BtnDown>(2)", quit_handler, NULL, TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: quit_handler()
|
|       Purpose: Action handler quits when user hits 'Q' or 'q',
|                or doubleclicks in window
|
|         Input: object      - the image, plot, or other object
|                client_data - not used
|                event       - the Keypress event
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro
|          Date: Nov 3, 1993
| Modifications:
|
------------------------------------------------------------*/
void quit_handler(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}

/*-----------------------------------------------------------
|
|  Routine Name: quit_callback()
|
|       Purpose: Callback quits when user hits quit button
|
|         Input: object      - the image, plot, or other object
|                client_data - not used
|                call_data   - not used
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro
|          Date: March 6, 1995
| Modifications:
|
------------------------------------------------------------*/
void quit_callback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
        xvw_destroy(xvw_parent(object));
        kexit(KEXIT_SUCCESS);
}



/*-----------------------------------------------------------
|
|  Routine Name: help_callback()
|
|       Purpose: Callback displays appropriate help page
|		 according to the type of visual display being used
|
|         Input: object      - the quit button
|                client_data - not used
|                call_data   - not used
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro
|          Date: March 7, 1995
| Modifications:
|
------------------------------------------------------------*/
void help_callback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject   helppage;
	char *filename = "$ENVISION/objects/xvroutine/putdata/help/putdata.hlp";


	helppage = xvw_create_help(NULL, "Online Help");
        xvw_set_attributes(helppage, 
			   XVW_HELP_TITLE,  "Online Help",
			   XVW_HELP_FILENAME, filename,
			   NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: menu_callback()
|
|       Purpose: Menu callback handler to invoke the current object's
|		 internal menus.
|
|         Input: object      - the menu object
|                client_data - not used
|                call_data   - the image, plot, or other object
|        Output: None
|       Returns: None
|    Written By: Mark Young
|          Date: Aug 19, 1994
| Modifications:
|
------------------------------------------------------------*/
void menu_callback(
    xvobject menu,
    kaddr    client_data,
    kaddr    call_data)
{
	xvobject object = (xvobject) client_data;

	xvw_activate_menu(object);
}

/*-----------------------------------------------------------
|
|  Routine Name: file_callback
|
|       Purpose: This is the input handler that is called when
|                the input file containing the data is updated.
|		 Depending on the type of visual object being 
|		 used (image, imageicon, zoom, animate, 2D plot,
|		 3D plot, palette, printpixel, or printmapval),
|		 the relevant visual object is updated using the 
|		 appropriate attribute.
|
|         Input:
|        Output: none
|    Written By: Mark Young & Danielle Argiro
|          Date: Aug 22, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int file_callback(
   xvobject object,
   char     *filename,
   kaddr    client_data)
{
        kobject data_object;
 
        if (kaccess(filename, R_OK) == -1)
           return(TRUE);

	/*
	 * get data object from the modified file
	 */
        if ((data_object = kpds_open_object(filename, KOBJ_READ)) != NULL)
        {
	   /* update displayed image, imageicon, zoom, or animate */
	   if ((clui_info->image_flag)     || 
	       (clui_info->imageicon_flag) ||
	       (clui_info->animate_flag)   ||
	       (clui_info->zoom_flag))
               xvw_set_attribute(object, XVW_IMAGE_IMAGEOBJ, data_object);

	   /* update displayed 2D plot */
	   else if (clui_info->plot2d_flag)
               xvw_set_attribute(object, XVW_PLOT2D_PLOTOBJ, data_object);

	   /* update displayed 3D plot */
	   else if (clui_info->plot3d_flag)
               xvw_set_attribute(object, XVW_PLOT3D_PLOTOBJ, data_object);

	   /* update displayed palette */
	   else if (clui_info->palette_flag)
               xvw_set_attribute(object, XVW_COLOR_COLOROBJ, data_object);

	   /* update displayed printpixel */
	   else if (clui_info->pixel_flag)
               xvw_set_attribute(object, XVW_PRINTPIXEL_OBJECT, data_object);

	   /* update displayed printmapval */
	   else if (clui_info->mapval_flag)
               xvw_set_attribute(object, XVW_PRINTMAPVAL_OBJECT, data_object);

           kpds_close_object(data_object);
        }
        return(TRUE);
}
