 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Utility routines for editimage
   >>>> 
   >>>>  Private: 
   >>>> 	edimg_input_newimage
   >>>> 	edimg_startup_from_clui
   >>>> 	edimg_update_image_list
   >>>> 	edimg_update_band_list
   >>>> 	adjust_gui_from_roi_shape
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "editimage.h"


/*-----------------------------------------------------------
| 
|  Routine Name: edimg_input_newimage
| 
|       Purpose: Displays a new image; updates all of the zoom,
|                position, printpixel, printmapval, pseudocolor,
|		 and thresholding displays to reflect the new image data.
| 
|         Input: filename - ptr to PaneInfo struct for file pane
|        Output: 
|    Written By: Mark Young & Danielle Argiro
|          Date: May 26, 1994 
| Modifications: 
| 
------------------------------------------------------------*/
void edimg_input_newimage(void)
{
	int      width, height, item_selected;
	char     *comment_string;
	xvobject actual_list;

	/*
	 *  set all editimage displays to have their objects associated
         *  with the data object associated with the file just read in,
         *  so that we are displaying, zooming, etc all on the same info.
	 */
        set_current_image_object();


	xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_POLICY, 
			  gui_info->MapValues->mapvals->policy);

	if (numimages == 0)
	   edimg_init_autocolor_display(current_image);

	/*
	 *  go ahead and add the object to our image list
	 */
	images = (kobject *) karray_add((char **) images, current_image,
					numimages++);
	edimg_update_image_list(numimages-1);

	/* 
         * set comment displayed in string on "Comment" pane of Options subform 
         */
	if (kpds_get_attribute(current_image, KPDS_COMMENT, &comment_string))
        {
	    xvf_set_attribute(gui_info->options->comment->comment_string_struct,
			      XVF_STRING_VAL, comment_string);
        }

	if (threshold != NULL)
  	    xvw_set_attributes(threshold, 
			       XVW_THRESHOLD_UPPERVAL, 255,
			       XVW_THRESHOLD_LOWERVAL, 0,
			       NULL);
	/*
	 * if an Autocolor Procedure or Colormap Operation was installed
	 * on the last image, it's not going to be installed on the new
	 * image, so reflect that on the GUI.
	 */
	actual_list = xvw_retrieve_list(autocolor_list);
	xvw_set_attribute(actual_list, XVW_LIST_HIGHLT_ELEM, KORIGINAL);
	actual_list = xvw_retrieve_list(cmap_op_list);
	xvw_get_attribute(actual_list, XVW_LIST_HIGHLT_ELEM, &item_selected);
        if (item_selected != -1)
            xvw_set_attribute(actual_list, XVW_LIST_UNHIGHLT_ELEM,
                              item_selected);


}

/*-----------------------------------------------------------
| 
|  Routine Name: edimg_startup_from_clui
| 
|       Purpose: On startup, makes all changes necessary
|                to properly react to CLUI arguments specified
| 
|         Input: 
|        Output: 
|    Written By: Danielle Argiro
|          Date: Aug 03, 1994 
| Modifications: 
| 
------------------------------------------------------------*/
void edimg_startup_from_clui(void)
{
	char     **format_list;
	int      format_num;

        /*
         * get list of file format types to display on the Files subform
         */
        format_list = kdms_support(&format_num);
        xvf_set_attributes(gui_info->File->file->format_struct,
                           XVF_LIST_SIZE,     format_num,
                           XVF_LIST_CONTENTS, format_list,
                           XVF_LIST_INDEX,    0,
                           NULL);
	/*
	 *  input file provided on cmd line: display input file
	 */
	if (clui_info->i_file != NULL) 
	{
	    /*
             *  get the data object associated w/ the file just specified
             */
            if ((current_image = kpds_open_object(clui_info->i_file, 
						  KOBJ_READ)) == NULL)
            {
               /*
                *  print an error indicating that we failed to open the object
                */
               kerror(NULL, "edimg_startup_from_clui",
                      "Unable to open specified data file '%s'", 
		      clui_info->i_file);
               return;
            }
	    edimg_input_newimage();
	    xvf_set_attribute(gui_info->File->file->i_struct,
			      XVF_FILE_NAME, clui_info->i_file);
	    kfree(gui_info->File->file->i);
	    gui_info->File->file->i = kstrdup(clui_info->i_file);
	}

	/*
	 *  clip mask provided on cmd line: use clip mask
	 */
	if (clui_info->c_file != NULL) 
	{
	    if (image != NULL)
  	        xvw_set_attribute(image, XVW_IMAGE_CLIPFILE, 
				  clui_info->c_file);
	    xvf_set_attribute(gui_info->File->file->c_struct,
                              XVF_FILE_NAME, clui_info->c_file);
            kfree(gui_info->File->file->c);
            gui_info->File->file->c = kstrdup(clui_info->c_file);
	}

	/*
	 * name of cmap provided on cmd line for use of separate file for cmap
	 */
        if (clui_info->cmap_flag)
        {
	    set_alternate_colormap(clui_info->cmap_file);

            xvf_set_attribute(gui_info->File->file->cmap_struct,
                              XVF_FILE_NAME, clui_info->cmap_file);
            kfree(gui_info->File->file->cmap);
            gui_info->File->file->cmap = kstrdup(clui_info->cmap_file);
        }

	/*
         *  Time interval at which the input file will be checked for
	 *  modification
	 */
        if (clui_info->update_flag)
        {
        }

	/*
	 * set the zoom factor displayed on GUI according to CLUI value
	 */
	if (clui_info->zoom_flag)
	{
	    xvw_set_attribute(zoom, XVW_ZOOM_FACTOR, clui_info->zoom_float);
	    xvf_set_attribute(gui_info->Zoom->zoom->zoomfactor_struct,
                              XVF_FLOAT_VAL, clui_info->zoom_float);
	    gui_info->Zoom->zoom->zoomfactor = clui_info->zoom_float;
	}

	/*
	 * set the visual used by the displayed image according to CLUI value
	 */
	if (clui_info->visual_cycle == KCOLOR_ALLOC_READWRITE && image != NULL)
        {
           xvw_set_attribute(image, XVW_COLOR_ALLOC_POLICY,
			KCOLOR_ALLOC_READWRITE);
        }

	/*
	 * adjust ROI pane according to initial ROI shape type.
	 */
	xvf_add_extra_call(gui_info->options->roi_struct, 
		           adjust_gui_from_roi_shape, NULL, XVF_CALL_LAST);
}

/*-----------------------------------------------------------
| 
|  Routine Name: edimg_update_image_list
| 
|       Purpose: Do routine which are called to update the image and
|		 band lists.
|         Input:
|        Output:
|    Written By: Mark Young
|          Date: Jul 03, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void edimg_update_image_list(
   int image_index)
{
	int  i;
	char **list, *name;
	kform_struct *kformstruct;
	options_lists *lists_info = gui_info->options->lists;

	kformstruct = lists_info->image_list_struct;
	for (i = 0, list = NULL; i < numimages; i++)
	{
	   name = NULL;
	   kpds_get_attribute(images[i], KPDS_NAME, &name);
	   if (!name) name = "(NULL)";
	   list = karray_insert(list, name, i, KLIST_TAIL, TRUE);
	}
	edimg_update_band_list();
	xvf_set_attribute(kformstruct, XVF_LIST_SIZE, numimages);
	xvf_set_attribute(kformstruct, XVF_LIST_CONTENTS, list);
	xvf_set_attribute(kformstruct, XVF_LIST_INDEX, image_index);
	kfree(list);
}

/*-----------------------------------------------------------
| 
|  Routine Name: edimg_update_band_list
| 
|       Purpose: Do routine which are called to update the band list.
|         Input:
|        Output:
|    Written By: Mark Young
|          Date: Jul 03, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void edimg_update_band_list(void)
{
	options_lists *lists_info = gui_info->options->lists;

	int  i, indx, num;
	kform_struct *kformstruct;
	char **list, temp[KLENGTH];


	xvw_get_attribute(image, XVW_IMAGE_BANDNUM, &indx);
	xvw_get_attribute(image, XVW_IMAGE_BAND_MAXNUM, &num); num++;
	kformstruct = lists_info->band_list_struct;
	for (i = 0, list = NULL; i < num; i++)
	{
	   ksprintf(temp,"Image Band %d", i);
	   list = karray_add(list, kstrdup(temp), i);
	}
	xvf_set_attribute(kformstruct, XVF_LIST_SIZE, num);
	xvf_set_attribute(kformstruct, XVF_LIST_CONTENTS, list);
	xvf_set_attribute(kformstruct, XVF_LIST_INDEX, indx);
	karray_free(list, num, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: adjust_gui_from_roi_shape
|
|       Purpose: This routine appropriately maps and unmaps the float
|                selections that are used for keyboard ROI extraction
|                depending on the ROI shape.  REMEMBER that this routine
|                is duplicated in extractor.
|                
|         Input: roi_info - ptr to PaneInfo struct for roi pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: Jan 04, 1995
| Modifications:
|
------------------------------------------------------------*/
void adjust_gui_from_roi_shape(void)
{
	options_roi *roi_info = gui_info->options->roi;

	/*
	 *  note i am not doing this by the book, but the quick & dirty way
	 */
	if (roi_info->shape_val == KIMAGE_ROI_RECTANGLE)
	{
	   xvw_unmanage(roi_info->line_x1_struct->Selptr->back);
	   xvw_unmanage(roi_info->line_x2_struct->Selptr->back);
	   xvw_unmanage(roi_info->line_y1_struct->Selptr->back);
	   xvw_unmanage(roi_info->line_y2_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_radius_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_x_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_y_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_x_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_y_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_a_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_b_struct->Selptr->back);

	   xvw_manage(roi_info->rect_width_struct->Selptr->back);
	   xvw_manage(roi_info->rect_height_struct->Selptr->back);
	   xvw_manage(roi_info->rect_x_struct->Selptr->back);
	   xvw_manage(roi_info->rect_y_struct->Selptr->back);
	}
	else if (roi_info->shape_val == KIMAGE_ROI_CIRCLE)
	{
	   xvw_unmanage(roi_info->rect_width_struct->Selptr->back);
	   xvw_unmanage(roi_info->rect_height_struct->Selptr->back);
	   xvw_unmanage(roi_info->rect_x_struct->Selptr->back);
	   xvw_unmanage(roi_info->rect_y_struct->Selptr->back);
           xvw_unmanage(roi_info->line_x1_struct->Selptr->back);
           xvw_unmanage(roi_info->line_x2_struct->Selptr->back);
           xvw_unmanage(roi_info->line_y1_struct->Selptr->back);
           xvw_unmanage(roi_info->line_y2_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_x_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_y_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_a_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_b_struct->Selptr->back);

	   xvw_manage(roi_info->circle_radius_struct->Selptr->back);
	   xvw_manage(roi_info->circle_x_struct->Selptr->back);
	   xvw_manage(roi_info->circle_y_struct->Selptr->back);
	}

        else if (roi_info->shape_val == KIMAGE_ROI_ELLIPSE)
        {
           xvw_unmanage(roi_info->rect_width_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_height_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_x_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_y_struct->Selptr->back);
           xvw_unmanage(roi_info->line_x1_struct->Selptr->back);
           xvw_unmanage(roi_info->line_x2_struct->Selptr->back);
           xvw_unmanage(roi_info->line_y1_struct->Selptr->back);
           xvw_unmanage(roi_info->line_y2_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_radius_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_x_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_y_struct->Selptr->back);

           xvw_manage(roi_info->ellipse_x_struct->Selptr->back);
           xvw_manage(roi_info->ellipse_y_struct->Selptr->back);
           xvw_manage(roi_info->ellipse_a_struct->Selptr->back);
           xvw_manage(roi_info->ellipse_b_struct->Selptr->back);
        }

        else if ((roi_info->shape_val == KIMAGE_ROI_POLYLINE) ||
		 (roi_info->shape_val == KIMAGE_ROI_FREEHAND))
        {
           xvw_unmanage(roi_info->line_x1_struct->Selptr->back);
           xvw_unmanage(roi_info->line_x2_struct->Selptr->back);
           xvw_unmanage(roi_info->line_y1_struct->Selptr->back);
           xvw_unmanage(roi_info->line_y2_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_radius_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_x_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_y_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_x_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_y_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_a_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_b_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_width_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_height_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_x_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_y_struct->Selptr->back);
        }
        else if (roi_info->shape_val == KIMAGE_ROI_LINE) 
        {
           xvw_unmanage(roi_info->circle_radius_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_x_struct->Selptr->back);
           xvw_unmanage(roi_info->circle_y_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_x_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_y_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_a_struct->Selptr->back);
           xvw_unmanage(roi_info->ellipse_b_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_width_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_height_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_x_struct->Selptr->back);
           xvw_unmanage(roi_info->rect_y_struct->Selptr->back);

           xvw_manage(roi_info->line_x1_struct->Selptr->back);
           xvw_manage(roi_info->line_x2_struct->Selptr->back);
           xvw_manage(roi_info->line_y1_struct->Selptr->back);
           xvw_manage(roi_info->line_y2_struct->Selptr->back);
        }

	/*
	 * trick to prevent user from using the keyboard for polygons or
	 * freehand drawing; allow them to use it for anything else
	 */
	if ((roi_info->shape_val == KIMAGE_ROI_POLYLINE) ||
	    (roi_info->shape_val == KIMAGE_ROI_FREEHAND))
	{
	   xvf_set_attribute(roi_info->mode_struct, XVF_TOGGLE_NUM, 1);
	   xvf_set_attribute(roi_info->mode_struct->Selptr->toggle_next->next->back_kformstruct,
			     XVF_ACTIVATE, FALSE);
	   roi_info->mode_val = 1;
           roi_info->mode_num = 1;
	}
	else 
	{
	   xvf_set_attribute(roi_info->mode_struct->Selptr->toggle_next->next->back_kformstruct,
			     XVF_ACTIVATE, TRUE);
	}

	adjust_gui_from_roi_mode();
}

/*-----------------------------------------------------------
|
|  Routine Name: adjust_gui_from_roi_mode
|
|       Purpose: This routine appropriately sensitizes and un-sensitizes
|                the keyboard-ROI-extraction parameters based on whether
|                the "mode" parameter is set to mouse (interactive) or
|                keyboard (non-interactive) ROI extraction. REMEMBER
|		 that this routine is duplicated in extractor.
|         Input: 
|        Output:
|    Written By: Danielle Argiro
|          Date: Jan 04, 1995
| Modifications:
|
------------------------------------------------------------*/

void adjust_gui_from_roi_mode(void)
{
	int set, shape;
	options_roi *roi_info = gui_info->options->roi;

	if (roi_info->mode_val == 1)
	   set = FALSE;
	else set = TRUE;

	shape = roi_info->shape_val;

	if  (shape == KIMAGE_ROI_LINE) 
        {
            xvw_sensitive(roi_info->line_x1_struct->Selptr->back, set);
            xvw_sensitive(roi_info->line_x2_struct->Selptr->back, set);
            xvw_sensitive(roi_info->line_y1_struct->Selptr->back, set);
            xvw_sensitive(roi_info->line_y2_struct->Selptr->back, set);
        }
	else if (shape == KIMAGE_ROI_ELLIPSE)
	{
	    xvw_sensitive(roi_info->ellipse_x_struct->Selptr->back, set);
            xvw_sensitive(roi_info->ellipse_y_struct->Selptr->back, set);
            xvw_sensitive(roi_info->ellipse_a_struct->Selptr->back, set);
            xvw_sensitive(roi_info->ellipse_b_struct->Selptr->back, set);
	}
	else if (shape == KIMAGE_ROI_CIRCLE)
	{
	    xvw_sensitive(roi_info->circle_radius_struct->Selptr->back, set);
            xvw_sensitive(roi_info->circle_x_struct->Selptr->back, set);
            xvw_sensitive(roi_info->circle_y_struct->Selptr->back, set);
	}
	else if (shape == KIMAGE_ROI_RECTANGLE)
	{
            xvw_sensitive(roi_info->rect_width_struct->Selptr->back, set);
            xvw_sensitive(roi_info->rect_height_struct->Selptr->back, set);
            xvw_sensitive(roi_info->rect_x_struct->Selptr->back, set);
            xvw_sensitive(roi_info->rect_y_struct->Selptr->back, set);
        }
}

/*-----------------------------------------------------------
|
|  Routine Name: set_current_image_object
|
|       Purpose: For incoming images, sets the image object on 
|                the image, zoom, panicon, position, printpixel,
|                printmapval, pseudo, and threshold objects. 
|         Input: none
|        Output: none
|    Written By: Danielle Argiro
|          Date: April 17, 1995
| Modifications:
|
------------------------------------------------------------*/

void set_current_image_object(void)
{
        xvw_set_attribute(image,       XVW_IMAGE_IMAGEOBJ,     current_image);
        xvw_set_attribute(zoom,        XVW_IMAGE_IMAGEOBJ,     current_image);
        xvw_set_attribute(panicon,     XVW_IMAGE_IMAGEOBJ,     current_image);
        xvw_set_attribute(position,    XVW_POSITION_OBJECT,    current_image);
        xvw_set_attribute(printpixel,  XVW_PRINTPIXEL_OBJECT,  current_image);
        xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_OBJECT, current_image);
        xvw_set_attribute(pseudo,      XVW_COLOR_COLOROBJ,     current_image);
        xvw_set_attribute(threshold,   XVW_COLOR_COLOROBJ,     current_image);
}

/*-----------------------------------------------------------
|
|  Routine Name: set_alternate_colormap
|
|       Purpose: For incoming colormaps, sets the color object on
|                the image, zoom, panicon, printpixel,
|                printmapval, pseudo, and threshold objects.
|         Input: none
|        Output: none
|    Written By: Danielle Argiro
|          Date: April 17, 1995
| Modifications:
|
------------------------------------------------------------*/

void set_alternate_colormap(
   char *filename)
{
        if (image != NULL)
            xvw_set_attribute(image, XVW_COLOR_COLORFILE, filename);
        if (zoom != NULL)
            xvw_set_attribute(zoom, XVW_COLOR_COLORFILE, filename);
        if (panicon != NULL)
            xvw_set_attribute(panicon, XVW_COLOR_COLORFILE, filename);
        if (printpixel != NULL)
            xvw_set_attribute(printpixel, XVW_COLOR_COLORFILE, filename);
        if (printmapval != NULL)
            xvw_set_attribute(printmapval, XVW_COLOR_COLORFILE, filename);
        if (pseudo != NULL)
            xvw_set_attribute(pseudo, XVW_COLOR_COLORFILE, filename);
        if (threshold != NULL)
            xvw_set_attribute(threshold, XVW_COLOR_COLORFILE, filename);
}
