 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane pixel
   >>>> 
   >>>>  Private: 
   >>>> 	pixel_update_mode
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"


/*-----------------------------------------------------------
| 
|  Routine Name: pixel_update_mode
| 
|       Purpose: Do routine which is called when
|                  logical selection update_mode is used
| 
|         Input: pixel_info - ptr to PaneInfo struct for pixel pane
| 
|        Output: None
|    Written By: 
|          Date: Oct 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void pixel_update_mode(
     Pixel_pixel *pixel_info)
{
	int update_mode;

	if (!pixel_info->update_mode)
	   update_mode = KPRINTPIXEL_UM_CONTINUOUS;
	else update_mode = KPRINTPIXEL_UM_BUTTON_PRESS;

	xvw_set_attribute(printpixel, XVW_PRINTPIXEL_UPDATEMODE, update_mode);
}
