 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane file
   >>>> 
   >>>>  Private: 
   >>>> 	file_i
   >>>> 	file_c
   >>>> 	file_cmap
   >>>> 
   >>>> 	file_o
   >>>> 	file_d
   >>>> 	file_out_cmap
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "editimage.h"

/*-----------------------------------------------------------
| 
|  Routine Name: file_i
| 
|       Purpose: Called when input selection i is used
| 
|         Input: file_info - ptr to PaneInfo struct for file pane;
|                Inputs a new image to be displayed.
|        Output: 
|    Written By: Mark Young & Danielle Argiro
|          Date: May 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_i(
     File_file *file_info)
{
	if (file_info->i == NULL)
	{
	    kerror(NULL, "file_i", "You must provide a filename!");
	    kinfo(KHOSTILE, "Feeling particularly slow today?");
	    return;
	}

	/*
         *  get the data object associated w/ the file just specified
         */
        if ((current_image = kpds_open_object(file_info->i, KOBJ_READ)) == NULL)
        {
           /*
            *  print an error indicating that we failed to open the object
            */
           kerror(NULL, "edimg_input_newimage",
                  "Unable to open specified data file '%s'", file_info->i);
           return;
        }

	/* 
	 *  simply call the routine to input a new image 
	 */
	edimg_input_newimage();
}

/*-----------------------------------------------------------
|
|  Routine Name: file_c
|
|       Purpose: Do routine which is called when
|                  input selection c is used
|
|         Input: file_info - ptr to PaneInfo struct for file pane
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void file_c(
     File_file *file_info)
{
        xvw_set_attribute(image,   XVW_IMAGE_CLIPFILE, file_info->c);
        xvw_set_attribute(zoom,    XVW_IMAGE_CLIPFILE, file_info->c);
        xvw_set_attribute(panicon, XVW_IMAGE_CLIPFILE, file_info->c);
}

/*-----------------------------------------------------------
|
|  Routine Name: file_cmap
|
|       Purpose: Do routine which is called when
|                  input selection cmap is used
|
|         Input: file_info - ptr to PaneInfo struct for file pane
|
|        Output: None
|    Written By:
|          Date: Aug 29, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void file_cmap(
     File_file *file_info)
{
        if (file_info->cmap == NULL)
        {
            kerror(NULL, "file_cmap", "You must provide a filename");
            return;
        }
	set_alternate_colormap(file_info->cmap);
}


/*-----------------------------------------------------------
| 
|  Routine Name: file_o
| 
|       Purpose: Called when output selection o is used;
|                Writes the displayed image to the specified output file.
| 
|         Input: file_info - ptr to PaneInfo struct for file pane
|        Output: 
|    Written By: Mark Young & Danielle Argiro
|          Date: May 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_o(
     File_file *file_info)
{
	kobject object, out;

	if (file_info->o == NULL)
        {
            kerror(NULL, "file_out_file", 
		  "You must provide a name for the output file!");
            kinfo(KHOSTILE, "Wasn't that *completely* clear already?");
            return;
        }

	if (file_info->format_label == NULL)
	{
	    kerror(NULL, "file_out_file",
                  "Please select a format for the output file.");
            kinfo(KHOSTILE, "What, I'm supposed to read your mind?");
            return;
	}

	/*
	 *  open an output object for writing
	 */
	if ((out = kpds_open_object(file_info->o, KOBJ_WRITE)) == NULL)
	   return;

	/*
	 *  set output file format
	 */
	kpds_set_attribute(out, KPDS_FORMAT, file_info->format_label);

	/*
	 *  get the data object associated with the image being displayed
	 */
	xvw_get_attribute(image, XVW_IMAGE_IMAGEOBJ, &object);

	/*
	 *  copy the attributes & the data of the displayed image
         *  to the output image
	 */
	kpds_copy_value_attr(object, out);
	kpds_copy_map_attr(object, out);
	kpds_copy_value_data(object, out, FALSE);
	kpds_copy_map_data(object, out, FALSE);
	kcolor_copy_attributes(object, out, KCOLOR_COLORSPACE, 
			      KCOLOR_HAS_ALPHA, NULL);

	/*
	 *  that's all... close the output object
	 */
	kpds_close_object(out);

	kinfo(KSTANDARD, "Done writing %s output file to %s",
	      file_info->format_label, file_info->o);
}

/*-----------------------------------------------------------
| 
|  Routine Name: file_d
| 
|       Purpose: Called when output selection d is used;
|                Does a screen dump of the displayed image to
|                the specified output file.
| 
|         Input: file_info - ptr to PaneInfo struct for file pane
|        Output: 
|    Written By: Mark Young & Danielle Argiro
|          Date: May 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_d(
     File_file *file_info)
{
	kobject out;


	if (file_info->d == NULL)
        {
            kerror(NULL, "file_screen_file",
                  "You must provide a name for the screen dump!");
            kinfo(KHOSTILE, "What did you expect me to do, read your mind?");
            return;
        }

	/*
	 * open output data object for writing
	 */
	if ((out = kpds_open_object(file_info->d,KOBJ_WRITE)) == NULL)
	   return;

	/*
	 *  use xvw_getimage() to get the screen dump from the displayed
         *  image, and write it to the output object
	 */
	xvw_getimage(image, FALSE, FALSE, out);

	/*
	 *  that's all... close the output object
 	 */
	kpds_close_object(out);

	kinfo(KSTANDARD, "Done writing %s output file to %s",
	      file_info->format_label, file_info->d);
}

/*-----------------------------------------------------------
| 
|  Routine Name: file_out_cmap
| 
|       Purpose: Do routine which is called when
|                  output selection out_cmap is used
| 
|         Input: file_info - ptr to PaneInfo struct for file pane
| 
|        Output: None
|    Written By: 
|          Date: Nov 15, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_out_cmap(
     File_file *file_info)
{
	if (file_info->out_cmap == NULL)
	{
	    kerror(NULL, "file_out_cmap", "You must provide a filename");
	    kinfo(KHOSTILE, "Idiot!");
	    return;
	}
	xvw_set_attribute(image, XVW_COLOR_SAVEMAP, file_info->out_cmap);
}


