 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane capture
   >>>> 
   >>>>  Private: 
   >>>> 	capture_o
   >>>> 	capture_capture
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"
static int capture_image PROTO((kobject, options_capture *));


/*-----------------------------------------------------------
| 
|  Routine Name: capture_o
| 
|       Purpose: Do routine which is called when
|                  output selection o is used
| 
|         Input: capture_info - ptr to PaneInfo struct for capture pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 04, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void capture_o(
     options_capture *capture_info)
{
	kobject out;

        if (capture_info->o == NULL)
        {
            kerror(NULL, "file_out_file",
                  "You must provide a name for the output file!");
            kinfo(KHOSTILE, "Hittin the sauce lately?");
            return;
        }

        /*
         *  open an output object for writing
         */
        if ((out = kpds_open_object(capture_info->o, KOBJ_WRITE)) == NULL)
           return;

	if (!(capture_image(out, capture_info)))
	    return;

	current_image = out;
	edimg_input_newimage();

        /*
         *  that's all... close the output object
         */
        kpds_close_object(out);
}


/*-----------------------------------------------------------
| 
|  Routine Name: capture_capture
| 
|       Purpose: Do routine which is called when
|                  pane action button capture is used
| 
|         Input: capture_info - ptr to PaneInfo struct for capture pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 04, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void capture_capture(
     options_capture *capture_info)
{
	char     *filename;
        kobject  tmp;

        /*
         * open output object
         */
	tmp = kpds_create_object();
        if (tmp == NULL)
        {
           kerror(NULL, "capture_capture",
                  "Failed to create temporary output object");
           return;
        }

	if (!(capture_image(tmp, capture_info)))
	    return;

	current_image = tmp;
	edimg_input_newimage();
}

static int capture_image(
    kobject         image,
    options_capture *capture_info)
{
	char     *format = gui_info->File->file->format_label;
        xvobject object = NULL;
        int      rubberband = FALSE;
 
        if (!kpds_set_attribute(image, KPDS_FORMAT, format))
        {
           kerror(NULL, "capture_capture",
                  "Unable to set format (%s) on destination object", format);
           kfree(format);
           return(FALSE);
        }

	if (capture_info->win)
        {
           /*
            * Get the entire window rather than a portion or subimage of one.
            */
           kinfo(KVERBOSE, "Please click on the window to be captured.");
        }

        /*
         *  Get the object depending on whether they specified the name of
         *  window or the entire screen.  This will be passed to xvw_getimage,
         *  which will do the actual work of capturing the window's image.
         */
        if (capture_info->screen == TRUE)
           object = xvw_getobject(NULL, xvw_rootwindow(NULL), NULL);
        else
           object = xvw_getobject(NULL, NONE, NULL);

	/*
         *  rubberbanding a portion of the screen or the specified window
         */
        if (!capture_info->all)
        {
           /*
            * Get a portion or subimage of the window/screen rather than
            * entire one.
            */
           kinfo(KVERBOSE,"Please rubberband the portion of the screen to be captured\n\n");
           rubberband = TRUE;
        }


        /*
         *  Now that we have opened the output data object, call xvw_getimage
         *  to do the actual work of getting the screen dump.  We pass in
         *  object for the xvobject (the first parameter), since this will
         *  be the object in which we will be getting the image for.
         */
        if (!xvw_getimage(object, rubberband, capture_info->decor, image))
        {
           kpds_close_object(image);
           return(FALSE);
        }

	/*
	 *  destroy the GenericWindow object that was created using
	 *  xvw_getobject()
	 */
	if (object != NULL)
	    xvw_destroy(xvw_toplevel(object));

	return(TRUE);
}


