 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane files
   >>>> 
   >>>>  Private: 
   >>>> 	input_newimage
   >>>> 	input_basename
   >>>> 	file_i
   >>>> 	file_b
   >>>> 	file_c
   >>>> 	file_cmap
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"

/*-----------------------------------------------------------
|
|  Routine Name: input_newimage
|
|       Purpose: Displays a new image; updates all of the zoom,
|                position, printpixel, printmapval, LUT, pseudocolor,
|                and thresholding displays to reflect the new image data.
|
|         Input: filename - ptr to PaneInfo struct for file pane
|        Output:
|    Written By: Mark Young & Danielle Argiro
|          Date: May 26, 1994
| Modifications:
|
------------------------------------------------------------*/
void input_newimage(
     char *filename)
{
        /*
         *  get the data object associated w/ the file just specified
         */
        if ((current_image = kpds_open_object(filename, KOBJ_READ)) == NULL)
        {
           /*
            *  print an error indicating that we failed to open the object
            */
           kerror(NULL, "input_newimage",
                  "Unable to open specified data file '%s'", filename);
	   kinfo(KHOSTILE, "idiot.");
           return;
        }

        if (numimages == 0)
           init_colormap_display(current_image);

        /*
         *  go ahead and add the object to our image list
         */
        images = (kobject *) karray_add((char **) images, current_image,
                                        numimages++);

        /*
         *  set all animate displays to have their objects associated
         *  with the data object associated with the file just read in,
         *  so that we are animating, etc all on the same info.  (currently
	 *  this is only
         */
	xvw_set_attribute(animate, XVW_IMAGE_IMAGEOBJ, current_image);
	xvw_set_attribute(panicon, XVW_IMAGE_IMAGEOBJ, current_image);
        update_animate_list(numimages-1);

	/*
	 *  set image to have the normalization type, normalization method
	 *  specified on Display pane
	 */
	xvw_set_attribute(animate, XVW_COLOR_NORM_TYPE,
                          gui_info->options->display->norm_type);
	xvw_set_attribute(animate, XVW_COLOR_NORM_METHOD,
                          gui_info->options->display->norm_method_val);
}

/*-----------------------------------------------------------
|
|  Routine Name: input_newbasename
|
|       Purpose: Displays a new sequence; updates all of the auxillary
|                displays to reflect the new sequence.
|
|         Input: name - path to the base name of the sequence to animated
|        Output:
|    Written By: Mark Young
|          Date: Jan 23, 1995
| Modifications:
|
------------------------------------------------------------*/
void input_newbasename(
     char *name)
{
	char	**file;
	int	i, cnt, num, status;
	kobject *objects, image, tmpobj;


	if ((file = karray_dirlist(name, NULL, NULL, KPATH | KFILE,
			TRUE, &num)) == NULL)
	{
	   kerror(NULL,"file_b","No files found using the base name of '%s'.",
			name);
           kinfo(KHOSTILE, "think!");
	   return;
	}

	objects = (kobject *) kcalloc((unsigned) num, sizeof(kobject));
	for (i = cnt = 0; i < num; i++)
	{
	   if ((tmpobj = kpds_open_input_object(file[i])) == NULL)
	   {
	      kerror(NULL, "file_b", "Failed to open input object '%s'.",
		  file[i]);
	      kinfo(KHOSTILE, "sorry, charlie!");
	   }
	   else objects[cnt++] = tmpobj;
	}
	karray_free(file, num, NULL);

	if ((image = kpds_create_object()) == NULL)
	{
	   kerror(NULL, "file_b", "kpds_create_object() failed to create a \
temporary output object in which to build an output animation sequence.");
           kinfo(KHOSTILE, "But it's probably YOUR fault");
	   return;
	}

	if ((status = kapu_append(objects, cnt, FALSE, FALSE, FALSE, TRUE,
			FALSE, KAPU_USE_COMMON_MAP, image)) == FALSE)
	{
	   kerror(NULL, "file_b", "kapu_append() failed to append basename \
images together in order to create an output animation sequence");
           kinfo(KHOSTILE, "But it's probably YOUR fault");
	}

	/*
	 *  Close all the input objects and free the objects array.
	 */
	for (i = 0; i < cnt; i++)
	    kpds_close_object(objects[i]);
	kfree(objects);

	if (status == TRUE)
	{
	   current_image = image;
           if (numimages == 0)
              init_colormap_display(current_image);
 
           /*
            *  go ahead and add the object to our image list
            */
           images = (kobject *) karray_add((char **) images, current_image,
                                        numimages++);
 
           /*
            *  set all animate displays to have their objects associated
            *  with the data object associated with the file just read in,
            *  so that we are animating, etc all on the same info.  (currently
            *  this is only
            */
           xvw_set_attribute(animate, XVW_IMAGE_IMAGEOBJ, current_image);
           xvw_set_attribute(panicon, XVW_IMAGE_IMAGEOBJ, current_image);
           update_animate_list(numimages-1);
	}
}

/*-----------------------------------------------------------
| 
|  Routine Name: file_i
| 
|       Purpose: Do routine which is called when
|                  input selection i is used
| 
|         Input: file_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 02, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_i(
     File_file *file_info)
{
	if (file_info->i == NULL)
        {
            kerror(NULL, "file_i", "You must provide a filename");
	    kinfo(KHOSTILE, "doofus");
            return;
        }
        input_newimage(file_info->i);
}


/*-----------------------------------------------------------
| 
|  Routine Name: file_b
| 
|       Purpose: Do routine which is called when
|                  string selection b is used
| 
|         Input: file_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 02, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_b(
     File_file *file_info)
{
	if (file_info->b == NULL)
	{
	    kerror(NULL, "file_b", "You must provide a basename");
	    kinfo(KHOSTILE, "use yer HEAD");
	    return;
	}
	input_newbasename(file_info->b);
}


/*-----------------------------------------------------------
| 
|  Routine Name: file_c
| 
|       Purpose: Do routine which is called when
|                  input selection c is used
| 
|         Input: file_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 02, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_c(
     File_file *file_info)
{
	/* note: allow filename of NULL to clear out clip mask */
        xvw_set_attribute(animate, XVW_IMAGE_CLIPFILE, file_info->c);
}

/*-----------------------------------------------------------
| 
|  Routine Name: file_cmap
| 
|       Purpose: Do routine which is called when
|                  input selection cmap is used
| 
|         Input: file_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: 
|          Date: Aug 29, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_cmap(
     File_file *file_info)
{
        if (file_info->cmap == NULL)
        {
            kerror(NULL, "file_cmap", "You must provide a filename");
            kinfo(KHOSTILE, "Deer Xing");
            return;
        }
        xvw_set_attribute(animate, XVW_COLOR_COLORFILE, file_info->cmap);
}


/*-----------------------------------------------------------
| 
|  Routine Name: file_o
| 
|       Purpose: Do routine which is called when
|                  output selection o is used
| 
|         Input: file_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 18, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void file_o(
     File_file *file_info)
{
        kobject object, out;

        if (file_info->o == NULL)
        {
            kerror(NULL, "file_out_file",
                  "You must provide a name for the output file!");
            kinfo(KHOSTILE, "Wasn't that *completely* clear already?");
            return;
        }

        /*
         *  open an output object for writing
         */
        if ((out = kpds_open_object(file_info->o, KOBJ_WRITE)) == NULL)
           return;

        /*
         *  get the data object associated with the image being displayed
         */
        xvw_get_attribute(animate, XVW_IMAGE_IMAGEOBJ, &object);

        /*
         *  copy the attributes & the data of the displayed image
         *  to the output image
         */
        kpds_copy_value_attr(object, out);
        kpds_copy_map_attr(object, out);
        kpds_copy_value_data(object, out, FALSE);
        kpds_copy_map_data(object, out, FALSE);

        /*
         *  that's all... close the output object
         */
        kpds_close_object(out);

        kinfo(KSTANDARD, "Done writing output file to %s", file_info->o);

}


