 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane attributes
   >>>> 
   >>>>  Private: 
   >>>> 	attributes_control
   >>>> 	attributes_show_framenum
   >>>> 	attributes_speed
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"

/*-----------------------------------------------------------
| 
|  Routine Name: attributes_control
| 
|       Purpose: Do routine which is called when
|                  toggle selection control is used
| 
|         Input: attributes_info - ptr to PaneInfo struct for attributes pane
| 
|        Output:
|    Written By: Mark Young
|          Date: Aug 02, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void attributes_control(
     options_attributes *attributes_info)
{
        xvw_set_attribute(animate, XVW_ANIMATE_CONTROL,
                	  attributes_info->control_val);
}


/*-----------------------------------------------------------
| 
|  Routine Name: attributes_show_framenum
| 
|       Purpose: Do routine which is called when
|                  logical selection show_frame is used
| 
|         Input: attributes_info - ptr to PaneInfo struct for attributes pane
| 
|        Output:
|    Written By: Mark Young
|          Date: Aug 02, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void attributes_show_framenum(
     options_attributes *attributes_info)
{
	if (attributes_info->show_framenum)
	{
	   xvw_insert_callback(animate, XVW_ANIMATE_CALLBACK, FALSE,
			       update_framenum, (kaddr) framenum);
	}
	else
	{
	   xvw_remove_callback(animate, XVW_ANIMATE_CALLBACK, 
			       update_framenum, (kaddr) framenum);
           xvw_set_attribute(framenum, XVW_LABEL, " ");
	}
}

/*-----------------------------------------------------------
| 
|  Routine Name: attributes_speed
| 
|       Purpose: Do routine which is called when
|                  float selection speed is used
| 
|         Input: attributes_info - ptr to PaneInfo struct for attributes pane
| 
|        Output:
|    Written By: Mark Young
|          Date: Aug 02, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void attributes_speed(
     options_attributes *attributes_info)
{
	xvw_set_attribute(animate, XVW_ANIMATE_UPDATETIME,
        	          attributes_info->speed);
}

/*-----------------------------------------------------------
| 
|  Routine Name: attributes_elements
| 
|       Purpose: Do routine which is called when
|                  flag selection elements is used
| 
|         Input: attributes_info - ptr to PaneInfo struct for attributes pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 18, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void attributes_elements(
     options_attributes *attributes_info)
{
	int dimensions;

	xvw_get_attribute(animate, XVW_IMAGE_BAND_DIMENSIONS, &dimensions);
	if (attributes_info->elements == FALSE)
	   dimensions &= ~KIMAGE_ELEMENTS;
	else
	   dimensions |= KIMAGE_ELEMENTS;
	xvw_set_attribute(animate, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
	update_band_list();
}


/*-----------------------------------------------------------
| 
|  Routine Name: attributes_depth
| 
|       Purpose: Do routine which is called when
|                  flag selection depth is used
| 
|         Input: attributes_info - ptr to PaneInfo struct for attributes pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 18, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void attributes_depth(
     options_attributes *attributes_info)
{
	int dimensions;

	xvw_get_attribute(animate, XVW_IMAGE_BAND_DIMENSIONS, &dimensions);
	if (attributes_info->depth == FALSE)
	   dimensions &= ~KIMAGE_DEPTH;
	else
	   dimensions |= KIMAGE_DEPTH;
	xvw_set_attribute(animate, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
	update_band_list();
}


/*-----------------------------------------------------------
| 
|  Routine Name: attributes_time
| 
|       Purpose: Do routine which is called when
|                  flag selection time is used
| 
|         Input: attributes_info - ptr to PaneInfo struct for attributes pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 18, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void attributes_time(
     options_attributes *attributes_info)
{
	int dimensions;

	xvw_get_attribute(animate, XVW_IMAGE_BAND_DIMENSIONS, &dimensions);
	if (attributes_info->time == FALSE)
	   dimensions &= ~KIMAGE_TIME;
	else
	   dimensions |= KIMAGE_TIME;
	xvw_set_attribute(animate, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
	update_band_list();
}
