 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kcolorspace
   >>>> 
   >>>>    Written By: Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kcolorspace_h_
#define _kcolorspace_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <envision.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$ENVISION/objects/kroutine/kcolorspace/uis/kcolorspace.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  First Input data object (required infile)
 */
char	*i_file;	/* First Input data object FILENAME */
int	 i_flag;	/* First Input data object FLAG */

/*
 * Type of colorspace to be applied to the input image (Required flag toggle)
 *	1 (Greyscale)
 *	2 (RGB Colorspace)
 *	3 (CMY Colorspace)
 *	4 (YIQ Colorspace)
 *	5 (HSV Colorspace)
 *	6 (HLS Colorspace)
 *	7 (IHS Colorspace)
 *	8 (XYZ Colorspace)
 *	9 (UVW Colorspace)
 *	10 (UCSUVW Colorspace)
 *	11 (UCSSOW Colorspace)
 *	12 (UCSLab Colorspace)
 *	13 (UCSLuv Colorspace)
 *	14 (User Defined Colorspace),
 */
int	 type_toggle;		/* Type of colorspace to be applied to the input image FLAG TOGGLE */
int	 type_flag;		/* Type of colorspace to be applied to the input image FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kcolorspace_get_args PROTO((kform *));
void kcolorspace_usage_additions PROTO((void));
void kcolorspace_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
