#include <xvinclude.h>

/*
 * This simple program plots the data contained in 
 * a VIFF file, in red on a black background
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject plot;
	char *filename = "image:featheye";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
	   kerror(NULL, "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
        }

        /*
         * create the plot object; set the file that contains the data
         * for the plot, and set the foreground color.
         */
	plot = xvw_create_plot2d(NULL, "plot");
	xvw_set_attributes(plot, 
			   XVW_PLOT2D_PLOTFILE,  "image:featheye",
			   XVW_FOREGROUND_COLOR, "red",
		           NULL);

	/* want the background to be black */
	xvw_set_attribute(xvw_parent(plot), XVW_BACKGROUND_COLOR, "black");

	/* display and run */
	xvf_run_form();
}
