#include <xvinclude.h>

/*
 * This simple program creates an array of data points describing
 * a sin curve & plots the points in yellow on a black background
 */

#define POINTNUM 512
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject plot;
	Coord    curve[POINTNUM];
	int      i, degrees;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
	   kerror(NULL, "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
        }

	/* 
	 * Generate the Coord array of points describing 
         * the sin curve to be plotted 
         */
	for (i = 0, degrees = 720; i < POINTNUM; i++, degrees++)
	{
	   curve[i].x = i;
	   curve[i].y = sin((double) kdegrees_radians(degrees));
	}

        /*
         * create the plot object; set the "curve" array to specify
	 * the points to be plotted, give the number of points (mandatory!)
	 * and set the foreground color to yellow
         */
	plot = xvw_create_plot2d(NULL, "plot");
	xvw_set_attributes(plot,
		     XVW_PLOT2D_POINTS,     curve,
		     XVW_PLOT2D_PLOTSIZE,   POINTNUM,
		     XVW_PLOT2D_PLOTTYPE,   KPLOT2D_LINEPLOT,
		     XVW_FOREGROUND_COLOR, "yellow",
		     NULL);

	/* the manager parent backplane created by default should be black */
	xvw_set_attribute(xvw_parent(plot), XVW_BACKGROUND_COLOR, "black");

	/* display & run */
	xvf_run_form();
}
