#include <xvinclude.h>

/* 
 * This program puts up an image and makes a screen dump of it.
 * The screen dump file will be called, "out.viff"
 */
void screendump_cb PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject parent, image, outputfile;
	char *filename = "image:mandril";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* Initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_NONE))
	{
	   kerror("test", "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* use filename from cmd line if provided */
	if (argc > 1)
	   filename = argv[1];

	/* create backplane for image and output file object */
	parent = xvw_create_manager(NULL, "parent");

	/* Display the image  */
	image = xvw_create_image(parent, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, filename);

	outputfile = xvw_create_outputfile(parent, "outputfile");
	xvw_set_attributes(outputfile, 
			   XVW_BELOW,               image,
			   XVW_LEFT_OF,             NULL,
			   XVW_RIGHT_OF,            NULL,
			   XVW_OUTPUTFILE_FILENAME, "out.viff",
			   XVW_OUTPUTFILE_LABEL,    "screendump filename",
			   XVW_CHAR_WIDTH,          55.0,
			   NULL);
		
	xvw_add_callback(outputfile, XVW_OUTPUTFILE_CALLBACK, 
                         screendump_cb, image);

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}

void screendump_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	char     *filename;
	xvobject image = (xvobject) client_data;
	kobject  output_data_object;

	/* get the desired filename */
	xvw_get_attribute(object, XVW_OUTPUTFILE_FILENAME, &filename);

	/* open the output object */
	output_data_object = kpds_open_object(filename,KOBJ_WRITE);
	if (output_data_object == NULL)
           return;
	
	/* get screen dump from displayed image & write it to output object */
        xvw_getimage(image, FALSE, FALSE, output_data_object);

	/* close the output object */
        kpds_close_object(output_data_object);

	/* let the user know */
        kinfo(KSTANDARD, "Done writing %s output file", filename);
}
   

