#include <xvinclude.h>

/* 
 *  This simple introductory program creates a window with an image object; the
 *  image displayed is the mandril image, which is specified using the keyword
 *  syntax rather than the absolute path to the image.  
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject image;
	char *filename = "image:mandril";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* Initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_NONE)) 
	{
	   kerror("test", "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* use filename from cmd line if provided */
	if (argc > 1)
	   filename = argv[1];

	/*
	 *  Create the image display.  Since the parent is NULL, a toplevel 
	 *  window will be created automatically, and the image object placed 
         *  inside.  The xvw_set_attribute() call is used to specify the image 
         *  file to be displayed.
	 */
	image = xvw_create_image(NULL, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, filename);

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
