#include <xvinclude.h>

/*
 * This example creates a window with a timer object.  A timer object
 * uses the system clock to emulate a stop-watch type capability.
 */

void main(int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent;
        xvobject timer;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

        /*
         *  create a manager backplane. make it selectable so the user
         *  can put it in edit mode & move the timer object around.
         */
        parent = xvw_create_manager(NULL, "parent");
        xvw_set_attributes(parent,
                           XVW_WIDTH,  100,
                           XVW_HEIGHT, 100,
			   NULL);

        /*
         *  create the timer object.  specify placement in
         *  world coordinates, string formatting specifications, 
         *  and make it menuable so user has access to its
         *  internal menuform.
         */
        timer = xvw_create_timer(parent, "timer");
        xvw_set_attributes(timer,
                XVW_STRING_XPLACEMENT,  0.5,
                XVW_STRING_YPLACEMENT,  0.5,
                XVW_BELOW,              NULL,
                XVW_ABOVE,              NULL,
                XVW_LEFT_OF,            NULL,
                XVW_RIGHT_OF,           NULL,
	        NULL);

	/*
         *  activate the internal menuform 
         */
        xvw_activate_menu(timer);

	/* display & run the program */
        xvf_run_form();
}
