 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                Utility Routines                       <<<<
   >>>>                                                       <<<<
   >>>>  Private:    xvrun_print_cmd                          <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "xvrun.h"

/*-----------------------------------------------------------
| 
|  Routine Name: xvrun_print_cmd
| 
|       Purpose: Installed as an extra call on the Routine
|                button of the GUI being displayed, this
|                routine prints the command being executed
|                to the tty before the command is executed;
|                for example, if xvrun is being used to display
|                the GUI for editimage, it might print:
|                % editimage -i image:ball
| 
|         Input: client_data - passes in selection associated w/ routine button.
|        Output: None
|    Written By: Danielle Argiro
|          Date: March 28, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void xvrun_print_cmd(
    kaddr *client_data)
{
	kselection *selection = (kselection *) client_data;
	char       *command;

	/* update form tree according to changes made to GUI */
        (void) xvf_collect_check_data(selection->back_form);

	/* form the command line */
        command = kvf_form_to_cmd(selection->back_form,
                                  selection->back_subform, NULL, TRUE);
        if (command == NULL)
        {
            kerror(NULL, "xvrun_print_cmd", "Unable to build command line");
            return;
        }
	kfprintf(kstderr, "%s\n", command);
}
