 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_preview
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_show
   >>>> 	_xvf_get_view
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "preview.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_preview
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name preview -l 3
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_preview(
     gui_info_struct *forminfo)
{
	ksubform   *subform;
	if (forminfo->show_struct != NULL)
	{
	    subform = forminfo->show_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->show_selected));
	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_show
| 
|       Purpose: Extracts information from show subform
| 
|         Input: subforminfo - pointer to preview_show structure
| 
|        Output: none
|    Written By: conductor -name preview -l 3
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_show(
     preview_show *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->view_struct != NULL)
	{
	    pane = subforminfo->view_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->view_selected));
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_view
| 
|       Purpose: Extracts information from view pane
| 
|         Input: paneinfo - pointer to show_view structure
| 
|        Output: none
|    Written By: conductor -name preview -l 3
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_view(
     show_view *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'preview->show->view' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->i_struct != NULL)
	{
	    selection = paneinfo->i_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->i != NULL) kfree(paneinfo->i);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->i));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->i_selected));
	    }
	}

	if (paneinfo->revisit_struct != NULL)
	{
	    selection = paneinfo->revisit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->revisit));

	}

	if (paneinfo->edit_struct != NULL)
	{
	    selection = paneinfo->edit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->edit));

	}

	if (paneinfo->print_struct != NULL)
	{
	    selection = paneinfo->print_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->print != NULL) kfree(paneinfo->print);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->print));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->print_selected));
	    }
	}

}


