 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'preview'
   >>>> 
   >>>>  Private: 
   >>>> 	run_preview
   >>>> 	run_show
   >>>> 	run_view
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "preview.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_preview
| 
|       Purpose: Main GUI Driver for preview
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname preview -l 3
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_preview(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_preview(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_preview(master_info);
	    return;
	}

	/*
	 * action came from the 'show' subform
	 */
	if (master_info->show_selected)
	    run_show(master_info->show);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_show
| 
|       Purpose: GUI Driver for subform 'show'
| 
|         Input: form      - pointer to the form tree
|                show_info - pointer to preview_show struct
| 
|        Output: None
|    Written By: conductor -program_name preview -l 3
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_show(
     preview_show *show_info)
{

	_xvf_get_show(show_info);

	/*
	 * action came from the 'view' pane
	 */
	if (show_info->view_selected)
	    run_view(show_info->view);


}   /* end run_show */



/*-----------------------------------------------------------
| 
|  Routine Name: run_view
| 
|       Purpose: GUI Driver for pane 'view'
| 
|         Input: form - pointer to the form tree
|                view_info - pointer to show_view struct
| 
|        Output: None
|    Written By: conductor -program_name preview -l 3
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_view(
     show_view *view_info)

{

	_xvf_get_view(view_info);

	/*
	 * user selected 'live' input file selection 'i'
	 */
	if (view_info->i_selected)
	{
	    view_i(view_info);
	    view_info->i_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'revisit'
	 */
	else if (view_info->revisit)
	{
	    view_revisit(view_info);
	    view_info->revisit = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'edit'
	 */
	else if (view_info->edit)
	{
	    view_edit(view_info);
	    view_info->edit = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'print'
	 */
	else if (view_info->print_selected)
	{
	    view_print(view_info);
	    view_info->print_selected = FALSE;
	}


}


