 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>> Utility routines for finding displayed GUI control panels
   >>>>
   >>>>  Private:
   >>>>         find_displayed_pane
   >>>>         find_displayed_control
   >>>>         find_displayed_subform
   >>>>
   >>>>   Static:
   >>>>         find_displayed_guidepane
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "guise.h"

static kcontrol *find_displayed_guidepane PROTO((kform *));


/*-----------------------------------------------------------
|
|  Routine Name: find_displayed_pane
|
|       Purpose: Finds the displayed pane of the currently 
|                displayed form.
|         Input: form - the currently displayed form
|        Output: None
|       Returns: Pointer to the currently displayed form.
|    Written By: Danielle Argiro
|          Date: Wed Dec 18, 1992 
| Modifications: 
|
------------------------------------------------------------*/
kcontrol *find_displayed_pane(
   kform *form)
{
	ksubform *subform;
	kguide   *guide;
	
	if (form == NULL) return(NULL);

	if (form->master != NULL)
            subform = form->master->subform_list;
	else subform = form->subform;

	while (subform != NULL)
        {
	    if (subform->selected)
	    {
                if (subform->guidepane != NULL)
                    guide = subform->guidepane->guide_list;
                else guide = subform->guide;

                while (guide != NULL)
                {
		    if (guide->selected)
			return(guide->pane);
                    guide = guide->next;
                }
	    }
            subform = subform->next;
        }
	return(NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: find_displayed_guidepane
|
|       Purpose: Finds the displayed guidepane of the currently
|                displayed form.
|         Input: form - the currently displayed form
|        Output: None
|       Returns: Pointer to the currently displayed form.
|    Written By: Danielle Argiro
|          Date: Aug 23, 1993
| Modifications:
|
------------------------------------------------------------*/
static kcontrol *find_displayed_guidepane(
   kform *form)
{
	ksubform *subform;

	if (form == NULL) return(NULL);

        if (form->master != NULL)
            subform = form->master->subform_list;
        else subform = form->subform;

	while (subform != NULL)
	{
	    if ((subform->guidepane != NULL) && (subform->selected))
	        return(subform->guidepane);
	    subform = subform->next;
	}

	return(NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: find_displayed_control
|
|       Purpose: Determines the pane, guidepane, or master
|                of the currently displayed form to which we
|                are supposed to be adding selections.
|
|         Input: routine_name - name of calling routine
|                item_name    - name of GUI item being created
|                control_type - KPANE, KGUIDEPANE, or KMASTER: 
|                               the control type we are looking for, in case
|                               there is more than one displayed.
|
|        Output: subform      - sets the subform to which we are adding sel.
|                guide        - sets the guide to which we are adding sel.
|                pane         - sets the pane to which we are adding sel.
|
|       Returns: Pointer to the currently displayed form.
|    Written By: Danielle Argiro
|          Date: Aug 23, 1993 
| Modifications: 
|
------------------------------------------------------------*/
kcontrol *find_displayed_control(
    char     *routine_name,
    char     *item_name,
    int      control_type,
    ksubform **subform,
    kguide   **guide,
    kcontrol **pane)
{
	kcontrol *control = NULL;
	ksubform *tmp_subform;
	kguide   *tmp_guide;

	*subform = NULL;
	*guide   = NULL;
	*pane    = NULL;

	if (control_type == KPANE)
	{
            control = find_displayed_pane(display_form);
	    if (control == NULL)
	    {
		if (item_name != NULL)
                    kerror(NULL, routine_name,
                       "No displayed pane to add %s to.", item_name);
	        return(NULL);
	    }
	    *pane = control;
	    *guide = control->back_guide;
	    *subform = control->back_subform;
	}
        else if (control_type == KGUIDEPANE)
	{
            control = find_displayed_guidepane(display_form);
	    if (control == NULL)
	    {
		if (item_name != NULL)
                    kerror(NULL, routine_name,
                       "Cannot add %s selection to guide pane.  Either there is no displayed subform, or the displayed subform has no guidepane.", item_name);
	  	return(NULL);
	    }
	    *subform = control->back_subform;
	    tmp_subform = control->back_subform;
	    
	    if (tmp_subform != NULL) 
	    {
		if (tmp_subform->guide != NULL)
		{
		   *guide = tmp_subform->guide;
		   *pane = tmp_subform->guide->pane;
		}
		else
		{
		    tmp_guide = tmp_subform->guidepane->guide_list;
		    while ((tmp_guide != NULL) && (!tmp_guide->selected))
                	tmp_guide = tmp_guide->next;
		    *guide = tmp_guide;
		    if (tmp_guide != NULL)
		        *pane = tmp_guide->pane;
		}
	    }

	}
        else if (control_type == KMASTER)
	{
            control = display_form->master;
	    if (control == NULL)
	    {
		if (item_name != NULL)
                    kerror(NULL, routine_name,
                       "Cannot add %s selection to master form.  Either there is no master on the displayed form, or there is no displayed form.", item_name);
		return(NULL);
	    }
	    tmp_subform = display_form->master->subform_list;
	    while ((tmp_subform != NULL) && (!tmp_subform->selected)) 
		tmp_subform = tmp_subform->next;
	    *subform = tmp_subform;

	    if (tmp_subform != NULL) 
	    {
		if (tmp_subform->guide != NULL)
		{
		   *guide = tmp_subform->guide;
		   *pane = tmp_subform->guide->pane;
		}
		else
		{
		    tmp_guide = tmp_subform->guidepane->guide_list;
		    while ((tmp_guide != NULL) && (!tmp_guide->selected))
                	tmp_guide = tmp_guide->next;
		    *guide = tmp_guide;
		    if (tmp_guide != NULL)
		        *pane = tmp_guide->pane;
		}
	    }
	}
	else
	{
	    errno = KINTERNAL;
	    kerror(NULL, "find_displayed_control",
		   "bogus value passed in for control_type");
	}

	return(control);
}


/*-----------------------------------------------------------
|
|  Routine Name: find_displayed_subform
|
|       Purpose: Finds the displayed subform of the currently
|                displayed form.
|         Input: form - the currently displayed form
|        Output: None
|       Returns: Pointer to the currently displayed subform.
|    Written By: Danielle Argiro
|          Date: Aug 25, 1992
| Modifications:
|
------------------------------------------------------------*/
ksubform *find_displayed_subform(
   kform *form)
{
        ksubform *subform;

        if (form == NULL) return(NULL);

        if (form->master != NULL)
            subform = form->master->subform_list;
        else subform = form->subform;

        while (subform != NULL)
        {
            if (subform->selected)
		return(subform);

            subform = subform->next;
        }
        return(NULL);
}

