 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for craftsman Form
   >>>> 
   >>>>    Written By: conductor -name craftsman -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 19, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'types' Pane
 */
typedef struct _preferences_types{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          objtypes_val;      /* value of toggle 'objtypes'*/
int          objtypes_num;      /* number of toggle member selected (1-N) */
kform_struct *objtypes_struct;  /* pass to xvf_set_attributes() */
int          objtypes_selected; /* TRUE on <cr> for 'objtypes' */

int          cattype_val;      /* value of toggle 'cattype'*/
int          cattype_num;      /* number of toggle member selected (1-N) */
kform_struct *cattype_struct;  /* pass to xvf_set_attributes() */
int          cattype_selected; /* TRUE on <cr> for 'cattype' */

} preferences_types;

/*
 * Subform Info Struct for 'preferences' Subform
 */
typedef struct _craftsman_preferences {

preferences_types  *types;          /* ptr to Pane Info struct for pane 'types' */
int               types_selected;          /* TRUE if input was from pane 'types' */
kform_struct      *types_struct;          /* pass to xvf_set_attributes() */

}  craftsman_preferences;

/*
 * Pane Info Struct for 'conspane' Pane
 */
typedef struct _console_conspane{

int          clear;          /* TRUE when user clicks on 'clear'*/
kform_struct *clear_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     workspace;          /* address of workspace 'workspace'*/
kform_struct *workspace_struct;  /* pass to xvf_set_attributes() */

} console_conspane;

/*
 * Subform Info Struct for 'console' Subform
 */
typedef struct _craftsman_console {

console_conspane  *conspane;          /* ptr to Pane Info struct for pane 'conspane' */
int              conspane_selected;          /* TRUE if input was from pane 'conspane' */
kform_struct     *conspane_struct;          /* pass to xvf_set_attributes() */

}  craftsman_console;

/*
 * Pane Info Struct for 'mktb' Pane
 */
typedef struct _newtb_mktb{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *tbname;         /* string for 'tbname'*/
kform_struct *tbname_struct;  /* pass to xvf_set_attributes() */

char         *tbpath;         /* string for 'tbpath'*/
kform_struct *tbpath_struct;  /* pass to xvf_set_attributes() */

char         *tbtitle;         /* string for 'tbtitle'*/
kform_struct *tbtitle_struct;  /* pass to xvf_set_attributes() */

char         *name;         /* string for 'name'*/
kform_struct *name_struct;  /* pass to xvf_set_attributes() */

char         *email;         /* string for 'email'*/
kform_struct *email_struct;  /* pass to xvf_set_attributes() */

int          tbstatus_val;      /* value of toggle 'tbstatus'*/
int          tbstatus_num;      /* number of toggle member selected (1-N) */
kform_struct *tbstatus_struct;  /* pass to xvf_set_attributes() */

int          createtb;          /* TRUE when user clicks on 'createtb'*/
kform_struct *createtb_struct;  /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *blank2_struct; /* pass to xvf_set_attributes() */

kform_struct *tbauthor_struct; /* pass to xvf_set_attributes() */

} newtb_mktb;

/*
 * Subform Info Struct for 'newtb' Subform
 */
typedef struct _craftsman_newtb {

newtb_mktb  *mktb;          /* ptr to Pane Info struct for pane 'mktb' */
int        mktb_selected;          /* TRUE if input was from pane 'mktb' */
kform_struct *mktb_struct;          /* pass to xvf_set_attributes() */

}  craftsman_newtb;

/*
 * Pane Info Struct for 'addref' Pane
 */
typedef struct _tbaddref_addref{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *tbname;         /* string for 'tbname'*/
kform_struct *tbname_struct;  /* pass to xvf_set_attributes() */

char         *tbpath;         /* string for 'tbpath'*/
kform_struct *tbpath_struct;  /* pass to xvf_set_attributes() */

int          addit;          /* TRUE when user clicks on 'addit'*/
kform_struct *addit_struct;  /* pass to xvf_set_attributes() */

} tbaddref_addref;

/*
 * Subform Info Struct for 'tbaddref' Subform
 */
typedef struct _craftsman_tbaddref {

tbaddref_addref  *addref;          /* ptr to Pane Info struct for pane 'addref' */
int             addref_selected;          /* TRUE if input was from pane 'addref' */
kform_struct    *addref_struct;          /* pass to xvf_set_attributes() */

}  craftsman_tbaddref;

/*
 * Pane Info Struct for 'strings' Pane
 */
typedef struct _tbattrs_strings{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *tbtitle;         /* string for 'tbtitle'*/
kform_struct *tbtitle_struct;  /* pass to xvf_set_attributes() */

char         *authname;         /* string for 'authname'*/
kform_struct *authname_struct;  /* pass to xvf_set_attributes() */

char         *authemail;         /* string for 'authemail'*/
kform_struct *authemail_struct;  /* pass to xvf_set_attributes() */

int          apply;          /* TRUE when user clicks on 'apply'*/
kform_struct *apply_struct;  /* pass to xvf_set_attributes() */

kform_struct *tbauthor_struct; /* pass to xvf_set_attributes() */

kform_struct *pathlabel_struct; /* pass to xvf_set_attributes() */

kform_struct *tbpath_struct; /* pass to xvf_set_attributes() */

} tbattrs_strings;

/*
 * Pane Info Struct for 'keywords' Pane
 */
typedef struct _tbattrs_keywords{

int          keylist;          /* int value of 'keylist'*/
char         *keylist_label;   /* label representing int value of 'keylist'*/
kform_struct *keylist_struct;  /* pass to xvf_set_attributes() */
int          keylist_selected; /* TRUE on <cr> for 'keylist' */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          delete;          /* TRUE when user clicks on 'delete'*/
kform_struct *delete_struct;  /* pass to xvf_set_attributes() */

char         *addkey;         /* string for 'addkey'*/
kform_struct *addkey_struct;  /* pass to xvf_set_attributes() */
int          addkey_selected; /* TRUE on <cr> for 'addkey' */

char         *chkey;         /* string for 'chkey'*/
kform_struct *chkey_struct;  /* pass to xvf_set_attributes() */
int          chkey_selected; /* TRUE on <cr> for 'chkey' */

} tbattrs_keywords;

/*
 * Pane Info Struct for 'flags' Pane
 */
typedef struct _tbattrs_flags{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          tbstatus_val;      /* value of toggle 'tbstatus'*/
int          tbstatus_num;      /* number of toggle member selected (1-N) */
kform_struct *tbstatus_struct;  /* pass to xvf_set_attributes() */

int          flags_apply;          /* TRUE when user clicks on 'flags_apply'*/
kform_struct *flags_apply_struct;  /* pass to xvf_set_attributes() */

} tbattrs_flags;

/*
 * Pane Info Struct for 'copyright' Pane
 */
typedef struct _tbattrs_copyright{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *short_copyright;         /* string for 'short_copyright'*/
kform_struct *short_copyright_struct;  /* pass to xvf_set_attributes() */

char         *long_copyright;         /* string for 'long_copyright'*/
kform_struct *long_copyright_struct;  /* pass to xvf_set_attributes() */

int          copyright_apply;          /* TRUE when user clicks on 'copyright_apply'*/
kform_struct *copyright_apply_struct;  /* pass to xvf_set_attributes() */

kform_struct *scblank_struct; /* pass to xvf_set_attributes() */

kform_struct *lcblank_struct; /* pass to xvf_set_attributes() */

} tbattrs_copyright;

/*
 * Pane Info Struct for 'files' Pane
 */
typedef struct _tbattrs_files{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          config;          /* TRUE when user clicks on 'config'*/
kform_struct *config_struct;  /* pass to xvf_set_attributes() */

int          tbinclude;          /* TRUE when user clicks on 'tbinclude'*/
kform_struct *tbinclude_struct;  /* pass to xvf_set_attributes() */

int          tbinfo;          /* TRUE when user clicks on 'tbinfo'*/
kform_struct *tbinfo_struct;  /* pass to xvf_set_attributes() */

int          tbaliases;          /* TRUE when user clicks on 'tbaliases'*/
kform_struct *tbaliases_struct;  /* pass to xvf_set_attributes() */

int          tbtodo;          /* TRUE when user clicks on 'tbtodo'*/
kform_struct *tbtodo_struct;  /* pass to xvf_set_attributes() */

int          tbchangelog;          /* TRUE when user clicks on 'tbchangelog'*/
kform_struct *tbchangelog_struct;  /* pass to xvf_set_attributes() */

kform_struct *configblank_struct; /* pass to xvf_set_attributes() */

kform_struct *incblank_struct; /* pass to xvf_set_attributes() */

kform_struct *infoblank_struct; /* pass to xvf_set_attributes() */

kform_struct *aliasblank_struct; /* pass to xvf_set_attributes() */

kform_struct *todoblank_struct; /* pass to xvf_set_attributes() */

kform_struct *changelogblank_struct; /* pass to xvf_set_attributes() */

} tbattrs_files;

/*
 * Subform Info Struct for 'tbattrs' Subform
 */
typedef struct _craftsman_tbattrs {

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

tbattrs_strings  *strings;          /* ptr to Pane Info struct for pane 'strings' */
int             strings_selected;          /* TRUE if input was from pane 'strings' */
kform_struct    *strings_struct;          /* pass to xvf_set_attributes() */

tbattrs_keywords  *keywords;          /* ptr to Pane Info struct for pane 'keywords' */
int              keywords_selected;          /* TRUE if input was from pane 'keywords' */
kform_struct     *keywords_struct;          /* pass to xvf_set_attributes() */

tbattrs_flags  *flags;          /* ptr to Pane Info struct for pane 'flags' */
int           flags_selected;          /* TRUE if input was from pane 'flags' */
kform_struct  *flags_struct;          /* pass to xvf_set_attributes() */

tbattrs_copyright  *copyright;          /* ptr to Pane Info struct for pane 'copyright' */
int               copyright_selected;          /* TRUE if input was from pane 'copyright' */
kform_struct      *copyright_struct;          /* pass to xvf_set_attributes() */

tbattrs_files  *files;          /* ptr to Pane Info struct for pane 'files' */
int           files_selected;          /* TRUE if input was from pane 'files' */
kform_struct  *files_struct;          /* pass to xvf_set_attributes() */

}  craftsman_tbattrs;

/*
 * Pane Info Struct for 'kroutine' Pane
 */
typedef struct _template_kroutine{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          incantata_val;      /* value of toggle 'incantata'*/
int          incantata_num;      /* number of toggle member selected (1-N) */
kform_struct *incantata_struct;  /* pass to xvf_set_attributes() */

int          lib_routine_val;      /* value of toggle 'lib_routine'*/
int          lib_routine_num;      /* number of toggle member selected (1-N) */
kform_struct *lib_routine_struct;  /* pass to xvf_set_attributes() */
int          lib_routine_selected; /* TRUE on <cr> for 'lib_routine' */

char         *lib_list;         /* string for 'lib_list'*/
kform_struct *lib_list_struct;  /* pass to xvf_set_attributes() */
int          lib_list_selected; /* TRUE on <cr> for 'lib_list' */

int          create_kroutine;          /* TRUE when user clicks on 'create_kroutine'*/
kform_struct *create_kroutine_struct;  /* pass to xvf_set_attributes() */

} template_kroutine;

/*
 * Pane Info Struct for 'xvroutine' Pane
 */
typedef struct _template_xvroutine{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          incantata_val;      /* value of toggle 'incantata'*/
int          incantata_num;      /* number of toggle member selected (1-N) */
kform_struct *incantata_struct;  /* pass to xvf_set_attributes() */

int          useform_val;      /* value of toggle 'useform'*/
int          useform_num;      /* number of toggle member selected (1-N) */
kform_struct *useform_struct;  /* pass to xvf_set_attributes() */

int          create_xvroutine;          /* TRUE when user clicks on 'create_xvroutine'*/
kform_struct *create_xvroutine_struct;  /* pass to xvf_set_attributes() */

} template_xvroutine;

/*
 * Pane Info Struct for 'library' Pane
 */
typedef struct _template_library{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          create_library;          /* TRUE when user clicks on 'create_library'*/
kform_struct *create_library_struct;  /* pass to xvf_set_attributes() */

} template_library;

/*
 * Pane Info Struct for 'script' Pane
 */
typedef struct _template_script{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          lang_val;      /* value of toggle 'lang'*/
int          lang_num;      /* number of toggle member selected (1-N) */
kform_struct *lang_struct;  /* pass to xvf_set_attributes() */

int          wantpane_val;      /* value of toggle 'wantpane'*/
int          wantpane_num;      /* number of toggle member selected (1-N) */
kform_struct *wantpane_struct;  /* pass to xvf_set_attributes() */

int          incantata_val;      /* value of toggle 'incantata'*/
int          incantata_num;      /* number of toggle member selected (1-N) */
kform_struct *incantata_struct;  /* pass to xvf_set_attributes() */

int          create_script;          /* TRUE when user clicks on 'create_script'*/
kform_struct *create_script_struct;  /* pass to xvf_set_attributes() */

} template_script;

/*
 * Pane Info Struct for 'pane' Pane
 */
typedef struct _template_pane{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          incantata_val;      /* value of toggle 'incantata'*/
int          incantata_num;      /* number of toggle member selected (1-N) */
kform_struct *incantata_struct;  /* pass to xvf_set_attributes() */

int          genexec_val;      /* value of toggle 'genexec'*/
int          genexec_num;      /* number of toggle member selected (1-N) */
kform_struct *genexec_struct;  /* pass to xvf_set_attributes() */

char         *tbname;         /* string for 'tbname'*/
kform_struct *tbname_struct;  /* pass to xvf_set_attributes() */

char         *oname;         /* string for 'oname'*/
kform_struct *oname_struct;  /* pass to xvf_set_attributes() */

char         *args;         /* string for 'args'*/
kform_struct *args_struct;  /* pass to xvf_set_attributes() */

int          create_pane;          /* TRUE when user clicks on 'create_pane'*/
kform_struct *create_pane_struct;  /* pass to xvf_set_attributes() */

kform_struct *assoclabel_struct; /* pass to xvf_set_attributes() */

} template_pane;

/*
 * Subform Info Struct for 'template' Subform
 */
typedef struct _craftsman_template {

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *obj_name;         /* string for 'obj_name'*/
kform_struct *obj_name_struct;  /* pass to xvf_set_attributes() */

char         *bname;         /* string for 'bname'*/
kform_struct *bname_struct;  /* pass to xvf_set_attributes() */

char         *icon_name;         /* string for 'icon_name'*/
kform_struct *icon_name_struct;  /* pass to xvf_set_attributes() */

char         *author;         /* string for 'author'*/
kform_struct *author_struct;  /* pass to xvf_set_attributes() */

char         *email;         /* string for 'email'*/
kform_struct *email_struct;  /* pass to xvf_set_attributes() */

char         *category;         /* string for 'category'*/
kform_struct *category_struct;  /* pass to xvf_set_attributes() */

char         *subcategory;         /* string for 'subcategory'*/
kform_struct *subcategory_struct;  /* pass to xvf_set_attributes() */

char         *description;         /* string for 'description'*/
kform_struct *description_struct;  /* pass to xvf_set_attributes() */

kform_struct *blank2_struct; /* pass to xvf_set_attributes() */

kform_struct *descblank_struct; /* pass to xvf_set_attributes() */

template_kroutine  *kroutine;          /* ptr to Pane Info struct for pane 'kroutine' */
int               kroutine_selected;          /* TRUE if input was from pane 'kroutine' */
kform_struct      *kroutine_struct;          /* pass to xvf_set_attributes() */

template_xvroutine  *xvroutine;          /* ptr to Pane Info struct for pane 'xvroutine' */
int                xvroutine_selected;          /* TRUE if input was from pane 'xvroutine' */
kform_struct       *xvroutine_struct;          /* pass to xvf_set_attributes() */

template_library  *library;          /* ptr to Pane Info struct for pane 'library' */
int              library_selected;          /* TRUE if input was from pane 'library' */
kform_struct     *library_struct;          /* pass to xvf_set_attributes() */

template_script  *script;          /* ptr to Pane Info struct for pane 'script' */
int             script_selected;          /* TRUE if input was from pane 'script' */
kform_struct    *script_struct;          /* pass to xvf_set_attributes() */

template_pane  *pane;          /* ptr to Pane Info struct for pane 'pane' */
int           pane_selected;          /* TRUE if input was from pane 'pane' */
kform_struct  *pane_struct;          /* pass to xvf_set_attributes() */

}  craftsman_template;

/*
 * Pane Info Struct for 'obj_attrs' Pane
 */
typedef struct _obj_attributes_obj_attrs{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *description;         /* string for 'description'*/
kform_struct *description_struct;  /* pass to xvf_set_attributes() */

char         *category;         /* string for 'category'*/
kform_struct *category_struct;  /* pass to xvf_set_attributes() */

char         *subcategory;         /* string for 'subcategory'*/
kform_struct *subcategory_struct;  /* pass to xvf_set_attributes() */

char         *icon_name;         /* string for 'icon_name'*/
kform_struct *icon_name_struct;  /* pass to xvf_set_attributes() */

char         *name;         /* string for 'name'*/
kform_struct *name_struct;  /* pass to xvf_set_attributes() */

char         *email;         /* string for 'email'*/
kform_struct *email_struct;  /* pass to xvf_set_attributes() */

int          install_in_cantata_val;      /* value of toggle 'install_in_cantata'*/
int          install_in_cantata_num;      /* number of toggle member selected (1-N) */
kform_struct *install_in_cantata_struct;  /* pass to xvf_set_attributes() */

int          apply;          /* TRUE when user clicks on 'apply'*/
kform_struct *apply_struct;  /* pass to xvf_set_attributes() */

kform_struct *tblabel_struct; /* pass to xvf_set_attributes() */

kform_struct *onamelabel_struct; /* pass to xvf_set_attributes() */

kform_struct *tb_struct; /* pass to xvf_set_attributes() */

kform_struct *oname_struct; /* pass to xvf_set_attributes() */

kform_struct *authlabel_struct; /* pass to xvf_set_attributes() */

kform_struct *otypelabel_struct; /* pass to xvf_set_attributes() */

kform_struct *otype_struct; /* pass to xvf_set_attributes() */

kform_struct *descblank_struct; /* pass to xvf_set_attributes() */

} obj_attributes_obj_attrs;

/*
 * Pane Info Struct for 'obj_keywords' Pane
 */
typedef struct _obj_attributes_obj_keywords{

int          keylist;          /* int value of 'keylist'*/
char         *keylist_label;   /* label representing int value of 'keylist'*/
kform_struct *keylist_struct;  /* pass to xvf_set_attributes() */
int          keylist_selected; /* TRUE on <cr> for 'keylist' */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          delete;          /* TRUE when user clicks on 'delete'*/
kform_struct *delete_struct;  /* pass to xvf_set_attributes() */

char         *addkey;         /* string for 'addkey'*/
kform_struct *addkey_struct;  /* pass to xvf_set_attributes() */
int          addkey_selected; /* TRUE on <cr> for 'addkey' */

char         *chkey;         /* string for 'chkey'*/
kform_struct *chkey_struct;  /* pass to xvf_set_attributes() */
int          chkey_selected; /* TRUE on <cr> for 'chkey' */

} obj_attributes_obj_keywords;

/*
 * Pane Info Struct for 'paneattrs' Pane
 */
typedef struct _obj_attributes_paneattrs{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *tbname;         /* string for 'tbname'*/
kform_struct *tbname_struct;  /* pass to xvf_set_attributes() */

char         *oname;         /* string for 'oname'*/
kform_struct *oname_struct;  /* pass to xvf_set_attributes() */

char         *args;         /* string for 'args'*/
kform_struct *args_struct;  /* pass to xvf_set_attributes() */

int          genexec_val;      /* value of toggle 'genexec'*/
int          genexec_num;      /* number of toggle member selected (1-N) */
kform_struct *genexec_struct;  /* pass to xvf_set_attributes() */

int          apply;          /* TRUE when user clicks on 'apply'*/
kform_struct *apply_struct;  /* pass to xvf_set_attributes() */

kform_struct *assoclabel_struct; /* pass to xvf_set_attributes() */

} obj_attributes_paneattrs;

/*
 * Subform Info Struct for 'obj_attributes' Subform
 */
typedef struct _craftsman_obj_attributes {

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

obj_attributes_obj_attrs  *obj_attrs;          /* ptr to Pane Info struct for pane 'obj_attrs' */
int                      obj_attrs_selected;          /* TRUE if input was from pane 'obj_attrs' */
kform_struct             *obj_attrs_struct;          /* pass to xvf_set_attributes() */

obj_attributes_obj_keywords  *obj_keywords;          /* ptr to Pane Info struct for pane 'obj_keywords' */
int                         obj_keywords_selected;          /* TRUE if input was from pane 'obj_keywords' */
kform_struct                *obj_keywords_struct;          /* pass to xvf_set_attributes() */

obj_attributes_paneattrs  *paneattrs;          /* ptr to Pane Info struct for pane 'paneattrs' */
int                      paneattrs_selected;          /* TRUE if input was from pane 'paneattrs' */
kform_struct             *paneattrs_struct;          /* pass to xvf_set_attributes() */

}  craftsman_obj_attributes;

/*
 * Pane Info Struct for 'copy' Pane
 */
typedef struct _copyobject_copy{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *desttb;         /* string for 'desttb'*/
kform_struct *desttb_struct;  /* pass to xvf_set_attributes() */

int          docopy;          /* TRUE when user clicks on 'docopy'*/
kform_struct *docopy_struct;  /* pass to xvf_set_attributes() */

kform_struct *tblabel_struct; /* pass to xvf_set_attributes() */

kform_struct *olabel_struct; /* pass to xvf_set_attributes() */

kform_struct *tbname_struct; /* pass to xvf_set_attributes() */

kform_struct *oname_struct; /* pass to xvf_set_attributes() */

} copyobject_copy;

/*
 * Subform Info Struct for 'copyobject' Subform
 */
typedef struct _craftsman_copyobject {

copyobject_copy  *copy;          /* ptr to Pane Info struct for pane 'copy' */
int             copy_selected;          /* TRUE if input was from pane 'copy' */
kform_struct    *copy_struct;          /* pass to xvf_set_attributes() */

}  craftsman_copyobject;

/*
 * Pane Info Struct for 'move' Pane
 */
typedef struct _mvobject_move{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *desttb;         /* string for 'desttb'*/
kform_struct *desttb_struct;  /* pass to xvf_set_attributes() */

int          domove;          /* TRUE when user clicks on 'domove'*/
kform_struct *domove_struct;  /* pass to xvf_set_attributes() */

kform_struct *tblabel_struct; /* pass to xvf_set_attributes() */

kform_struct *olabel_struct; /* pass to xvf_set_attributes() */

kform_struct *tbname_struct; /* pass to xvf_set_attributes() */

kform_struct *oname_struct; /* pass to xvf_set_attributes() */

} mvobject_move;

/*
 * Subform Info Struct for 'mvobject' Subform
 */
typedef struct _craftsman_mvobject {

mvobject_move  *move;          /* ptr to Pane Info struct for pane 'move' */
int           move_selected;          /* TRUE if input was from pane 'move' */
kform_struct  *move_struct;          /* pass to xvf_set_attributes() */

}  craftsman_mvobject;

/*
 * Pane Info Struct for 'rename' Pane
 */
typedef struct _rename_obj_rename{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *newname;         /* string for 'newname'*/
kform_struct *newname_struct;  /* pass to xvf_set_attributes() */

int          dorename;          /* TRUE when user clicks on 'dorename'*/
kform_struct *dorename_struct;  /* pass to xvf_set_attributes() */

kform_struct *tblabel_struct; /* pass to xvf_set_attributes() */

kform_struct *olabel_struct; /* pass to xvf_set_attributes() */

kform_struct *tbname_struct; /* pass to xvf_set_attributes() */

kform_struct *oname_struct; /* pass to xvf_set_attributes() */

} rename_obj_rename;

/*
 * Subform Info Struct for 'rename_obj' Subform
 */
typedef struct _craftsman_rename_obj {

rename_obj_rename  *rename;          /* ptr to Pane Info struct for pane 'rename' */
int               rename_selected;          /* TRUE if input was from pane 'rename' */
kform_struct      *rename_struct;          /* pass to xvf_set_attributes() */

}  craftsman_rename_obj;

/*
 * Pane Info Struct for 'infopane' Pane
 */
typedef struct _objinfo_infopane{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          todo;          /* TRUE when user clicks on 'todo'*/
kform_struct *todo_struct;  /* pass to xvf_set_attributes() */

int          crtodo;          /* TRUE when user clicks on 'crtodo'*/
kform_struct *crtodo_struct;  /* pass to xvf_set_attributes() */

int          bugs;          /* TRUE when user clicks on 'bugs'*/
kform_struct *bugs_struct;  /* pass to xvf_set_attributes() */

int          crbugs;          /* TRUE when user clicks on 'crbugs'*/
kform_struct *crbugs_struct;  /* pass to xvf_set_attributes() */

int          done;          /* TRUE when user clicks on 'done'*/
kform_struct *done_struct;  /* pass to xvf_set_attributes() */

int          crdone;          /* TRUE when user clicks on 'crdone'*/
kform_struct *crdone_struct;  /* pass to xvf_set_attributes() */

int          changelog;          /* TRUE when user clicks on 'changelog'*/
kform_struct *changelog_struct;  /* pass to xvf_set_attributes() */

int          crchangelog;          /* TRUE when user clicks on 'crchangelog'*/
kform_struct *crchangelog_struct;  /* pass to xvf_set_attributes() */

kform_struct *tblabel_struct; /* pass to xvf_set_attributes() */

kform_struct *olabel_struct; /* pass to xvf_set_attributes() */

kform_struct *tbname_struct; /* pass to xvf_set_attributes() */

kform_struct *oname_struct; /* pass to xvf_set_attributes() */

kform_struct *todo_blank_struct; /* pass to xvf_set_attributes() */

kform_struct *bugs_blank_struct; /* pass to xvf_set_attributes() */

kform_struct *done_blank_struct; /* pass to xvf_set_attributes() */

kform_struct *changelog_blank_struct; /* pass to xvf_set_attributes() */

} objinfo_infopane;

/*
 * Subform Info Struct for 'objinfo' Subform
 */
typedef struct _craftsman_objinfo {

objinfo_infopane  *infopane;          /* ptr to Pane Info struct for pane 'infopane' */
int              infopane_selected;          /* TRUE if input was from pane 'infopane' */
kform_struct     *infopane_struct;          /* pass to xvf_set_attributes() */

}  craftsman_objinfo;

/*
 * Form Info Struct for 'craftsman' form
 */
typedef struct _gui_info_struct {

kform_struct *options_struct; /* submenu button, pass to xvf_set_attributes() */

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          tblist;          /* int value of 'tblist'*/
char         *tblist_label;   /* label representing int value of 'tblist'*/
kform_struct *tblist_struct;  /* pass to xvf_set_attributes() */
int          tblist_selected; /* TRUE on <cr> for 'tblist' */

int          objlist;          /* int value of 'objlist'*/
char         *objlist_label;   /* label representing int value of 'objlist'*/
kform_struct *objlist_struct;  /* pass to xvf_set_attributes() */
int          objlist_selected; /* TRUE on <cr> for 'objlist' */
int          objlist_dblclick;   /* TRUE for double click on list */

kform_struct *tbops_struct; /* submenu button, pass to xvf_set_attributes() */

int          mkmanual;          /* TRUE when user clicks on 'mkmanual'*/
kform_struct *mkmanual_struct;  /* pass to xvf_set_attributes() */

int          dereftb;          /* TRUE when user clicks on 'dereftb'*/
kform_struct *dereftb_struct;  /* pass to xvf_set_attributes() */

int          klinttb;          /* TRUE when user clicks on 'klinttb'*/
kform_struct *klinttb_struct;  /* pass to xvf_set_attributes() */

int          rmtb;          /* TRUE when user clicks on 'rmtb'*/
kform_struct *rmtb_struct;  /* pass to xvf_set_attributes() */

kform_struct *objops_struct; /* submenu button, pass to xvf_set_attributes() */

int          open;          /* TRUE when user clicks on 'open'*/
kform_struct *open_struct;  /* pass to xvf_set_attributes() */

int          klintobj;          /* TRUE when user clicks on 'klintobj'*/
kform_struct *klintobj_struct;  /* pass to xvf_set_attributes() */

int          delete;          /* TRUE when user clicks on 'delete'*/
kform_struct *delete_struct;  /* pass to xvf_set_attributes() */

kform_struct *pixmap_struct; /* pass to xvf_set_attributes() */

craftsman_preferences  *preferences;
int preferences_selected;
kform_struct *preferences_struct;

craftsman_console  *console;
int console_selected;
kform_struct *console_struct;

craftsman_newtb  *newtb;
int newtb_selected;
kform_struct *newtb_struct;

craftsman_tbaddref  *tbaddref;
int tbaddref_selected;
kform_struct *tbaddref_struct;

craftsman_tbattrs  *tbattrs;
int tbattrs_selected;
kform_struct *tbattrs_struct;

craftsman_template  *template;
int template_selected;
kform_struct *template_struct;

craftsman_obj_attributes  *obj_attributes;
int obj_attributes_selected;
kform_struct *obj_attributes_struct;

craftsman_copyobject  *copyobject;
int copyobject_selected;
kform_struct *copyobject_struct;

craftsman_mvobject  *mvobject;
int mvobject_selected;
kform_struct *mvobject_struct;

craftsman_rename_obj  *rename_obj;
int rename_obj_selected;
kform_struct *rename_obj_struct;

craftsman_objinfo  *objinfo;
int objinfo_selected;
kform_struct *objinfo_struct;


kform_struct *craftsman_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void craftsman_tblist	PROTO((gui_info_struct *));
void craftsman_objlist	PROTO((gui_info_struct *));
void craftsman_objlist_dblclick     PROTO((gui_info_struct *));
void craftsman_mkmanual	PROTO((gui_info_struct *));
void craftsman_dereftb	PROTO((gui_info_struct *));
void craftsman_klinttb	PROTO((gui_info_struct *));
void craftsman_rmtb	PROTO((gui_info_struct *));
void craftsman_open	PROTO((gui_info_struct *));
void craftsman_klintobj	PROTO((gui_info_struct *));
void craftsman_delete	PROTO((gui_info_struct *));
void _xvf_free_craftsman PROTO((gui_info_struct *));
void _xvf_get_craftsman  PROTO((gui_info_struct *));

int  _xvf_init_craftsman PROTO((kform *, gui_info_struct *));
void run_craftsman       PROTO((kform *, ksubform *, kaddr));

void run_preferences      PROTO((craftsman_preferences *));
void _xvf_get_preferences PROTO((craftsman_preferences *));

void run_types      PROTO((preferences_types *));
void _xvf_get_types PROTO((preferences_types *));
void types_objtypes	PROTO((preferences_types *));
void types_cattype	PROTO((preferences_types *));

void run_console      PROTO((craftsman_console *));
void _xvf_get_console PROTO((craftsman_console *));

void run_conspane      PROTO((console_conspane *));
void _xvf_get_conspane PROTO((console_conspane *));
void conspane_clear	PROTO((console_conspane *));

void run_newtb      PROTO((craftsman_newtb *));
void _xvf_get_newtb PROTO((craftsman_newtb *));

void run_mktb      PROTO((newtb_mktb *));
void _xvf_get_mktb PROTO((newtb_mktb *));
void mktb_createtb	PROTO((newtb_mktb *));

void run_tbaddref      PROTO((craftsman_tbaddref *));
void _xvf_get_tbaddref PROTO((craftsman_tbaddref *));

void run_addref      PROTO((tbaddref_addref *));
void _xvf_get_addref PROTO((tbaddref_addref *));
void addref_addit	PROTO((tbaddref_addref *));

void run_tbattrs      PROTO((craftsman_tbattrs *));
void _xvf_get_tbattrs PROTO((craftsman_tbattrs *));

void run_strings      PROTO((tbattrs_strings *));
void _xvf_get_strings PROTO((tbattrs_strings *));
void strings_apply	PROTO((tbattrs_strings *));

void run_keywords      PROTO((tbattrs_keywords *));
void _xvf_get_keywords PROTO((tbattrs_keywords *));
void keywords_keylist	PROTO((tbattrs_keywords *));
void keywords_delete	PROTO((tbattrs_keywords *));
void keywords_addkey	PROTO((tbattrs_keywords *));
void keywords_chkey	PROTO((tbattrs_keywords *));

void run_flags      PROTO((tbattrs_flags *));
void _xvf_get_flags PROTO((tbattrs_flags *));
void flags_flags_apply	PROTO((tbattrs_flags *));

void run_copyright      PROTO((tbattrs_copyright *));
void _xvf_get_copyright PROTO((tbattrs_copyright *));
void copyright_copyright_apply	PROTO((tbattrs_copyright *));

void run_files      PROTO((tbattrs_files *));
void _xvf_get_files PROTO((tbattrs_files *));
void files_config	PROTO((tbattrs_files *));
void files_tbinclude	PROTO((tbattrs_files *));
void files_tbinfo	PROTO((tbattrs_files *));
void files_tbaliases	PROTO((tbattrs_files *));
void files_tbtodo	PROTO((tbattrs_files *));
void files_tbchangelog	PROTO((tbattrs_files *));

void run_template      PROTO((craftsman_template *));
void _xvf_get_template PROTO((craftsman_template *));

void run_kroutine      PROTO((template_kroutine *));
void _xvf_get_kroutine PROTO((template_kroutine *));
void kroutine_lib_routine	PROTO((template_kroutine *));
void kroutine_lib_list	PROTO((template_kroutine *));
void kroutine_create_kroutine	PROTO((template_kroutine *));

void run_xvroutine      PROTO((template_xvroutine *));
void _xvf_get_xvroutine PROTO((template_xvroutine *));
void xvroutine_create_xvroutine	PROTO((template_xvroutine *));

void run_library      PROTO((template_library *));
void _xvf_get_library PROTO((template_library *));
void library_create_library	PROTO((template_library *));

void run_script      PROTO((template_script *));
void _xvf_get_script PROTO((template_script *));
void script_create_script	PROTO((template_script *));

void run_pane      PROTO((template_pane *));
void _xvf_get_pane PROTO((template_pane *));
void pane_create_pane	PROTO((template_pane *));

void run_obj_attributes      PROTO((craftsman_obj_attributes *));
void _xvf_get_obj_attributes PROTO((craftsman_obj_attributes *));

void run_obj_attrs      PROTO((obj_attributes_obj_attrs *));
void _xvf_get_obj_attrs PROTO((obj_attributes_obj_attrs *));
void obj_attrs_apply	PROTO((obj_attributes_obj_attrs *));

void run_obj_keywords      PROTO((obj_attributes_obj_keywords *));
void _xvf_get_obj_keywords PROTO((obj_attributes_obj_keywords *));
void obj_keywords_keylist	PROTO((obj_attributes_obj_keywords *));
void obj_keywords_delete	PROTO((obj_attributes_obj_keywords *));
void obj_keywords_addkey	PROTO((obj_attributes_obj_keywords *));
void obj_keywords_chkey	PROTO((obj_attributes_obj_keywords *));

void run_paneattrs      PROTO((obj_attributes_paneattrs *));
void _xvf_get_paneattrs PROTO((obj_attributes_paneattrs *));
void paneattrs_apply	PROTO((obj_attributes_paneattrs *));

void run_copyobject      PROTO((craftsman_copyobject *));
void _xvf_get_copyobject PROTO((craftsman_copyobject *));

void run_copy      PROTO((copyobject_copy *));
void _xvf_get_copy PROTO((copyobject_copy *));
void copy_docopy	PROTO((copyobject_copy *));

void run_mvobject      PROTO((craftsman_mvobject *));
void _xvf_get_mvobject PROTO((craftsman_mvobject *));

void run_move      PROTO((mvobject_move *));
void _xvf_get_move PROTO((mvobject_move *));
void move_domove	PROTO((mvobject_move *));

void run_rename_obj      PROTO((craftsman_rename_obj *));
void _xvf_get_rename_obj PROTO((craftsman_rename_obj *));

void run_rename      PROTO((rename_obj_rename *));
void _xvf_get_rename PROTO((rename_obj_rename *));
void rename_dorename	PROTO((rename_obj_rename *));

void run_objinfo      PROTO((craftsman_objinfo *));
void _xvf_get_objinfo PROTO((craftsman_objinfo *));

void run_infopane      PROTO((objinfo_infopane *));
void _xvf_get_infopane PROTO((objinfo_infopane *));
void infopane_todo	PROTO((objinfo_infopane *));
void infopane_crtodo	PROTO((objinfo_infopane *));
void infopane_bugs	PROTO((objinfo_infopane *));
void infopane_crbugs	PROTO((objinfo_infopane *));
void infopane_done	PROTO((objinfo_infopane *));
void infopane_crdone	PROTO((objinfo_infopane *));
void infopane_changelog	PROTO((objinfo_infopane *));
void infopane_crchangelog	PROTO((objinfo_infopane *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
