/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane rename
   >>>> 
   >>>>  Private: 
   >>>> 	rename_domove
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name: rename_dorename
| 
| Purpose:	Do routine which is called when
|                  pane action button dorename is used
| 
| Input:	rename_info - ptr to PaneInfo struct for rename pane
| 
| Written By:	Neil Bowers
| Date:		10-jul-94
------------------------------------------------------------*/
void
rename_dorename(
   rename_obj_rename *rename_info)
{
   kstring  routine = "rename_dorename()";
   kbool    status  = FALSE;
   kobject  object;


   if (strObject == NULL)
   {
      kerror(NULL, routine,
	     "You have not selected a software object to rename.");
      return;
   }

   if ((object = kcms_open_cmobj(cmsToolbox, strObject)) == NULL)
   {
      kerror(NULL, routine, "Failed to open software object `%s' "
	     "in toolbox `%s'.", strObject, strToolbox);
      return;
   }

   if (!kprompt(KFORCE, "Yes", "No", FALSE,
		"Operation: rename software object\n\n"
		"\tToolbox  : %s\n"
		"\tObject   : %s\n\n"
		"\tNew Name : %s\n\n"
		"Do you want to rename this object?",
		strToolbox, strObject, rename_info->newname))
      return;

   /*-- popup the notifier window -------------------------------------*/
   xvw_set_attributes(xvoNotifier,
		     XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		     XVW_NOTIFYWINDOW_LABEL,   "Renaming Software Object",
		     XVW_NOTIFYWINDOW_MESSAGE, "renaming object",
		     NULL);

   /*-- set force-flag to TRUE, to suppress prompting -----------------*/
   kcms_set_bit(object, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);

   if (kcms_rename(object, rename_info->newname))
   {
      status = kgen_generate_object(object);
   }
   kcms_close(object);

   /*-- reload the toolbox to get object list right --*/
   update_object_list();
   select_object(rename_info->newname);

   /*-- pop down the notifier window ----------------------------------*/
   xvw_set_attributes(xvoNotifier,
		      XVW_NOTIFYWINDOW_VISIBLE, FALSE,
		      XVW_NOTIFYWINDOW_LABEL,   "Please Wait",
		      NULL);
}
